/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species;

import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyCellComponent;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class EditSpeciesBatchPanelUIHandler
extends AbstractTuttiUIHandler<EditSpeciesBatchPanelUIModel, EditSpeciesBatchPanelUI> {
    private static final Log log = LogFactory.getLog(EditSpeciesBatchPanelUIHandler.class);
    protected SpeciesOrBenthosBatchUISupport speciesOrBenthosBatchUISupport;

    public void onCloseUI() {
        this.closeUI(((EditSpeciesBatchPanelUI)this.ui).getEditBatchesUI());
        this.closeUI(((EditSpeciesBatchPanelUI)this.ui).getEditFrequenciesUI());
    }

    public void beforeInit(EditSpeciesBatchPanelUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.speciesOrBenthosBatchUISupport = ui.getContextValue(SpeciesOrBenthosBatchUISupport.class, ui.getSpeciesOrBenthosContext());
        EditSpeciesBatchPanelUIModel model = new EditSpeciesBatchPanelUIModel(this.speciesOrBenthosBatchUISupport);
        ui.setContextValue(model);
    }

    public void afterInit(EditSpeciesBatchPanelUI editSpeciesBatchPanelUI) {
        ((EditSpeciesBatchPanelUI)this.ui).getSplitBatchUI().getModel().setSplitMode(true);
        ((EditSpeciesBatchPanelUI)this.ui).getAddSampleCategoryBatch().getModel().setSplitMode(false);
    }

    public SwingValidator<EditSpeciesBatchPanelUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void editSpeciesFrequencies(int rowIndex) {
        JXTable speciesTable = ((EditSpeciesBatchPanelUI)this.ui).getEditBatchesUI().getTable();
        TableColumn frequenciesColumn = speciesTable.getColumn(SpeciesBatchTableModel.COMPUTED_NUMBER);
        int frequenciesColumnIndex = speciesTable.getColumns(false).indexOf(frequenciesColumn);
        SpeciesFrequencyCellComponent.FrequencyCellEditor frequencyCellEditor = (SpeciesFrequencyCellComponent.FrequencyCellEditor)speciesTable.getCellEditor(rowIndex, frequenciesColumnIndex);
        frequencyCellEditor.initEditor((JTable)speciesTable, rowIndex, frequenciesColumnIndex);
        frequencyCellEditor.startEdit();
    }

    public void editSpeciesFrequencies(SpeciesFrequencyCellComponent.FrequencyCellEditor editor) {
        SpeciesFrequencyUI frequencyEditor = ((EditSpeciesBatchPanelUI)this.ui).getEditFrequenciesUI();
        SpeciesBatchRowModel editRow = editor.getEditRow();
        String editBatchTitle = ((EditSpeciesBatchPanelUI)this.ui).getEditBatchesUIPanel().getTitle();
        String frequenciesTitle = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, editBatchTitle, "", false);
        frequencyEditor.getHandler().editBatch(editor, frequenciesTitle);
        SpeciesFrequencyUIModel model = frequencyEditor.getModel();
        try {
            int fishingOperationId = model.getFishingOperation().getIdAsInt();
            int taxonId = model.getBatch().getSpecies().getReferenceTaxonId();
            Map map = this.getPersistenceService().getPrevOperationNameAndBatchId(fishingOperationId, taxonId);
            model.setCanGoPrevBatch(map != null);
            map = this.getPersistenceService().getNextOperationNameAndBatchId(fishingOperationId, taxonId);
            model.setCanGoNextBatch(map != null);
        }
        catch (Exception eee) {
            log.warn((Object)"Can't check navigation between batch", (Throwable)eee);
            model.setCanGoPrevBatch(false);
            model.setCanGoNextBatch(false);
        }
        ((EditSpeciesBatchPanelUI)this.ui).switchToEditFrequency();
        String title = this.buildReminderLabelTitle(editRow.getSpecies(), editRow, editBatchTitle, I18n.t((String)"tutti.editSpeciesFrequencies.title", (Object[])new Object[0]));
        ((EditSpeciesBatchPanelUI)this.ui).getEditFrequenciesUIPanel().setTitle(title);
    }

    protected void setSpeciesSelectedCard(String card) {
        CardLayout2Ext layout = (CardLayout2Ext)((EditSpeciesBatchPanelUI)this.ui).getLayout();
        if (!card.equals(layout.getSelected())) {
            layout.setSelected(card);
            EditCatchesUI parentContainer = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
            Table actionPanel = parentContainer.getCreateFishingOperationActions();
            actionPanel.setVisible(false);
            Object validator = null;
            switch (card) {
                case "editBatch": {
                    actionPanel.setVisible(true);
                    break;
                }
                case "createBatch": {
                    validator = ((EditSpeciesBatchPanelUI)this.ui).getCreateBatchUI().getValidator();
                    String title = I18n.n((String)"tutti.createSpeciesBatch.title", (Object[])new Object[0]);
                    ((EditSpeciesBatchPanelUI)this.ui).getCreateBatchUIPanel().setTitle(((EditSpeciesBatchPanelUI)this.ui).getEditBatchesUIPanel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                    break;
                }
                case "splitBatch": {
                    validator = ((EditSpeciesBatchPanelUI)this.ui).getSplitBatchUI().getValidator();
                    break;
                }
                case "addSampleCategoryBatch": {
                    validator = ((EditSpeciesBatchPanelUI)this.ui).getAddSampleCategoryBatch().getValidator();
                    break;
                }
                case "editFrequency": {
                    validator = ((EditSpeciesBatchPanelUI)this.ui).getEditFrequenciesUI().getValidator();
                }
            }
            if (validator != null) {
                this.registerValidators(new SwingValidator[]{validator});
            }
        }
    }
}

