/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.util;

import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.administration.user.PersonImpl;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.Operation;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.vessel.feature.person.VesselPersonFeatures;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRole;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRoleId;
import fr.ifremer.adagio.core.dao.referential.VesselPersonRoleImpl;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="vesselPersonFeaturesPersistenceHelper")
public class VesselPersonFeaturesPersistenceHelper
extends AbstractPersistenceService {
    private static final Log log = LogFactory.getLog(VesselPersonFeaturesPersistenceHelper.class);

    public VesselPersonRole getScientificCruiseManagerRole() {
        return (VesselPersonRole)this.load(VesselPersonRoleImpl.class, VesselPersonRoleId.SCIENTIFIC_CRUISE_MANAGER.getValue());
    }

    public VesselPersonRole getSortRoomManagerRole() {
        return (VesselPersonRole)this.load(VesselPersonRoleImpl.class, VesselPersonRoleId.SORT_ROOM_MANAGER.getValue());
    }

    public VesselPersonRole getRecorderPersonRole() {
        return (VesselPersonRole)this.load(VesselPersonRoleImpl.class, VesselPersonRoleId.RECORDER_PERSON.getValue());
    }

    public void fillVesselPersonFeatures(Map<Integer, VesselPersonFeatures> vesselPersonFeaturesPerPerson, Integer personId, FishingTrip fishingTrip, VesselPersonRole role, short rankOrder) {
        VesselPersonFeatures vesselPersonFeatures = vesselPersonFeaturesPerPerson.get(personId);
        if (vesselPersonFeatures == null) {
            PersonImpl person = this.load(PersonImpl.class, personId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create an new vesselPersonFeatures for person: [" + personId + "]" + person.getFirstname() + " - " + person.getLastname()));
            }
            vesselPersonFeatures = VesselPersonFeatures.Factory.newInstance();
            vesselPersonFeaturesPerPerson.put(personId, vesselPersonFeatures);
            vesselPersonFeatures.setPerson((Person)person);
            vesselPersonFeatures.setFishingTrip(fishingTrip);
            vesselPersonFeatures.setStartDate(fishingTrip.getDepartureDateTime());
            vesselPersonFeatures.setEndDate(fishingTrip.getReturnDateTime());
            vesselPersonFeatures.setVessel(fishingTrip.getVessel());
            vesselPersonFeatures.setProgram(fishingTrip.getProgram());
            vesselPersonFeatures.setCreationDate(fishingTrip.getCreationDate());
            vesselPersonFeatures.setQualityFlag(fishingTrip.getQualityFlag());
            vesselPersonFeatures.setRankOrder(Short.valueOf(rankOrder));
        }
        this.addRole(role, vesselPersonFeatures);
    }

    public void fillVesselPersonFeatures(Map<Integer, VesselPersonFeatures> vesselPersonFeaturesPerPerson, Integer personId, FishingOperation fishingOperation, VesselPersonRole role, short rankOrder) {
        VesselPersonFeatures vesselPersonFeatures = vesselPersonFeaturesPerPerson.get(personId);
        if (vesselPersonFeatures == null) {
            PersonImpl person = this.load(PersonImpl.class, personId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Create an new vesselPersonFeatures for person: [" + personId + "]" + person.getFirstname() + " - " + person.getLastname()));
            }
            vesselPersonFeatures = VesselPersonFeatures.Factory.newInstance();
            vesselPersonFeaturesPerPerson.put(personId, vesselPersonFeatures);
            vesselPersonFeatures.setOperation((Operation)fishingOperation);
            vesselPersonFeatures.setPerson((Person)person);
            vesselPersonFeatures.setStartDate(fishingOperation.getStartDateTime());
            vesselPersonFeatures.setEndDate(fishingOperation.getEndDateTime());
            vesselPersonFeatures.setVessel(fishingOperation.getVessel());
            vesselPersonFeatures.setProgram(fishingOperation.getFishingTrip().getProgram());
            vesselPersonFeatures.setCreationDate(new Date());
            vesselPersonFeatures.setQualityFlag(fishingOperation.getQualityFlag());
            vesselPersonFeatures.setRankOrder(Short.valueOf(rankOrder));
        }
        this.addRole(role, vesselPersonFeatures);
    }

    protected void addRole(VesselPersonRole role, VesselPersonFeatures vesselPersonFeatures) {
        Person person = vesselPersonFeatures.getPerson();
        if (vesselPersonFeatures.getVesselPersonRoles().contains(role)) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("vessel person feature for person: " + person.getId() + " with role: " + role.getName() + " already exist, do not add it twice."));
            }
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Add vessel person feature for person: " + person.getId() + " with role: " + role.getName()));
            }
            vesselPersonFeatures.getVesselPersonRoles().add(role);
        }
    }
}

