/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.LabelAware;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.service.ValidationService;
import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.UIMessageNotifier;
import fr.ifremer.tutti.ui.swing.util.actions.ShowComboBoxPopupActions;
import fr.ifremer.tutti.ui.swing.util.attachment.ButtonAttachment;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimerTask;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.swing.JAXXWidgetUtil;
import jaxx.runtime.swing.editor.cell.NumberCellEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTitledPanel;
import org.jdesktop.swingx.decorator.FontHighlighter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.AbstractApplicationUIHandler;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUI;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.jaxx.application.swing.util.ActionListCellRenderer;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public abstract class AbstractTuttiUIHandler<M, UI extends TuttiUI<M, ?>>
extends AbstractApplicationUIHandler<M, UI>
implements UIMessageNotifier {
    private static final Log log = LogFactory.getLog(AbstractTuttiUIHandler.class);
    public static final String CAN_EDIT = "_canEdit_";

    @Override
    public void showInformationMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    public TuttiUIContext getContext() {
        return (TuttiUIContext)super.getContext();
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    public TuttiConfiguration getConfig() {
        return this.getContext().getConfig();
    }

    public PersistenceService getPersistenceService() {
        return this.getContext().getPersistenceService();
    }

    public ValidationService getValidationService() {
        return this.getContext().getValidationService();
    }

    public ValidateCruiseOperationsService getValidateCruiseOperationsService() {
        return this.getContext().getValidateCruiseOperationsService();
    }

    public Component getTopestUI() {
        ApplicationActionUI result = this.getContext().getActionUI();
        return result;
    }

    public void clearValidators() {
        MainUI main = this.getContext().getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
    }

    public String getWeightStringValue(JComponent component, Float weight) {
        WeightUnit weightUnit = (WeightUnit)component.getClientProperty("addWeightUnit");
        Objects.requireNonNull(weightUnit, "can't find addWeightUnit client property on component: " + component);
        return weightUnit.renderWeight(weight);
    }

    public <O> Decorator<O> getDecorator(Class<O> type, String name) {
        DecoratorService decoratorService = this.getContext().getDecoratorService();
        Preconditions.checkNotNull(type);
        Decorator<LabelAware> decorator = decoratorService.getDecoratorByType(type, name);
        if (decorator == null && LabelAware.class.isAssignableFrom(type)) {
            decorator = this.getDecorator(LabelAware.class, null);
        }
        Preconditions.checkNotNull((Object)decorator);
        return decorator;
    }

    protected void addHighlighters(JXTable table) {
        HighlightPredicate.NotHighlightPredicate notSelectedPredicate = new HighlightPredicate.NotHighlightPredicate(HighlightPredicate.IS_SELECTED);
        HighlightPredicate rowIsInvalidPredicate = (renderer, adapter) -> {
            boolean result = false;
            if (adapter.isEditable()) {
                int viewRow;
                int modelRow;
                AbstractApplicationTableModel model = (AbstractApplicationTableModel)table.getModel();
                AbstractTuttiBeanUIModel row = (AbstractTuttiBeanUIModel)((Object)((Object)model.getEntry(modelRow = adapter.convertRowIndexToModel(viewRow = adapter.row))));
                result = !row.isValid();
            }
            return result;
        };
        HighlightPredicate.NotHighlightPredicate rowIsValidPredicate = new HighlightPredicate.NotHighlightPredicate(rowIsInvalidPredicate);
        Highlighter selectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)HighlightPredicate.IS_SELECTED, (Color)this.getConfig().getColorSelectedRow());
        table.addHighlighter(selectedHighlighter);
        Highlighter readOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.READ_ONLY, notSelectedPredicate}), (Color)this.getConfig().getColorRowReadOnly());
        table.addHighlighter(readOnlyHighlighter);
        Highlighter readOnlySelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.READ_ONLY, HighlightPredicate.IS_SELECTED}), (Color)this.getConfig().getColorRowReadOnly().darker());
        table.addHighlighter(readOnlySelectedHighlighter);
        Highlighter validHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EDITABLE, notSelectedPredicate, rowIsInvalidPredicate}), (Color)this.getConfig().getColorRowInvalid());
        table.addHighlighter(validHighlighter);
        Highlighter validSelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.EDITABLE, HighlightPredicate.IS_SELECTED, rowIsInvalidPredicate}), (Color)this.getConfig().getColorRowInvalid().darker());
        table.addHighlighter(validSelectedHighlighter);
        Highlighter evenHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.ODD, notSelectedPredicate, rowIsValidPredicate, HighlightPredicate.READ_ONLY}), (Color)this.getConfig().getColorAlternateRow().darker());
        table.addHighlighter(evenHighlighter);
        Highlighter evenNotReadOnlyHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.ODD, notSelectedPredicate, rowIsValidPredicate, HighlightPredicate.EDITABLE}), (Color)this.getConfig().getColorAlternateRow());
        table.addHighlighter(evenNotReadOnlyHighlighter);
        Highlighter evenSelectedHighlighter = TuttiUIUtil.newBackgroundColorHighlighter((HighlightPredicate)new HighlightPredicate.AndHighlightPredicate(new HighlightPredicate[]{HighlightPredicate.ODD, HighlightPredicate.IS_SELECTED, rowIsValidPredicate, HighlightPredicate.EDITABLE}), (Color)this.getConfig().getColorSelectedRow());
        table.addHighlighter(evenSelectedHighlighter);
        Font font = table.getFont().deriveFont(1);
        FontHighlighter selectHighlighter = new FontHighlighter(HighlightPredicate.IS_SELECTED, font);
        table.addHighlighter((Highlighter)selectHighlighter);
    }

    protected void listenModelModifiy(AbstractTuttiBeanUIModel model) {
        model.addPropertyChangeListener("modify", evt -> {
            Boolean modify = (Boolean)evt.getNewValue();
            if (modify != null && modify.booleanValue()) {
                ((AbstractTuttiBeanUIModel)((Object)((Object)this.getModel()))).setModify(true);
            }
        });
    }

    protected void initUIComponent(Object component) {
        if (component instanceof NumberEditor) {
            this.initNumberEditor((NumberEditor)component);
        } else if (component instanceof JXTitledPanel) {
            this.initJXTitledPanel((JXTitledPanel)component);
        } else if (component instanceof ButtonAttachment) {
            this.initButtonAttachment((ButtonAttachment)component);
        } else if (component instanceof JComboBox) {
            this.initComboBox((JComboBox)component);
        } else {
            super.initUIComponent(component);
        }
    }

    private void initComboBox(JComboBox<?> comboBox) {
        super.initUIComponent(comboBox);
        List comboboxActions = (List)comboBox.getClientProperty("comboboxActions");
        if (comboboxActions != null) {
            comboBox.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            comboBox.addMouseListener(TuttiUIUtil.GRAB_FOCUS_ON_ENTER_LISTENER);
            comboBox.setRenderer((ListCellRenderer<?>)new ActionListCellRenderer());
            comboBox.setModel(new DefaultComboBoxModel<Object>(comboboxActions.toArray()));
            comboBox.addPropertyChangeListener("enabled", evt -> {
                JComboBox source = (JComboBox)evt.getSource();
                source.setFocusable((Boolean)evt.getNewValue());
            });
            comboBox.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    if (source.isEnabled()) {
                        ShowComboBoxPopupActions task = new ShowComboBoxPopupActions(source);
                        try {
                            AbstractTuttiUIHandler.this.getContext().getTimer().schedule((TimerTask)task, 300L);
                        }
                        catch (IllegalStateException e1) {
                            AbstractTuttiUIHandler.this.getContext().reloadTimer().schedule((TimerTask)task, 300L);
                        }
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    JComboBox source = (JComboBox)e.getSource();
                    if (source.isEnabled()) {
                        AbstractButton action = (AbstractButton)source.getItemAt(0);
                        AbstractTuttiUIHandler.this.getContext().getActionEngine().runAction(action);
                    }
                }
            });
            comboBox.addActionListener(e -> {
                JComboBox source = (JComboBox)e.getSource();
                Boolean canEdit = (Boolean)source.getClientProperty(CAN_EDIT);
                if (canEdit == null || canEdit.booleanValue()) {
                    JButton selectedAction = (JButton)source.getSelectedItem();
                    source.setSelectedIndex(0);
                    source.hidePopup();
                    this.getContext().getActionEngine().runAction((AbstractButton)selectedAction);
                }
            });
        }
    }

    public void resetComboBoxAction(JComboBox source) {
        source.putClientProperty(CAN_EDIT, false);
        try {
            source.setSelectedIndex(0);
        }
        finally {
            source.putClientProperty(CAN_EDIT, null);
        }
    }

    protected void initJXTitledPanel(JXTitledPanel jTextField) {
    }

    protected void initTextField(JTextField jTextField) {
        super.initTextField(jTextField);
        Boolean computed = (Boolean)jTextField.getClientProperty("computed");
        if (computed != null && computed.booleanValue()) {
            Font font = jTextField.getFont().deriveFont(2);
            jTextField.setFont(font);
            jTextField.setEditable(false);
            jTextField.setEnabled(false);
            jTextField.setDisabledTextColor(this.getConfig().getColorComputedWeights());
        }
    }

    protected void initButtonAttachment(ButtonAttachment component) {
        component.init();
    }

    protected void initLabel(JLabel jLabel) {
        WeightUnit weightUnit = (WeightUnit)jLabel.getClientProperty("addWeightUnit");
        if (weightUnit != null) {
            String text = weightUnit.decorateLabel(jLabel.getText());
            jLabel.setText(text);
            String tip = weightUnit.decorateTip(jLabel.getToolTipText());
            jLabel.setToolTipText(tip);
            Component labelFor = jLabel.getLabelFor();
            if (labelFor instanceof ComputableDataEditor) {
                ComputableDataEditor editor = (ComputableDataEditor)((Object)labelFor);
                editor.setWeightUnit(weightUnit);
            } else if (labelFor instanceof NumberEditor) {
                NumberEditor editor = (NumberEditor)labelFor;
                editor.setNumberPattern(weightUnit.getNumberEditorPattern());
            }
        }
    }

    protected void initButton(AbstractButton abstractButton) {
        super.initButton(abstractButton);
        TuttiUIUtil.initButton(this.getContext(), (JAXXObject)this.getUI(), abstractButton);
    }

    protected void initNumberEditor(NumberEditor editor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("init number editor " + editor.getName()));
        }
        editor.init();
        Number model = editor.getModel().getNumberValue();
        if (model != null) {
            editor.setNumberValue(null);
            editor.setNumberValue(model);
        }
        if (this.isAutoSelectOnFocus((JComponent)editor)) {
            this.addAutoSelectOnFocus(editor.getTextField());
        }
    }

    public String buildReminderLabelTitle(Species species, Iterable<SampleCategory<?>> categories, String prefix, String suffix) {
        return this.buildReminderLabelTitle(species, categories, prefix, suffix, true);
    }

    public String buildReminderLabelTitle(Species species, Iterable<SampleCategory<?>> categories, String prefix, String suffix, boolean html) {
        return this.buildReminderLabelTitle(this.decorate((Serializable)species, "withSurveyCode"), categories, prefix, suffix, html);
    }

    protected void registerValidators(SwingValidator ... validators) {
        MainUI main = this.getContext().getMainUI();
        Preconditions.checkNotNull((Object)main, (Object)"No mainUI registred in application context");
        MainUIHandler handler = main.getHandler();
        handler.clearValidators();
        for (SwingValidator validator : validators) {
            handler.registerValidator(validator);
        }
    }

    protected void listenValidatorValid(SimpleBeanValidator validator, AbstractTuttiBeanUIModel model) {
        validator.addPropertyChangeListener("valid", evt -> {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + evt.getNewValue() + "]"));
            }
            model.setValid((Boolean)evt.getNewValue());
        });
    }

    protected void listenValidationTableHasNoFatalError(SimpleBeanValidator validator, AbstractTuttiBeanUIModel model) {
        this.getContext().getMainUI().getValidatorMessageWidget().addTableModelListener(e -> {
            boolean valid;
            boolean bl = valid = !validator.hasFatalErrors();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Model [" + (Object)((Object)model) + "] pass to valid state [" + valid + "]"));
            }
            model.setValid(valid);
        });
    }

    protected void listModelIsModify(AbstractTuttiBeanUIModel model) {
        model.addPropertyChangeListener(new PropertyChangeListener(){
            final Set<String> excludeProperties;
            {
                this.excludeProperties = AbstractTuttiUIHandler.this.getPropertiesToIgnore();
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!this.excludeProperties.contains(evt.getPropertyName())) {
                    ((AbstractTuttiBeanUIModel)((Object)evt.getSource())).setModify(true);
                }
            }
        });
    }

    protected Set<String> getPropertiesToIgnore() {
        return Sets.newHashSet((Object[])new String[]{"modify", "valid"});
    }

    protected void closeUI(TuttiUI ui) {
        ui.getHandler().onCloseUI();
    }

    protected String buildReminderLabelTitle(String species, Iterable<SampleCategory<?>> categories, String prefix, String suffix) {
        return this.buildReminderLabelTitle(species, categories, prefix, suffix, true);
    }

    protected String buildReminderLabelTitle(String species, Iterable<SampleCategory<?>> categories, String prefix, String suffix, boolean html) {
        StringBuilder title = new StringBuilder();
        if (html) {
            title.append("<html><body style='color:black;'>");
        }
        title.append(prefix).append(" - [");
        if (html) {
            title.append("<strong>");
        }
        title.append(species);
        if (html) {
            title.append("</strong>");
        }
        title.append("]");
        if (categories != null) {
            for (SampleCategory<?> sampleCategory : categories) {
                if (sampleCategory.getCategoryValue() == null) continue;
                title.append(" - ");
                title.append(this.decorate(sampleCategory.getCategoryValue()));
            }
        }
        title.append(" - ").append(suffix);
        if (html) {
            title.append("</body></html>");
        }
        return title.toString();
    }

    protected <R> TableColumnExt addFloatColumnToModel(TableColumnModel model, ColumnIdentifier<R> identifier, WeightUnit weightUnit, JTable table) {
        Preconditions.checkNotNull((Object)weightUnit);
        NumberCellEditor editor = JAXXWidgetUtil.newNumberTableCellEditor(Float.class, (boolean)false);
        editor.getNumberEditor().setSelectAllTextOnError(Boolean.valueOf(true));
        editor.getNumberEditor().getTextField().setBorder(new LineBorder(Color.GRAY, 2));
        editor.getNumberEditor().setNumberPattern(weightUnit.getNumberEditorPattern());
        TableCellRenderer renderer = this.newWeightCellRenderer(table.getDefaultRenderer(Number.class), weightUnit);
        return this.addColumnToModel(model, (TableCellEditor)editor, renderer, identifier, weightUnit);
    }

    protected <R> TableColumnExt addColumnToModel(TableColumnModel model, TableCellEditor editor, TableCellRenderer renderer, ColumnIdentifier<R> identifier, WeightUnit weightUnit) {
        TableColumnExt col = new TableColumnExt(model.getColumnCount());
        col.setCellEditor(editor);
        col.setCellRenderer(renderer);
        String label = I18n.t((String)identifier.getHeaderI18nKey(), (Object[])new Object[0]);
        if (weightUnit != null) {
            label = weightUnit.decorateLabel(label);
        }
        col.setHeaderValue((Object)label);
        String tip = I18n.t((String)identifier.getHeaderTipI18nKey(), (Object[])new Object[0]);
        if (weightUnit != null) {
            tip = weightUnit.decorateTip(tip);
        }
        col.setToolTipText(tip);
        col.setIdentifier(identifier);
        model.addColumn((TableColumn)col);
        col.setSortable(false);
        return col;
    }

    protected TableCellRenderer newWeightCellRenderer(TableCellRenderer delegate, WeightUnit weightUnit) {
        return (table, value, isSelected, hasFocus, row, column) -> {
            Component result = delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (result instanceof JLabel) {
                JLabel jLabel = (JLabel)result;
                jLabel.setHorizontalTextPosition(4);
                jLabel.setText(weightUnit.renderWeight((Float)value));
            }
            return result;
        };
    }
}

