/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.category.actions;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportService;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelUI;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelUIHandler;
import fr.ifremer.tutti.ui.swing.content.category.EditSampleCategoryModelUIModel;
import fr.ifremer.tutti.ui.swing.content.referential.actions.ExportExistingTemporaryGearAction;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportSampleCategoryModelAction
extends LongActionSupport<EditSampleCategoryModelUIModel, EditSampleCategoryModelUI, EditSampleCategoryModelUIHandler> {
    private static final Log log = LogFactory.getLog(ExportExistingTemporaryGearAction.class);
    private File file;

    public ExportSampleCategoryModelAction(EditSampleCategoryModelUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile("sampleCategory", "csv", I18n.t((String)"tutti.exportSampleCategoryModel.title.choose.exportSampleCategoryModelFile", (Object[])new Object[0]), I18n.t((String)"tutti.exportSampleCategoryModel.action.chooseSampleCategoryModelFile.export", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export sample category model to file: " + this.file));
        }
        GenericFormatExportService service = this.getContext().getGenericFormatExportService();
        service.exportSampleCategoryModel(this.file);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.exportSampleCategoryModel.action.export.success", (Object[])new Object[]{this.file}));
    }
}

