/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Cruises;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.FishingOperations;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocols;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import fr.ifremer.tutti.persistence.model.CruiseDataModel;
import fr.ifremer.tutti.persistence.model.OperationDataModel;
import fr.ifremer.tutti.persistence.model.ProgramDataModel;
import fr.ifremer.tutti.persistence.service.AccidentalBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.BenthosBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.CruisePersistenceService;
import fr.ifremer.tutti.persistence.service.FishingOperationPersistenceService;
import fr.ifremer.tutti.persistence.service.IndividualObservationBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.MarineLitterBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.ProgramPersistenceService;
import fr.ifremer.tutti.persistence.service.ProtocolPersistenceService;
import fr.ifremer.tutti.persistence.service.SpeciesBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.TechnicalPersistenceService;
import fr.ifremer.tutti.persistence.service.TuttiPersistenceServiceLocator;
import fr.ifremer.tutti.persistence.service.UpdateSchemaContextSupport;
import fr.ifremer.tutti.persistence.service.referential.CaracteristicPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.GearPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.LocationPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.ObjectTypePersistenceService;
import fr.ifremer.tutti.persistence.service.referential.PersonPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import fr.ifremer.tutti.persistence.service.referential.VesselPersistenceService;
import fr.ifremer.tutti.util.Jdbcs;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.version.Version;

public class TuttiPersistenceImpl
implements TuttiPersistence {
    private static final Log log = LogFactory.getLog(TuttiPersistenceImpl.class);
    @Resource(name="caracteristicPersistenceService")
    protected CaracteristicPersistenceService caracteristicService;
    @Resource(name="gearPersistenceService")
    protected GearPersistenceService gearService;
    @Resource(name="locationPersistenceService")
    protected LocationPersistenceService locationService;
    @Resource(name="objectTypePersistenceService")
    protected ObjectTypePersistenceService objectTypeService;
    @Resource(name="personPersistenceService")
    protected PersonPersistenceService personService;
    @Resource(name="speciesPersistenceService")
    protected SpeciesPersistenceService speciesService;
    @Resource(name="vesselPersistenceService")
    protected VesselPersistenceService vesselService;
    @Resource(name="programPersistenceService")
    protected ProgramPersistenceService programService;
    @Resource(name="cruisePersistenceService")
    protected CruisePersistenceService cruiseService;
    @Resource(name="fishingOperationPersistenceService")
    protected FishingOperationPersistenceService fishingOperationService;
    @Resource(name="batchPersistenceService")
    protected CatchBatchPersistenceService catchBatchService;
    @Resource(name="speciesBatchPersistenceService")
    protected SpeciesBatchPersistenceService speciesBatchService;
    @Resource(name="benthosBatchPersistenceService")
    protected BenthosBatchPersistenceService benthosBatchService;
    @Resource(name="marineLitterBatchPersistenceService")
    protected MarineLitterBatchPersistenceService marineLitterBatchService;
    @Resource(name="accidentalBatchPersistenceService")
    protected AccidentalBatchPersistenceService accidentalBatchService;
    @Resource(name="individualObservationBatchPersistenceService")
    protected IndividualObservationBatchPersistenceService individualObservationBatchService;
    @Resource(name="protocolPersistenceService")
    protected ProtocolPersistenceService protocolService;
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentService;
    @Resource(name="technicalPersistenceService")
    protected TechnicalPersistenceService technicalPersistenceService;
    private boolean skipShutdownDbWhenClosing;
    protected boolean close;

    @Override
    public String getImplementationName() {
        return "Persistence Adagio implementation";
    }

    @Override
    public void setSkipShutdownDbWhenClosing() {
        this.skipShutdownDbWhenClosing = true;
    }

    @Override
    public void lazyInit() {
    }

    @Override
    public void clearAllCaches() {
        this.getTechnicalPersistenceService().clearAllCaches();
    }

    @Override
    public <V> V invoke(Callable<V> call) {
        return this.getTechnicalPersistenceService().invoke(call);
    }

    @Override
    public <U extends UpdateSchemaContextSupport> void prepareUpdateSchemaContext(U context) {
        this.getTechnicalPersistenceService().prepareUpdateSchemaContext(context);
    }

    @Override
    public Version getSchemaVersion() {
        return this.getTechnicalPersistenceService().getSchemaVersion();
    }

    @Override
    public Version getSchemaVersionIfUpdate() {
        return this.getTechnicalPersistenceService().getSchemaVersionIfUpdate();
    }

    @Override
    public void updateSchema() {
        this.getTechnicalPersistenceService().updateSchema();
    }

    @Override
    public void sanityDb() {
        this.getTechnicalPersistenceService().sanityDb();
    }

    @Override
    public boolean isTemporary(TuttiReferentialEntity entity) {
        return this.getTechnicalPersistenceService().isTemporary(entity);
    }

    @Override
    public void init() {
        if (log.isInfoEnabled()) {
            log.info((Object)("Open persistence driver " + this.getImplementationName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.close) {
            this.close = true;
            TuttiPersistenceImpl tuttiPersistenceImpl = this;
            synchronized (tuttiPersistenceImpl) {
                block11: {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Close persistence driver " + this.getImplementationName()));
                    }
                    this.caracteristicService.close();
                    this.gearService.close();
                    this.locationService.close();
                    this.objectTypeService.close();
                    this.personService.close();
                    this.speciesService.close();
                    this.vesselService.close();
                    this.programService.close();
                    this.cruiseService.close();
                    this.fishingOperationService.close();
                    this.catchBatchService.close();
                    this.speciesBatchService.close();
                    this.benthosBatchService.close();
                    this.marineLitterBatchService.close();
                    this.accidentalBatchService.close();
                    this.individualObservationBatchService.close();
                    this.protocolService.close();
                    this.attachmentService.close();
                    if (this.skipShutdownDbWhenClosing) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Skip to shutdown db while closing, lucky you...");
                        }
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info((Object)"Do shutdown db nicely");
                        }
                        try {
                            Jdbcs.shutdown(TuttiConfiguration.getInstance());
                        }
                        catch (SQLException e) {
                            if (!log.isErrorEnabled()) break block11;
                            log.error((Object)"Could not shutdown the database", (Throwable)e);
                        }
                    }
                }
                TuttiPersistenceServiceLocator.shutdownTutti();
            }
        }
    }

    @Override
    public ProgramDataModel loadProgram(String programId, boolean loadFishingOperation) {
        Program program = this.getProgram(programId);
        LinkedHashSet<CruiseDataModel> cruiseModels = new LinkedHashSet<CruiseDataModel>();
        ArrayList<Cruise> cruises = new ArrayList<Cruise>(this.getAllCruise(programId));
        Cruises.sort(cruises);
        for (Cruise cruise : cruises) {
            List<Integer> fishingOperationIds = loadFishingOperation ? this.getAllFishingOperationIds(cruise.getIdAsInt()) : Collections.emptyList();
            CruiseDataModel model = this.loadCruise(cruise, fishingOperationIds);
            cruiseModels.add(model);
        }
        return new ProgramDataModel(program, cruiseModels);
    }

    @Override
    public ProgramDataModel loadCruises(String programId, boolean loadFishingOperation, Integer ... cruiseIds) {
        Program program = this.getProgram(programId);
        LinkedHashSet<CruiseDataModel> cruiseModels = new LinkedHashSet<CruiseDataModel>();
        for (Integer cruiseId : cruiseIds) {
            Cruise cruise = this.getCruise(cruiseId);
            List<Integer> fishingOperationIds = loadFishingOperation ? this.getAllFishingOperationIds(cruise.getIdAsInt()) : Collections.emptyList();
            CruiseDataModel model = this.loadCruise(cruise, fishingOperationIds);
            cruiseModels.add(model);
        }
        return new ProgramDataModel(program, cruiseModels);
    }

    @Override
    public ProgramDataModel loadCruise(String programId, Integer cruiseId, Integer ... fishingOperationIds) {
        Program program = this.getProgram(programId);
        LinkedHashSet<CruiseDataModel> cruiseModels = new LinkedHashSet<CruiseDataModel>();
        Cruise cruise = this.getCruise(cruiseId);
        CruiseDataModel model = this.loadCruise(cruise, Arrays.asList(fishingOperationIds));
        cruiseModels.add(model);
        return new ProgramDataModel(program, cruiseModels);
    }

    protected CruiseDataModel loadCruise(Cruise cruise, List<Integer> fishingOperationIds) {
        LinkedHashSet<OperationDataModel> fishingOperationModels = new LinkedHashSet<OperationDataModel>();
        ArrayList<FishingOperation> fishingOperations = new ArrayList<FishingOperation>(this.getAllFishingOperation(cruise.getIdAsInt()));
        FishingOperations.sort(fishingOperations);
        fishingOperations.stream().filter(fishingOperation -> fishingOperationIds.contains(fishingOperation.getIdAsInt())).forEach(fishingOperation -> {
            OperationDataModel model = new OperationDataModel((FishingOperation)fishingOperation);
            fishingOperationModels.add(model);
        });
        return new CruiseDataModel(cruise, fishingOperationModels);
    }

    @Override
    public List<Caracteristic> getAllCaracteristic() {
        return this.getCaracteristicService().getAllCaracteristic();
    }

    @Override
    public List<Caracteristic> getAllCaracteristicWithProtected() {
        return this.getCaracteristicService().getAllCaracteristicWithProtected();
    }

    @Override
    public List<Caracteristic> getAllCaracteristicForSampleCategory() {
        return this.getCaracteristicService().getAllCaracteristicForSampleCategory();
    }

    @Override
    public List<Caracteristic> getAllNumericCaracteristic() {
        return this.getCaracteristicService().getAllNumericCaracteristic();
    }

    @Override
    public Caracteristic getSizeCategoryCaracteristic() {
        return this.getCaracteristicService().getSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getSexCaracteristic() {
        return this.getCaracteristicService().getSexCaracteristic();
    }

    @Override
    public Caracteristic getSortedUnsortedCaracteristic() {
        return this.getCaracteristicService().getSortedUnsortedCaracteristic();
    }

    @Override
    public Caracteristic getMaturityCaracteristic() {
        return this.getCaracteristicService().getMaturityCaracteristic();
    }

    @Override
    public Caracteristic getAgeCaracteristic() {
        return this.getCaracteristicService().getAgeCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterCategoryCaracteristic() {
        return this.getCaracteristicService().getMarineLitterCategoryCaracteristic();
    }

    @Override
    public Caracteristic getMarineLitterSizeCategoryCaracteristic() {
        return this.getCaracteristicService().getMarineLitterSizeCategoryCaracteristic();
    }

    @Override
    public Caracteristic getVerticalOpeningCaracteristic() {
        return this.getCaracteristicService().getVerticalOpeningCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningWingsCaracteristic() {
        return this.getCaracteristicService().getHorizontalOpeningWingsCaracteristic();
    }

    @Override
    public Caracteristic getHorizontalOpeningDoorCaracteristic() {
        return this.getCaracteristicService().getHorizontalOpeningDoorCaracteristic();
    }

    @Override
    public Caracteristic getDeadOrAliveCaracteristic() {
        return this.getCaracteristicService().getDeadOrAliveCaracteristic();
    }

    @Override
    public Caracteristic getCalcifiedStructureCaracteristic() {
        return this.getCaracteristicService().getCalcifiedStructureCaracteristic();
    }

    @Override
    public Caracteristic getPmfmIdCaracteristic() {
        return this.getCaracteristicService().getPmfmIdCaracteristic();
    }

    @Override
    public Caracteristic getWeightMeasuredCaracteristic() {
        return this.getCaracteristicService().getWeightMeasuredCaracteristic();
    }

    @Override
    public Caracteristic getCopyIndividualObservationModeCaracteristic() {
        return this.getCaracteristicService().getCopyIndividualObservationModeCaracteristic();
    }

    @Override
    public Caracteristic getSampleCodeCaracteristic() {
        return this.getCaracteristicService().getSampleCodeCaracteristic();
    }

    @Override
    public Caracteristic getCaracteristic(Integer pmfmId) {
        return this.getCaracteristicService().getCaracteristic(pmfmId);
    }

    @Override
    public boolean isVracBatch(SpeciesBatch speciesBatch) {
        return this.getCaracteristicService().isVracBatch(speciesBatch);
    }

    @Override
    public Predicate<SpeciesBatch> getVracBatchPredicate() {
        return this.getCaracteristicService().getVracBatchPredicate();
    }

    @Override
    public boolean isHorsVracBatch(SpeciesBatch speciesBatch) {
        return this.getCaracteristicService().isHorsVracBatch(speciesBatch);
    }

    @Override
    public List<TuttiLocation> getAllProgramZone() {
        return this.getLocationService().getAllProgramZone();
    }

    @Override
    public List<TuttiLocation> getAllCountry() {
        return this.getLocationService().getAllCountry();
    }

    @Override
    public List<TuttiLocation> getAllHarbour() {
        return this.getLocationService().getAllHarbour();
    }

    @Override
    public List<TuttiLocation> getAllHarbourWithObsoletes() {
        return this.getLocationService().getAllHarbourWithObsoletes();
    }

    @Override
    public ImmutableSet<Integer> getAllFishingOperationStratasAndSubstratasIdsForProgram(String zoneId) {
        return this.getLocationService().getAllFishingOperationStratasAndSubstratasIdsForProgram(zoneId);
    }

    @Override
    public Multimap<TuttiLocation, TuttiLocation> getAllFishingOperationStratasAndSubstratas(String zoneId) {
        return this.getLocationService().getAllFishingOperationStratasAndSubstratas(zoneId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrata(String zoneId) {
        return this.getLocationService().getAllFishingOperationStrata(zoneId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationStrataWithObsoletes(String zoneId) {
        return this.getLocationService().getAllFishingOperationStrataWithObsoletes(zoneId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrata(String zoneId, String strataId) {
        return this.getLocationService().getAllFishingOperationSubStrata(zoneId, strataId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationSubStrataWithObsoletes(String zoneId, String strataId) {
        return this.getLocationService().getAllFishingOperationSubStrataWithObsoletes(zoneId, strataId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocation(String zoneId, String strataId, String subStrataId) {
        return this.getLocationService().getAllFishingOperationLocation(zoneId, strataId, subStrataId);
    }

    @Override
    public List<TuttiLocation> getAllFishingOperationLocationWithObsoletes(String zoneId, String strataId, String subStrataId) {
        return this.getLocationService().getAllFishingOperationLocationWithObsoletes(zoneId, strataId, subStrataId);
    }

    @Override
    public String getLocationLabelByLatLong(Float latitude, Float longitude) {
        return this.getLocationService().getLocationLabelByLatLong(latitude, longitude);
    }

    @Override
    public Integer getLocationIdByLatLong(Float latitude, Float longitude) {
        return this.getLocationService().getLocationIdByLatLong(latitude, longitude);
    }

    @Override
    public TuttiLocation getLocation(String id) {
        return this.getLocationService().getLocation(id);
    }

    @Override
    public List<ObjectType> getAllObjectType() {
        return this.getObjectTypeService().getAllObjectType();
    }

    @Override
    public ObjectType getObjectType(String objectTypeCode) {
        return this.getObjectTypeService().getObjectType(objectTypeCode);
    }

    @Override
    public List<Gear> getAllScientificGear() {
        return this.getGearService().getAllScientificGear();
    }

    @Override
    public List<Gear> getAllFishingGear() {
        return this.getGearService().getAllFishingGear();
    }

    @Override
    public List<Gear> getAllGearWithObsoletes() {
        return this.getGearService().getAllGearWithObsoletes();
    }

    @Override
    public Gear getGear(Integer gearId) {
        return this.getGearService().getGear(gearId);
    }

    @Override
    public boolean isTemporaryGearUsed(Integer id) {
        return this.getGearService().isTemporaryGearUsed(id);
    }

    @Override
    public List<Gear> addTemporaryGears(List<Gear> gears) {
        return this.getGearService().addTemporaryGears(gears);
    }

    @Override
    public List<Gear> updateTemporaryGears(List<Gear> gears) {
        return this.getGearService().updateTemporaryGears(gears);
    }

    @Override
    public List<Gear> linkTemporaryGears(List<Gear> gears) {
        return this.getGearService().linkTemporaryGears(gears);
    }

    @Override
    public void replaceGear(Gear source, Gear target, boolean delete) {
        this.getGearService().replaceGear(source, target, delete);
    }

    @Override
    public void deleteTemporaryGear(Integer id) {
        this.getGearService().deleteTemporaryGear(id);
    }

    @Override
    public void deleteTemporaryGears(Collection<Integer> id) {
        this.getGearService().deleteTemporaryGears(id);
    }

    @Override
    public List<Species> getAllSpecies() {
        List<Species> result = this.getSpeciesService().getAllSpecies();
        this.setSpeciesSurveyCode(result, this.getProtocol());
        return result;
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        List<Species> result = this.getSpeciesService().getAllReferentSpecies();
        this.setSpeciesSurveyCode(result, this.getProtocol());
        return result;
    }

    @Override
    public List<Species> getAllReferentSpeciesWithObsoletes() {
        List<Species> result = this.getSpeciesService().getAllReferentSpeciesWithObsoletes();
        this.setSpeciesSurveyCode(result, this.getProtocol());
        return result;
    }

    @Override
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        return this.getSpeciesService().getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
    }

    @Override
    public Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId) {
        return this.getSpeciesService().getSpeciesByReferenceTaxonId(referenceTaxonId);
    }

    @Override
    public Map<Integer, Integer> getAllObsoleteReferentTaxons() {
        return this.getSpeciesService().getAllObsoleteReferentTaxons();
    }

    @Override
    public boolean isTemporarySpeciesUsed(Integer referenceTaxonId) {
        SpeciesProtocol speciesProtocol;
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null && (speciesProtocol = TuttiProtocols.getSpeciesOrBenthosProtocol(protocol, referenceTaxonId)) != null) {
            return true;
        }
        return this.getSpeciesService().isTemporarySpeciesUsed(referenceTaxonId);
    }

    @Override
    public List<Species> addTemporarySpecies(List<Species> species) {
        return this.getSpeciesService().addTemporarySpecies(species);
    }

    @Override
    public List<Species> updateTemporarySpecies(List<Species> species) {
        return this.getSpeciesService().updateTemporarySpecies(species);
    }

    @Override
    public List<Species> linkTemporarySpecies(List<Species> species) {
        return this.getSpeciesService().linkTemporarySpecies(species);
    }

    @Override
    public void replaceSpecies(Species source, Species target, boolean delete) {
        this.getSpeciesService().replaceSpecies(source, target, delete);
        if (delete) {
            this.removeSpeciesFromProtocol(Lists.newArrayList((Object[])new Integer[]{source.getReferenceTaxonId()}));
        }
    }

    @Override
    public void deleteTemporarySpecies(Integer referenceTaxonId) {
        this.getSpeciesService().deleteTemporarySpecies(referenceTaxonId);
        this.removeSpeciesFromProtocol(Lists.newArrayList((Object[])new Integer[]{referenceTaxonId}));
    }

    @Override
    public void deleteTemporarySpecies(Collection<Integer> referenceTaxonIds) {
        this.getSpeciesService().deleteTemporarySpecies(referenceTaxonIds);
        this.removeSpeciesFromProtocol(referenceTaxonIds);
    }

    protected void removeSpeciesFromProtocol(Collection<Integer> referenceTaxonIds) {
        TuttiProtocol protocol = this.getProtocol();
        if (protocol != null) {
            boolean wasRemoved = false;
            for (Integer referenceTaxonId : referenceTaxonIds) {
                wasRemoved |= TuttiProtocols.removeSpeciesOrBenthosProtocol(protocol, referenceTaxonId);
            }
            if (wasRemoved) {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Save protocol (some species or benthos were removed from it.)");
                }
                this.saveProtocol(protocol);
            }
        }
    }

    @Override
    public List<Person> getAllPerson() {
        return this.getPersonService().getAllPerson();
    }

    @Override
    public List<Person> getAllPersonWithObsoletes() {
        return this.getPersonService().getAllPersonWithObsoletes();
    }

    @Override
    public Person getPerson(Integer personId) {
        return this.getPersonService().getPerson(personId);
    }

    @Override
    public boolean isTemporaryPersonUsed(Integer id) {
        return this.getPersonService().isTemporaryPersonUsed(id);
    }

    @Override
    public List<Person> addTemporaryPersons(List<Person> persons) {
        return this.getPersonService().addTemporaryPersons(persons);
    }

    @Override
    public List<Person> updateTemporaryPersons(List<Person> persons) {
        return this.getPersonService().updateTemporaryPersons(persons);
    }

    @Override
    public List<Person> linkTemporaryPersons(List<Person> persons) {
        return this.getPersonService().linkTemporaryPersons(persons);
    }

    @Override
    public void replacePerson(Person source, Person target, boolean delete) {
        this.getPersonService().replacePerson(source, target, delete);
    }

    @Override
    public void deleteTemporaryPerson(Integer id) {
        this.getPersonService().deleteTemporaryPerson(id);
    }

    @Override
    public void deleteTemporaryPersons(Collection<Integer> ids) {
        this.getPersonService().deleteTemporaryPersons(ids);
    }

    @Override
    public List<Vessel> getAllScientificVessel() {
        return this.getVesselService().getAllScientificVessel();
    }

    @Override
    public List<Vessel> getAllFishingVessel() {
        return this.getVesselService().getAllFishingVessel();
    }

    @Override
    public List<Vessel> getAllVesselWithObsoletes() {
        return this.getVesselService().getAllVesselWithObsoletes();
    }

    @Override
    public Vessel getVessel(String vesselCode) {
        return this.getVesselService().getVessel(vesselCode);
    }

    @Override
    public boolean isTemporaryVesselUsed(String code) {
        return this.getVesselService().isTemporaryVesselUsed(code);
    }

    @Override
    public List<Vessel> addTemporaryVessels(List<Vessel> vessels) {
        return this.getVesselService().addTemporaryVessels(vessels);
    }

    @Override
    public List<Vessel> updateTemporaryVessels(List<Vessel> vessels) {
        return this.getVesselService().updateTemporaryVessels(vessels);
    }

    @Override
    public List<Vessel> linkTemporaryVessels(List<Vessel> vessels) {
        return this.getVesselService().linkTemporaryVessels(vessels);
    }

    @Override
    public void replaceVessel(Vessel source, Vessel target, boolean delete) {
        this.getVesselService().replaceVessel(source, target, delete);
    }

    @Override
    public void deleteTemporaryVessel(String code) {
        this.getVesselService().deleteTemporaryVessel(code);
    }

    @Override
    public void deleteTemporaryVessels(Collection<String> codes) {
        this.getVesselService().deleteTemporaryVessels(codes);
    }

    @Override
    public List<Attachment> getAllAttachments(ObjectTypeCode objectType, Integer objectId) {
        return this.getAttachmentService().getAllAttachments(objectType, objectId);
    }

    @Override
    public File getAttachmentFile(String attachmentId) {
        return this.getAttachmentService().getAttachmentFile(attachmentId);
    }

    @Override
    public Attachment createAttachment(Attachment attachment, File file) {
        return this.getAttachmentService().createAttachment(attachment, file);
    }

    @Override
    public Attachment saveAttachment(Attachment attachment) {
        return this.getAttachmentService().saveAttachment(attachment);
    }

    @Override
    public void deleteAttachment(String attachmentId) {
        this.getAttachmentService().deleteAttachment(attachmentId);
    }

    @Override
    public void deleteAllAttachment(ObjectTypeCode objectType, Integer objectId) {
        this.getAttachmentService().deleteAllAttachment(objectType, objectId);
    }

    @Override
    public void deleteAllAttachment(ObjectTypeCode objectType, Set<Integer> objectIds) {
        this.getAttachmentService().deleteAllAttachment(objectType, objectIds);
    }

    @Override
    public List<Program> getAllProgram() {
        return this.getProgramService().getAllProgram();
    }

    @Override
    public Program getProgram(String id) {
        return this.getProgramService().getProgram(id);
    }

    @Override
    public Program createProgram(Program bean) {
        return this.getProgramService().createProgram(bean);
    }

    @Override
    public Program saveProgram(Program bean) {
        return this.getProgramService().saveProgram(bean);
    }

    @Override
    public List<Integer> getAllCruiseId(String programId) {
        return this.getCruiseService().getAllCruiseId(programId);
    }

    @Override
    public List<Cruise> getAllCruise(String programId) {
        return this.getCruiseService().getAllCruise(programId);
    }

    @Override
    public Cruise getCruise(Integer id) {
        return this.getCruiseService().getCruise(id);
    }

    @Override
    public Cruise createCruise(Cruise bean) {
        return this.getCruiseService().createCruise(bean);
    }

    @Override
    public Cruise saveCruise(Cruise bean, boolean updateVessel, boolean updateGear) {
        return this.getCruiseService().saveCruise(bean, updateVessel, updateGear);
    }

    @Override
    public void setCruiseReadyToSynch(Integer cruiseId) {
        this.getCruiseService().setCruiseReadyToSynch(cruiseId);
    }

    @Override
    public CaracteristicMap getGearCaracteristics(Integer cruiseId, Integer gearId, short rankOrder) {
        return this.getCruiseService().getGearCaracteristics(cruiseId, gearId, rankOrder);
    }

    @Override
    public boolean isOperationUseGears(Integer cruiseId, Collection<Gear> gears) {
        return this.getCruiseService().isOperationUseGears(cruiseId, gears);
    }

    @Override
    public void saveGearCaracteristics(Gear gear, Cruise cruise) {
        this.getCruiseService().saveGearCaracteristics(gear, cruise);
    }

    @Override
    public TuttiProtocol getProtocol() {
        return this.getProtocolService().getProtocol();
    }

    @Override
    public void setProtocol(TuttiProtocol protocol) {
        this.getProtocolService().setProtocol(protocol);
    }

    @Override
    public boolean isProtocolExist(String id) {
        return this.getProtocolService().isProtocolExist(id);
    }

    @Override
    public String getFirstAvailableName(String protocolName) {
        return this.getProtocolService().getFirstAvailableName(protocolName);
    }

    @Override
    public List<String> getAllProtocolNames() {
        return this.getProtocolService().getAllProtocolNames();
    }

    @Override
    public TuttiProtocol getProtocolByName(String protocolName) {
        return this.getProtocolService().getProtocolByName(protocolName);
    }

    @Override
    public List<TuttiProtocol> getAllProtocol() {
        return this.getProtocolService().getAllProtocol();
    }

    @Override
    public List<TuttiProtocol> getAllProtocol(String programId) {
        return this.getProtocolService().getAllProtocol(programId);
    }

    @Override
    public List<String> getAllProtocolId() {
        return this.getProtocolService().getAllProtocolId();
    }

    @Override
    public TuttiProtocol saveProtocol(TuttiProtocol bean) {
        return this.getProtocolService().saveProtocol(bean);
    }

    @Override
    public void deleteProtocol(String id) {
        this.getProtocolService().deleteProtocol(id);
    }

    @Override
    public TuttiProtocol createProtocol(TuttiProtocol bean) {
        return this.protocolService.createProtocol(bean);
    }

    @Override
    public TuttiProtocol getProtocol(String id) {
        TuttiProtocol protocol = this.getProtocolService().getProtocol(id);
        Map<Integer, Integer> allObsoleteReferentTaxons = this.getAllObsoleteReferentTaxons();
        TuttiProtocols.translateReferenceTaxonIds(protocol, allObsoleteReferentTaxons);
        List<Species> allReferentSpecies = this.getAllReferentSpecies();
        Map<Integer, String> missingSpecies = TuttiProtocols.detectMissingSpecies(protocol, allReferentSpecies);
        TuttiProtocols.removeBadSpecies(protocol, missingSpecies);
        Map<Integer, String> missingBenthos = TuttiProtocols.detectMissingBenthos(protocol, allReferentSpecies);
        TuttiProtocols.removeBadBenthos(protocol, missingBenthos);
        return protocol;
    }

    @Override
    public int getFishingOperationCount(Integer cruiseId) {
        return this.getFishingOperationService().getFishingOperationCount(cruiseId);
    }

    @Override
    public List<Integer> getAllFishingOperationIds(Integer cruiseId) {
        return this.getFishingOperationService().getAllFishingOperationIds(cruiseId);
    }

    @Override
    public List<FishingOperation> getAllFishingOperation(Integer cruiseId) {
        return this.getFishingOperationService().getAllFishingOperation(cruiseId);
    }

    @Override
    public FishingOperation getFishingOperation(Integer id) {
        return this.getFishingOperationService().getFishingOperation(id);
    }

    @Override
    public List<Vessel> getFishingOperationSecondaryVessel(Integer fishingOperationId) {
        return this.getFishingOperationService().getFishingOperationSecondaryVessel(fishingOperationId);
    }

    @Override
    public FishingOperation createFishingOperation(FishingOperation bean) {
        return this.getFishingOperationService().createFishingOperation(bean);
    }

    @Override
    public FishingOperation saveFishingOperation(FishingOperation bean) {
        return this.getFishingOperationService().saveFishingOperation(bean);
    }

    @Override
    public Collection<FishingOperation> saveFishingOperations(Collection<FishingOperation> beans) {
        return this.getFishingOperationService().saveFishingOperations(beans);
    }

    @Override
    public void deleteFishingOperation(Integer id) {
        this.getFishingOperationService().deleteFishingOperation(id);
    }

    @Override
    public boolean isFishingOperationWithCatchBatch(Integer operationId) {
        return this.getCatchBatchService().isFishingOperationWithCatchBatch(operationId);
    }

    @Override
    public CatchBatch getCatchBatchFromFishingOperation(Integer id) throws InvalidBatchModelException {
        return this.getCatchBatchService().getCatchBatchFromFishingOperation(id);
    }

    @Override
    public CatchBatch createCatchBatch(CatchBatch bean) {
        return this.getCatchBatchService().createCatchBatch(bean);
    }

    @Override
    public CatchBatch saveCatchBatch(CatchBatch bean) {
        return this.getCatchBatchService().saveCatchBatch(bean);
    }

    @Override
    public void deleteCatchBatch(Integer fishingOperationId) {
        this.getCatchBatchService().deleteCatchBatch(fishingOperationId);
    }

    @Override
    public void recomputeCatchBatchSampleRatios(Integer fishingOperationId) {
        this.getCatchBatchService().recomputeCatchBatchSampleRatios(fishingOperationId);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootSpeciesBatch(Integer fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.getSpeciesBatchService().getRootSpeciesBatch(fishingOperationId, validateTree);
    }

    @Override
    public Set<Integer> getBatchChildIds(Integer id) {
        return this.getSpeciesBatchService().getBatchChildIds(id);
    }

    @Override
    public SpeciesBatch createSpeciesBatch(SpeciesBatch bean, Integer parentBatchId, boolean computeRankOrder) {
        return this.getSpeciesBatchService().createSpeciesBatch(bean, parentBatchId, computeRankOrder);
    }

    @Override
    public Collection<SpeciesBatch> createSpeciesBatches(Integer fishingOperationId, Collection<SpeciesBatch> beans) {
        return this.getSpeciesBatchService().createSpeciesBatches(fishingOperationId, beans);
    }

    @Override
    public SpeciesBatch saveSpeciesBatch(SpeciesBatch bean) {
        return this.getSpeciesBatchService().saveSpeciesBatch(bean);
    }

    @Override
    public void deleteSpeciesBatch(Integer id) {
        this.getSpeciesBatchService().deleteSpeciesBatch(id);
    }

    @Override
    public void deleteSpeciesSubBatch(Integer id) {
        this.getSpeciesBatchService().deleteSpeciesSubBatch(id);
    }

    @Override
    public void changeSpeciesBatchSpecies(Integer batchId, Species species) {
        this.getSpeciesBatchService().changeSpeciesBatchSpecies(batchId, species);
    }

    @Override
    public List<SpeciesBatch> getAllSpeciesBatchToConfirm(Integer fishingOperationId) throws InvalidBatchModelException {
        return this.getSpeciesBatchService().getAllSpeciesBatchToConfirm(fishingOperationId);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllSpeciesBatchFrequency(Integer speciesBatchId) {
        return this.getSpeciesBatchService().getAllSpeciesBatchFrequency(speciesBatchId);
    }

    @Override
    public Multimap<Species, SpeciesBatchFrequency> getAllSpeciesBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        return this.getSpeciesBatchService().getAllSpeciesBatchFrequencyForBatch(batchContainer);
    }

    @Override
    public List<SpeciesBatchFrequency> saveSpeciesBatchFrequency(Integer speciesBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.getSpeciesBatchService().saveSpeciesBatchFrequency(speciesBatchId, frequencies);
    }

    @Override
    public BatchContainer<SpeciesBatch> getRootBenthosBatch(Integer fishingOperationId, boolean validateTree) throws InvalidBatchModelException {
        return this.getBenthosBatchService().getRootBenthosBatch(fishingOperationId, validateTree);
    }

    @Override
    public SpeciesBatch createBenthosBatch(SpeciesBatch bean, Integer parentBatchId, boolean computeRankOrder) {
        return this.getBenthosBatchService().createBenthosBatch(bean, parentBatchId, computeRankOrder);
    }

    @Override
    public Collection<SpeciesBatch> createBenthosBatches(Integer fishingOperationId, Collection<SpeciesBatch> beans) {
        return this.getBenthosBatchService().createBenthosBatches(fishingOperationId, beans);
    }

    @Override
    public SpeciesBatch saveBenthosBatch(SpeciesBatch bean) {
        return this.getBenthosBatchService().saveBenthosBatch(bean);
    }

    @Override
    public void deleteBenthosBatch(Integer id) {
        this.getBenthosBatchService().deleteBenthosBatch(id);
    }

    @Override
    public void deleteBenthosSubBatch(Integer id) {
        this.getBenthosBatchService().deleteBenthosSubBatch(id);
    }

    @Override
    public void changeBenthosBatchSpecies(Integer batchId, Species species) {
        this.getBenthosBatchService().changeBenthosBatchSpecies(batchId, species);
    }

    @Override
    public List<SpeciesBatch> getAllBenthosBatchToConfirm(Integer fishingOperationId) throws InvalidBatchModelException {
        return this.getBenthosBatchService().getAllBenthosBatchToConfirm(fishingOperationId);
    }

    @Override
    public List<SpeciesBatchFrequency> getAllBenthosBatchFrequency(Integer benthosBatchId) {
        return this.getBenthosBatchService().getAllBenthosBatchFrequency(benthosBatchId);
    }

    @Override
    public Multimap<Species, SpeciesBatchFrequency> getAllBenthosBatchFrequencyForBatch(BatchContainer<SpeciesBatch> batchContainer) {
        return this.getBenthosBatchService().getAllBenthosBatchFrequencyForBatch(batchContainer);
    }

    @Override
    public List<SpeciesBatchFrequency> saveBenthosBatchFrequency(Integer benthosBatchId, List<SpeciesBatchFrequency> frequencies) {
        return this.getBenthosBatchService().saveBenthosBatchFrequency(benthosBatchId, frequencies);
    }

    @Override
    public BatchContainer<MarineLitterBatch> getRootMarineLitterBatch(Integer fishingOperationId) {
        return this.getMarineLitterBatchService().getRootMarineLitterBatch(fishingOperationId);
    }

    @Override
    public MarineLitterBatch createMarineLitterBatch(MarineLitterBatch bean) {
        return this.getMarineLitterBatchService().createMarineLitterBatch(bean);
    }

    @Override
    public Collection<MarineLitterBatch> createMarineLitterBatches(Integer fishingOperationId, Collection<MarineLitterBatch> beans) {
        return this.getMarineLitterBatchService().createMarineLitterBatches(fishingOperationId, beans);
    }

    @Override
    public MarineLitterBatch saveMarineLitterBatch(MarineLitterBatch bean) {
        return this.getMarineLitterBatchService().saveMarineLitterBatch(bean);
    }

    @Override
    public void deleteMarineLitterBatch(Integer id) {
        this.getMarineLitterBatchService().deleteMarineLitterBatch(id);
    }

    @Override
    public List<AccidentalBatch> getAllAccidentalBatch(Integer fishingOperationId) {
        return this.getAccidentalBatchService().getAllAccidentalBatch(fishingOperationId);
    }

    @Override
    public AccidentalBatch createAccidentalBatch(AccidentalBatch bean) {
        return this.getAccidentalBatchService().createAccidentalBatch(bean);
    }

    @Override
    public Collection<AccidentalBatch> createAccidentalBatches(Collection<AccidentalBatch> beans) {
        return this.getAccidentalBatchService().createAccidentalBatches(beans);
    }

    @Override
    public AccidentalBatch saveAccidentalBatch(AccidentalBatch bean) {
        return this.getAccidentalBatchService().saveAccidentalBatch(bean);
    }

    @Override
    public void deleteAccidentalBatch(String id) {
        this.getAccidentalBatchService().deleteAccidentalBatch(id);
    }

    @Override
    public void deleteAccidentalBatchForFishingOperation(Integer fishingOperationId) {
        this.getAccidentalBatchService().deleteAccidentalBatchForFishingOperation(fishingOperationId);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatchsForBatch(Integer batchId) {
        return this.getIndividualObservationBatchService().getAllIndividualObservationBatchsForBatch(batchId);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatchsForFishingOperation(Integer fishingOperationId) {
        return this.getIndividualObservationBatchService().getAllIndividualObservationBatchsForFishingOperation(fishingOperationId);
    }

    @Override
    public List<IndividualObservationBatch> getAllIndividualObservationBatchsForCruise(Integer cruiseId) {
        return this.getIndividualObservationBatchService().getAllIndividualObservationBatchsForCruise(cruiseId);
    }

    @Override
    public boolean isSamplingCodeAvailable(Integer cruiseId, Integer referenceTaxonId, String samplingCodeSuffix) {
        return this.getIndividualObservationBatchService().isSamplingCodeAvailable(cruiseId, referenceTaxonId, samplingCodeSuffix);
    }

    @Override
    public List<IndividualObservationBatch> createIndividualObservationBatches(FishingOperation fishingOperation, Collection<IndividualObservationBatch> individualObservations) {
        return this.getIndividualObservationBatchService().createIndividualObservationBatches(fishingOperation, individualObservations);
    }

    @Override
    public List<IndividualObservationBatch> saveBatchIndividualObservation(Integer batchId, List<IndividualObservationBatch> individualObservation) {
        return this.getIndividualObservationBatchService().saveBatchIndividualObservation(batchId, individualObservation);
    }

    @Override
    public void deleteAllIndividualObservationsForFishingOperation(Integer fishingOperationId) {
        this.getIndividualObservationBatchService().deleteAllIndividualObservationsForFishingOperation(fishingOperationId);
    }

    @Override
    public void deleteAllIndividualObservationsForBatch(Integer speciesBatchId) {
        this.getIndividualObservationBatchService().deleteAllIndividualObservationsForBatch(speciesBatchId);
    }

    protected void setSpeciesSurveyCode(List<Species> speciesList, TuttiProtocol protocol) {
        if (protocol != null && !protocol.isSpeciesEmpty()) {
            Integer taxonId;
            String surveyCode;
            TreeMap surveyCodeByTaxonId = Maps.newTreeMap();
            if (!protocol.isSpeciesEmpty()) {
                for (SpeciesProtocol speciesProtocol : protocol.getSpecies()) {
                    surveyCode = speciesProtocol.getSpeciesSurveyCode();
                    if (!StringUtils.isNotBlank((CharSequence)surveyCode)) continue;
                    taxonId = speciesProtocol.getSpeciesReferenceTaxonId();
                    surveyCodeByTaxonId.put(taxonId, surveyCode);
                }
            }
            if (!protocol.isBenthosEmpty()) {
                for (SpeciesProtocol speciesProtocol : protocol.getBenthos()) {
                    String oldSurveyCode;
                    surveyCode = speciesProtocol.getSpeciesSurveyCode();
                    if (!StringUtils.isNotBlank((CharSequence)surveyCode) || (oldSurveyCode = surveyCodeByTaxonId.put(taxonId = speciesProtocol.getSpeciesReferenceTaxonId(), surveyCode)) == null || !log.isWarnEnabled()) continue;
                    log.warn((Object)String.format("Detect a species in both species and benthos protocol: taxonId=%d, species surveyCode=%s, benthos surveyCode=%s", taxonId, oldSurveyCode, surveyCode));
                }
            }
            for (Species species : speciesList) {
                Integer taxonId2 = species.getReferenceTaxonId();
                String surveyCode2 = (String)surveyCodeByTaxonId.get(taxonId2);
                species.setSurveyCode(surveyCode2);
            }
        }
    }

    public AccidentalBatchPersistenceService getAccidentalBatchService() {
        return this.getServiceInitialized(this.accidentalBatchService);
    }

    public AttachmentPersistenceService getAttachmentService() {
        return this.getServiceInitialized(this.attachmentService);
    }

    public BenthosBatchPersistenceService getBenthosBatchService() {
        return this.getServiceInitialized(this.benthosBatchService);
    }

    public CaracteristicPersistenceService getCaracteristicService() {
        return this.getServiceInitialized(this.caracteristicService);
    }

    public CatchBatchPersistenceService getCatchBatchService() {
        return this.getServiceInitialized(this.catchBatchService);
    }

    public CruisePersistenceService getCruiseService() {
        return this.getServiceInitialized(this.cruiseService);
    }

    public FishingOperationPersistenceService getFishingOperationService() {
        return this.getServiceInitialized(this.fishingOperationService);
    }

    public GearPersistenceService getGearService() {
        return this.getServiceInitialized(this.gearService);
    }

    public IndividualObservationBatchPersistenceService getIndividualObservationBatchService() {
        return this.getServiceInitialized(this.individualObservationBatchService);
    }

    public LocationPersistenceService getLocationService() {
        return this.getServiceInitialized(this.locationService);
    }

    public MarineLitterBatchPersistenceService getMarineLitterBatchService() {
        return this.getServiceInitialized(this.marineLitterBatchService);
    }

    public ObjectTypePersistenceService getObjectTypeService() {
        return this.getServiceInitialized(this.objectTypeService);
    }

    public PersonPersistenceService getPersonService() {
        return this.getServiceInitialized(this.personService);
    }

    public ProtocolPersistenceService getProtocolService() {
        return this.getServiceInitialized(this.protocolService);
    }

    public ProgramPersistenceService getProgramService() {
        return this.getServiceInitialized(this.programService);
    }

    public SpeciesBatchPersistenceService getSpeciesBatchService() {
        return this.getServiceInitialized(this.speciesBatchService);
    }

    public SpeciesPersistenceService getSpeciesService() {
        return this.getServiceInitialized(this.speciesService);
    }

    public TechnicalPersistenceService getTechnicalPersistenceService() {
        return this.getServiceInitialized(this.technicalPersistenceService);
    }

    public VesselPersistenceService getVesselService() {
        return this.getServiceInitialized(this.vesselService);
    }

    protected <S extends TuttiPersistenceServiceImplementor> S getServiceInitialized(S service) {
        service.lazyInit();
        return service;
    }
}

