/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.actions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.calcifiedpiecessampling.CalcifiedPiecesSamplingEditorUI;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddSpeciesAction
extends SimpleActionSupport<CalcifiedPiecesSamplingEditorUI> {
    private static final Log log = LogFactory.getLog(AddSpeciesAction.class);

    public AddSpeciesAction(CalcifiedPiecesSamplingEditorUI ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(CalcifiedPiecesSamplingEditorUI ui) {
        BeanFilterableComboBox<Species> speciesComboBox = ui.getSpeciesComboBox();
        Species species = (Species)speciesComboBox.getSelectedItem();
        ArrayList<CalcifiedPiecesSamplingEditorRowModel> newRows = new ArrayList<CalcifiedPiecesSamplingEditorRowModel>();
        if (ui.getMaturityCheckBox().isSelected()) {
            CalcifiedPiecesSamplingEditorRowModel immatureRow = ui.getHandler().createNewRow(species, false);
            newRows.add(immatureRow);
            CalcifiedPiecesSamplingEditorRowModel matureRow = ui.getHandler().createNewRow(species, true);
            newRows.add(matureRow);
        } else {
            CalcifiedPiecesSamplingEditorRowModel newRow = ui.getHandler().createNewRow(species, null);
            newRows.add(newRow);
        }
        List<CalcifiedPiecesSamplingEditorRowModel> cpsRows = ui.getModel().getCpsRows();
        cpsRows.addAll(newRows);
        cpsRows.sort(CalcifiedPiecesSamplingEditorRowModel.COMPARATOR);
        speciesComboBox.removeItem((Object)species);
        int firstRowIndex = cpsRows.indexOf(newRows.get(0));
        int lastRowIndex = cpsRows.indexOf(newRows.get(newRows.size() - 1));
        CalcifiedPiecesSamplingEditorTableModel tableModel = (CalcifiedPiecesSamplingEditorTableModel)((Object)ui.getCpsTable().getModel());
        if (log.isInfoEnabled()) {
            log.info(cpsRows);
            log.info((Object)tableModel.getRows());
            log.info((Object)("insert in  " + firstRowIndex + " " + lastRowIndex));
        }
        tableModel.fireTableRowsInserted(firstRowIndex, lastRowIndex);
        SwingUtil.setSelectionInterval((JTable)ui.getCpsTable(), (int)firstRowIndex);
    }
}

