/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.datasource.DataSourceUtils;

public class OptionalDatasourceJdbcDaoSupport {
    private final DataSource dataSource;
    private final String databaSourceJdbcUrl;

    public OptionalDatasourceJdbcDaoSupport(DataSource dataSource) {
        this.dataSource = dataSource;
        this.databaSourceJdbcUrl = this.getJdbcUrl(dataSource);
    }

    public OptionalDatasourceJdbcDaoSupport() {
        this.dataSource = null;
        this.databaSourceJdbcUrl = null;
    }

    protected <T> T query(Properties connectionProperties, String sql, Map<String, Object> paramMap, ResultSetExtractor<T> rse) {
        Object object;
        ResultSet rs;
        PreparedStatement statement;
        Connection connection;
        block5: {
            connection = null;
            statement = null;
            rs = null;
            connection = this.createConnection(connectionProperties);
            statement = DaoUtils.bindQuery(connection, sql, paramMap);
            rs = statement.executeQuery();
            if (rs.next()) break block5;
            T t = null;
            DaoUtils.closeSilently(rs);
            DaoUtils.closeSilently(statement);
            this.closeSilently(connection);
            return t;
        }
        try {
            Object target;
            object = target = rse.extractData(rs);
        }
        catch (SQLException e) {
            try {
                throw new DataAccessResourceFailureException(String.format("Error while executing query [%s]: %s", sql, e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DaoUtils.closeSilently(rs);
                DaoUtils.closeSilently(statement);
                this.closeSilently(connection);
                throw throwable;
            }
        }
        DaoUtils.closeSilently(rs);
        DaoUtils.closeSilently(statement);
        this.closeSilently(connection);
        return (T)object;
    }

    protected void query(Properties connectionProperties, String sql, Map<String, Object> paramMap, RowCallbackHandler rch) {
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.createConnection(connectionProperties);
            statement = DaoUtils.bindQuery(connection, sql, paramMap);
            rs = statement.executeQuery();
            while (rs.next()) {
                rch.processRow(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new DataAccessResourceFailureException(String.format("Error while executing query [%s]: %s", sql, e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DaoUtils.closeSilently(rs);
                DaoUtils.closeSilently(statement);
                this.closeSilently(connection);
                throw throwable;
            }
        }
        DaoUtils.closeSilently(rs);
        DaoUtils.closeSilently(statement);
        this.closeSilently(connection);
    }

    protected <T> List<T> query(Properties connectionProperties, String sql, Map<String, Object> paramMap, RowMapper<T> rowMapper) {
        ArrayList arrayList;
        Connection connection = null;
        PreparedStatement statement = null;
        ResultSet rs = null;
        try {
            connection = this.createConnection(connectionProperties);
            statement = DaoUtils.bindQuery(connection, sql, paramMap);
            rs = statement.executeQuery();
            ArrayList result = Lists.newArrayList();
            int rowNumber = 1;
            while (rs.next()) {
                Object row = rowMapper.mapRow(rs, rowNumber++);
                result.add(row);
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new DataAccessResourceFailureException(String.format("Error while executing query [%s]: %s", sql, e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                DaoUtils.closeSilently(rs);
                DaoUtils.closeSilently(statement);
                this.closeSilently(connection);
                throw throwable;
            }
        }
        DaoUtils.closeSilently(rs);
        DaoUtils.closeSilently(statement);
        this.closeSilently(connection);
        return arrayList;
    }

    protected Connection createConnection(Properties connectionProperties) throws SQLException {
        if (connectionProperties == null) {
            Preconditions.checkNotNull((Object)this.dataSource);
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }
        String jdbcUrl = DaoUtils.getUrl(connectionProperties);
        if (this.dataSource != null && Objects.equals(this.databaSourceJdbcUrl, jdbcUrl)) {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }
        return DaoUtils.createConnection(connectionProperties);
    }

    protected void closeSilently(Connection connection) {
        Preconditions.checkNotNull((Object)connection);
        try {
            String jdbcUrl = connection.getMetaData().getURL();
            if (this.dataSource != null && Objects.equals(this.databaSourceJdbcUrl, jdbcUrl)) {
                DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
                return;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        DaoUtils.closeSilently(connection);
    }

    protected String getJdbcUrl(DataSource dataSource) {
        Preconditions.checkNotNull((Object)dataSource);
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            String string = connection.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new AdagioTechnicalException("Could not read the JDBC URL from datasource.", e);
        }
        finally {
            DaoUtils.closeSilently(connection);
        }
    }

    protected Integer safeGetInteger(ResultSet rs, int columnIndex) throws SQLException {
        Object value = rs.getObject(columnIndex);
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }
}

