/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabGrandTotalRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabFooterExecutor
extends BaseCrosstabExecutor {
    private int currentRow;
    private int totalRow;

    public CrosstabFooterExecutor(BaseCrosstabExecutor parent) {
        super(parent);
    }

    public IContent execute() {
        ITableBandContent content = this.context.getReportContent().createTableBandContent();
        content.setBandType(2);
        this.initializeContent(content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentRow = 0;
        int count = this.crosstabItem.getMeasureCount();
        this.totalRow = count > 1 && "vertical".equals(this.crosstabItem.getMeasureDirection()) ? count : 1;
    }

    public IReportItemExecutor getNextChild() {
        return new CrosstabGrandTotalRowExecutor(this, this.currentRow++);
    }

    public boolean hasNextChild() {
        if (this.currentRow < this.totalRow) {
            if (GroupUtil.hasTotalContent(this.crosstabItem, 0, -1, -1, "vertical".equals(this.crosstabItem.getMeasureDirection()) ? this.currentRow : -1)) {
                return true;
            }
            ++this.currentRow;
            return this.hasNextChild();
        }
        return false;
    }
}

