---
-- #%L
-- SIH-Adagio Core for Allegro
-- $Id: db-changelog-3.2.1.01.sql 11991 2014-03-03 09:10:22Z cb0c4f7 $
-- $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.6.3/core-allegro/src/main/resources/fr/ifremer/adagio/core/db/changelog/db-changelog-3.2.1.01.sql $
-- %%
-- Copyright (C) 2012 - 2013 Ifremer
-- %%
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU Affero General Public License as published by
-- the Free Software Foundation, either version 3 of the License, or
-- (at your option) any later version.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU Affero General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.
-- #L%
---


--
-- Upgrade a database Allegro, with changes need for Allegro-Campagne (tutti)
--
--  project : ${pom.name}
--  version : ${pom.version} for ${pom.env}
--      env : ${pom.env} - ${pom.profil}
--     date : ${pom.date.fr}
--
--  Copyright Ifremer 2013
-- 
-- 26/03/2013 BL Creation
-- 27/03/2013 BL Changes need for Allegro-Campagne (tutti) :  
--               - Change MEASUREMENT_FILE.PMFM_FK as NULLABLE  
--               - Add VESSEL_PERSON_xxx tables
-- 08/04/2013 BL Add insertion need on VESSEL_ROLE for Allegro-Campagne (tutti)
-- 09/04/2013 BL New table SYSTEM_VERSION, to store database schema version, after upgrade
-- 16/04/2013 TC Add LABEL column in table VESSEL_PERSON_ROLE
-- 16/04/2013 BL Add TRANSCRIBING_SIDE.DESCRIPTION, VESSEL_PERSON_ROLE.LABEL
--               change sequence use for SYSTEM_VERSION
-- 24/04/2013 BL Add index on TRANSCRIBING_ITEM
-- --------------------------------------------------------------------------

-- -----------------------------------------------------------------------------
-- 26/03/2013 BL Change MEASUREMENT_FILE.PMFM_FK as NULLABLE :  
-- -----------------------------------------------------------------------------
alter table MEASUREMENT_FILE drop constraint MEASUREMENT_FILE_PMFM_FKC;
alter table MEASUREMENT_FILE alter column PMFM_FK integer;
alter table MEASUREMENT_FILE add constraint MEASUREMENT_FILE_PMFM_FKC foreign key (PMFM_FK) references PMFM;

-- -----------------------------------------------------------------------------
-- 26/03/2013 BL Add VESSEL_PERSON_xxx tables
-- -----------------------------------------------------------------------------
create table VESSEL_PERSON (ID integer not null, REGISTRATION_CODE VARCHAR(40), LASTNAME VARCHAR(100), FIRSTNAME VARCHAR(100), STREET VARCHAR(256), ZIP_CODE VARCHAR(256), CITY VARCHAR(256), DATE_OF_BIRTH DATETIME, RETIREMENT_DATE DATETIME, PHONE_NUMBER VARCHAR(50), MOBILE_NUMBER VARCHAR(50), FAX_NUMBER VARCHAR(50), EMAIL VARCHAR(255), UPDATE_DATE TIMESTAMP, EDUCATION_GRADE_FK integer, PROGRAM_FK VARCHAR(40) not null, COUNTRY_LOCATION_FK integer, primary key (ID));
create table VESSEL_PERSON_FEATURES (ID integer not null, START_DATE DATETIME not null, END_DATE DATETIME, RANK_ORDER SMALLINT, CREATION_DATE DATETIME, CONTROL_DATE DATETIME, VALIDATION_DATE DATETIME, QUALIFICATION_DATE DATETIME, QUALIFICATION_COMMENTS VARCHAR(2000), UPDATE_DATE TIMESTAMP, OPERATION_FK integer, VESSEL_FK VARCHAR(12) not null, PERSON_FK integer, PROGRAM_FK VARCHAR(40) not null, QUALITY_FLAG_FK VARCHAR(40) not null, VESSEL_PERSON_FK integer, FISHING_TRIP_FK integer, primary key (ID));
create table VESSEL_PERSON_FEATURES2ROLE (VESSEL_PERSON_FEATURES_FK integer not null, VESSEL_PERSON_ROLES_FK integer not null, primary key (VESSEL_PERSON_FEATURES_FK, VESSEL_PERSON_ROLES_FK));
create table VESSEL_PERSON_MEASUREMENT (ID integer not null, NUMERICAL_VALUE REAL, ALPHANUMERICAL_VALUE VARCHAR(40), DIGIT_COUNT integer, PRECISION_VALUE REAL, CONTROL_DATE DATETIME, VALIDATION_DATE DATETIME, QUALIFICATION_DATE DATETIME, QUALIFICATION_COMMENTS VARCHAR(2000), PMFM_FK integer not null, NUMERICAL_PRECISION_FK integer, QUALITATIVE_VALUE_FK integer, ANALYSIS_INSTRUMENT_FK integer, QUALITY_FLAG_FK VARCHAR(40) not null, AGGREGATION_LEVEL_FK integer, PRECISION_TYPE_FK integer, DEPARTMENT_FK integer, VESSEL_PERSON_FEATURES_FK integer not null, primary key (ID));
create table VESSEL_PERSON_ROLE (ID integer not null, LABEL VARCHAR(40) not null, NAME VARCHAR(100) not null, DESCRIPTION VARCHAR(255), UPDATE_DATE TIMESTAMP, primary key (ID));
alter table VESSEL_PERSON add constraint VESSEL_PERSON_EDUCATION_GRADEC foreign key (EDUCATION_GRADE_FK) references EDUCATION_GRADE;
alter table VESSEL_PERSON add constraint VESSEL_PERSON_COUNTRY_LOCATIOC foreign key (COUNTRY_LOCATION_FK) references LOCATION;
alter table VESSEL_PERSON add constraint VESSEL_PERSON_PROGRAM_FKC foreign key (PROGRAM_FK) references PROGRAM;
alter table VESSEL_PERSON_FEATURES add constraint VESSEL_PERSON_FEATURES_VESSELE foreign key (VESSEL_PERSON_FK) references VESSEL_PERSON;
alter table VESSEL_PERSON_FEATURES add constraint VESSEL_PERSON_FEATURES_QUALITC foreign key (QUALITY_FLAG_FK) references QUALITY_FLAG;
alter table VESSEL_PERSON_FEATURES add constraint VESSEL_PERSON_FEATURES_PROGRAC foreign key (PROGRAM_FK) references PROGRAM;
alter table VESSEL_PERSON_FEATURES add constraint VESSEL_PERSON_FEATURES_PERSONC foreign key (PERSON_FK) references PERSON;
alter table VESSEL_PERSON_FEATURES add constraint VESSEL_PERSON_FEATURES_OPERATC foreign key (OPERATION_FK) references OPERATION on delete cascade;
alter table VESSEL_PERSON_FEATURES add constraint VESSEL_PERSON_FEATURES_FISHINC foreign key (FISHING_TRIP_FK) references FISHING_TRIP on delete cascade;
alter table VESSEL_PERSON_FEATURES add constraint VESSEL_PERSON_FEATURES_VESSELC foreign key (VESSEL_FK) references VESSEL;
alter table VESSEL_PERSON_FEATURES2ROLE add constraint VESSEL_PERSON_ROLE_VESSEL_PERC foreign key (VESSEL_PERSON_FEATURES_FK) references VESSEL_PERSON_FEATURES;
alter table VESSEL_PERSON_FEATURES2ROLE add constraint VESSEL_PERSON_FEATURES_VESSELS foreign key (VESSEL_PERSON_ROLES_FK) references VESSEL_PERSON_ROLE;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERSON_MEASUREMENT_VESC foreign key (VESSEL_PERSON_FEATURES_FK) references VESSEL_PERSON_FEATURES on delete cascade;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERSON_QUALITY_FLAG_FKC foreign key (QUALITY_FLAG_FK) references QUALITY_FLAG;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERS_NUMERICAL_PRECISIC foreign key (NUMERICAL_PRECISION_FK) references NUMERICAL_PRECISION;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERSON_M_DEPARTMENT_FKC foreign key (DEPARTMENT_FK) references DEPARTMENT;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERS_ANALYSIS_INSTRUMEC foreign key (ANALYSIS_INSTRUMENT_FK) references ANALYSIS_INSTRUMENT;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERS_AGGREGATION_LEVELC foreign key (AGGREGATION_LEVEL_FK) references AGGREGATION_LEVEL;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERS_QUALITATIVE_VALUEC foreign key (QUALITATIVE_VALUE_FK) references QUALITATIVE_VALUE;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERSON_MEASURE_PMFM_FKC foreign key (PMFM_FK) references PMFM;
alter table VESSEL_PERSON_MEASUREMENT add constraint VESSEL_PERS_PRECISION_TYPE_FKC foreign key (PRECISION_TYPE_FK) references PRECISION_TYPE;
create index IX_VESSEL_PERSON_UD on VESSEL_PERSON (UPDATE_DATE);
create index IX_VESSEL_PERSON_FEATURES_UD on VESSEL_PERSON (UPDATE_DATE);
create sequence VESSEL_PERSON_FEATURES_SEQ;
create sequence VESSEL_PERSON_MEASUREMENT_SEQ;
create sequence VESSEL_PERSON_SEQ;

-- -----------------------------------------------------------------------------
-- 03/04/2013 BL Remove old TRANSCRIBING_xxx tables
-- -----------------------------------------------------------------------------
drop table TRANSCRIBING_GEAR;
drop table TRANSCRIBING_LOCATION;
drop table TRANSCRIBING_LOCATION_LEVEL;
drop table TRANSCRIBING_METIER;
drop table TRANSCRIBING_PMFM;
drop table TRANSCRIBING_PROGRAM;
drop table TRANSCRIBING_QUALITATIVE_VALUE;
drop table TRANSCRIBING_TAXON_GROUP;
drop table TRANSCRIBING_ITEM;
-- drop table TRANSCRIBING_ITEM_TYPE;
drop table TRANSCRIBING_SYSTEM;
drop table TRANSCRIBING_SIDE;
create table TRANSCRIBING_ITEM (ID integer not null, OBJECT_ID integer, EXTERNAL_CODE VARCHAR(100) not null, OBJECT_CODE VARCHAR(40), UPDATE_DATE TIMESTAMP, TRANSCRIBING_ITEM_TYPE_FK integer not null, primary key (ID));
create table TRANSCRIBING_ITEM_TYPE (ID integer not null, LABEL VARCHAR(40) not null, NAME VARCHAR(100) not null, DESCRIPTION VARCHAR(255), UPDATE_DATE TIMESTAMP, TRANSCRIBING_SYSTEM_FK integer, STATUS_FK VARCHAR(1) not null, TRANSCRIBING_SIDE_FK integer not null, OBJECT_TYPE_FK VARCHAR(40) not null, primary key (ID), unique (LABEL));
create table TRANSCRIBING_SIDE (ID integer not null, NAME VARCHAR(100) not null, DESCRIPTION VARCHAR(255), UPDATE_DATE TIMESTAMP, primary key (ID));
create table TRANSCRIBING_SYSTEM (ID integer not null, LABEL VARCHAR(40) not null, NAME VARCHAR(100) not null, DESCRIPTION VARCHAR(255), UPDATE_DATE TIMESTAMP, STATUS_FK VARCHAR(1) not null, primary key (ID));
alter table TRANSCRIBING_ITEM add constraint TRANSCRIBING_ITEM_TRANSCRIBINC foreign key (TRANSCRIBING_ITEM_TYPE_FK) references TRANSCRIBING_ITEM_TYPE;
alter table TRANSCRIBING_ITEM_TYPE add constraint TRANSCRIBING_ITEM_TYPE_TRANSCC foreign key (TRANSCRIBING_SYSTEM_FK) references TRANSCRIBING_SYSTEM;
alter table TRANSCRIBING_ITEM_TYPE add constraint TRANSCRIBING_ITEM_TYPE_TRANSCT foreign key (TRANSCRIBING_SIDE_FK) references TRANSCRIBING_SIDE;
alter table TRANSCRIBING_ITEM_TYPE add constraint TRANSCRIBING_ITEM_TYPE_OBJECTC foreign key (OBJECT_TYPE_FK) references OBJECT_TYPE;
alter table TRANSCRIBING_ITEM_TYPE add constraint TRANSCRIBING_ITEM_TYPE_STATUSC foreign key (STATUS_FK) references STATUS;
alter table TRANSCRIBING_SYSTEM add constraint TRANSCRIBING_SYSTEM_STATUS_FKC foreign key (STATUS_FK) references STATUS;
create index IX_TRANSCRIBING_ITEM_OBJECT_ID on TRANSCRIBING_ITEM (OBJECT_ID);
create index IX_TRANSCRIBING_ITEM_OBJECT_CODE on TRANSCRIBING_ITEM (OBJECT_CODE);
create index IX_TRANSCRIBING_ITEM_EXTERNAL_CODE on TRANSCRIBING_ITEM (EXTERNAL_CODE);

-- -----------------------------------------------------------------------------
-- 03/04/2013 BL Add missing tables (was already missing before UML model updates)
-- -----------------------------------------------------------------------------
-- some missing indexes, or bad name
create index IX_FK_BATCH_ROOT on BATCH (ROOT_BATCH_FK);
create index IX_SALE_SALE_START_DATE on SALE (SALE_START_DATE);
alter index IDX_ORDER_ITEM_OBJID rename to IX_ORDER_ITEM_OBJID;
alter index ID_SPATIAL_ITEM_OBJID rename to IX_SPATIAL_ITEM_OBJID;

-- missing constraint
alter table DENORMALIZED_BATCH add constraint DENORMALIZED_BATCH_QUALITY_FLC foreign key (QUALITY_FLAG_FK) references QUALITY_FLAG;

-- new column FISHING_TRIP_ORIGIN.ORIGIN_FISHING_TRIP_FK 
alter table FISHING_TRIP_ORIGIN add column ORIGIN_FISHING_TRIP_FK integer;
alter table FISHING_TRIP_ORIGIN add constraint FISHING_TRIP_ORIGIN_ORIGIN_FIC foreign key (ORIGIN_FISHING_TRIP_FK) references FISHING_TRIP;

-- new column DELETED_ITEM_HISTORY.OBJECT_CODE
alter table DELETED_ITEM_HISTORY add column OBJECT_CODE VARCHAR(40);

-- new table INSERTED_ITEM_HISTORY
create table INSERTED_ITEM_HISTORY (ID BIGINT not null, OBJECT_ID integer not null, UPDATE_DATE TIMESTAMP, PROCESSING_HISTORY_FK integer, OBJECT_TYPE_FK VARCHAR(40) not null, primary key (ID));
alter table INSERTED_ITEM_HISTORY add constraint INSERTED_ITEM_HISTORY_PROCESSC foreign key (PROCESSING_HISTORY_FK) references PROCESSING_HISTORY on delete cascade;
alter table INSERTED_ITEM_HISTORY add constraint INSERTED_ITEM_HISTORY_OBJECT_C foreign key (OBJECT_TYPE_FK) references OBJECT_TYPE;
create sequence INSERTED_ITEM_HISTORY_SEQ;

-- new table UPDATED_ITEM_HISTORY
create table UPDATED_ITEM_HISTORY (ID integer not null, OBJECT_ID integer not null, IS_POST_VALIDATION BIT not null, COMMENTS VARCHAR(2000) not null, NUMERICAL_VALUE REAL, PREVIOUS_COMMENTS VARCHAR(2000), UPDATE_DATE TIMESTAMP, PROCESSING_HISTORY_FK integer, RECORDER_DEPARTMENT_FK integer not null, QUALITATIVE_VALUE_FK integer, GEAR_FK integer, TAXON_GROUP_FK integer, RECORDER_PERSON_FK integer, OBJECT_TYPE_FK VARCHAR(40) not null, METIER_FK integer, QUALITY_FLAG_FK VARCHAR(40), PMFM_FK integer, REFERENCE_TAXON_FK integer, primary key (ID));
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_QUALITY_C foreign key (QUALITY_FLAG_FK) references QUALITY_FLAG;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_GEAR_FKC foreign key (GEAR_FK) references GEAR;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_REFERENCC foreign key (REFERENCE_TAXON_FK) references REFERENCE_TAXON;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_RECORDERC foreign key (RECORDER_DEPARTMENT_FK) references DEPARTMENT;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_QUALITATC foreign key (QUALITATIVE_VALUE_FK) references QUALITATIVE_VALUE;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_RECORDER_ foreign key (RECORDER_PERSON_FK) references PERSON;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_PROCESSIC foreign key (PROCESSING_HISTORY_FK) references PROCESSING_HISTORY on delete cascade;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_PMFM_FKC foreign key (PMFM_FK) references PMFM;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_OBJECT_TC foreign key (OBJECT_TYPE_FK) references OBJECT_TYPE;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_TAXON_GRC foreign key (TAXON_GROUP_FK) references TAXON_GROUP;
alter table UPDATED_ITEM_HISTORY add constraint UPDATED_ITEM_HISTORY_METIER_FC foreign key (METIER_FK) references METIER;
create sequence UPDATED_ITEM_HISTORY_SEQ;

 
-- final commit
commit;

