/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential.csv;

import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiCsvUtil;
import fr.ifremer.tutti.service.referential.csv.GearRow;
import fr.ifremer.tutti.service.referential.csv.TemporaryReferentialEntityIdParser;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueFormatter;
import org.nuiton.csv.ValueParser;
import org.nuiton.i18n.I18n;

public class GearModel
extends AbstractTuttiImportExportModel<GearRow> {
    public static GearModel forExport(char separator) {
        GearModel exportModel = new GearModel(separator);
        exportModel.forExport();
        return exportModel;
    }

    public static GearModel forImport(char separator) {
        GearModel importModel = new GearModel(separator);
        importModel.forImport();
        return importModel;
    }

    public GearRow newEmptyInstance() {
        return new GearRow();
    }

    protected GearModel(char separator) {
        super(separator);
    }

    protected void forImport() {
        this.newMandatoryColumn("id", new TemporaryReferentialEntityIdParser(I18n.t((String)"tutti.service.referential.import.gear.error.idNotNegative", (Object[])new Object[0])){

            @Override
            protected boolean isTemporaryId(String parse) {
                int id = Integer.parseInt(parse);
                return Gears.isTemporaryId((Integer)id);
            }
        });
        this.newMandatoryColumn("name");
        this.newMandatoryColumn("label");
        this.newMandatoryColumn("scientificGear", (ValueParser)Common.PRIMITIVE_BOOLEAN);
        this.newMandatoryColumn("toDelete", (ValueParser)TuttiCsvUtil.BOOLEAN);
    }

    protected void forExport() {
        this.newColumnForExport("id");
        this.newColumnForExport("name");
        this.newColumnForExport("label");
        this.newColumnForExport("scientificGear", (ValueFormatter)Common.PRIMITIVE_BOOLEAN);
        this.newColumnForExport("toDelete");
    }
}

