/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.referential;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.Gears;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.DecoratorService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.referential.ReferentialImportRequest;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.consumer.CsvConsumerForTemporaryGear;
import fr.ifremer.tutti.service.referential.csv.GearRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryGear;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.ImportRow;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ReferentialTemporaryGearService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReferentialTemporaryGearService.class);
    protected PersistenceService persistenceService;
    protected DecoratorService decoratorService;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.persistenceService = this.getService(PersistenceService.class);
        this.decoratorService = this.getService(DecoratorService.class);
    }

    public ReferentialImportRequest<Gear, Integer> createReferentialImportRequest() {
        ArrayList allGears = Lists.newArrayList(this.persistenceService.getAllGear());
        ReferentialImportRequest<Gear, Integer> requestResult = new ReferentialImportRequest<Gear, Integer>(allGears, TuttiEntities.newIdAstIntFunction(), Gears.GET_NAME);
        return requestResult;
    }

    public ReferentialImportResult<Gear> importTemporaryGear(File file) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import gears from file: " + file));
        }
        ReferentialImportRequest<Gear, Integer> requestResult = this.createReferentialImportRequest();
        try (CsvConsumerForTemporaryGear consumer = new CsvConsumerForTemporaryGear(file.toPath(), this.getCsvSeparator(), true);){
            for (ImportRow bean : consumer) {
                consumer.checkRow(bean, this.persistenceService, this.decoratorService, requestResult);
            }
        }
        catch (IOException e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.import.gears.error", (Object[])new Object[]{file}), (Throwable)e);
        }
        ReferentialImportResult<Gear> result = this.executeImportRequest(requestResult);
        return result;
    }

    public ReferentialImportResult<Gear> executeImportRequest(ReferentialImportRequest<Gear, Integer> requestResult) {
        ReferentialImportResult<Gear> result = new ReferentialImportResult<Gear>();
        if (requestResult.withEntitiesToDelete()) {
            List<Integer> idsToDelete = requestResult.getIdsToDelete();
            this.persistenceService.deleteTemporaryGears(idsToDelete);
            result.setNbRefDeleted(idsToDelete.size());
        }
        if (requestResult.withEntitiesToAdd()) {
            List<Gear> entitiesToAdd = requestResult.getEntitiesToAdd();
            List<Gear> entitiesAdded = this.persistenceService.addTemporaryGears(entitiesToAdd);
            result.addAllRefsAdded(entitiesAdded);
        }
        if (requestResult.withEntitiesToUpdate()) {
            List<Gear> entitiesToUpdate = requestResult.getEntitiesToUpdate();
            List<Gear> entitiesUpdated = this.persistenceService.updateTemporaryGears(entitiesToUpdate);
            result.addAllRefsUpdated(entitiesUpdated);
        }
        if (requestResult.withEntitiesToLink()) {
            List<Gear> entitiesToLink = requestResult.getEntitiesToLink();
            List<Gear> entitiesLinked = this.persistenceService.linkTemporaryGears(entitiesToLink);
            result.addAllRefsLinked(entitiesLinked);
        }
        return result;
    }

    public void exportExistingTemporaryGear(File file) throws IOException {
        List<Gear> toExport = this.getTemporaryGears();
        this.exportTemporaryGear(file, toExport);
    }

    public List<Gear> getTemporaryGears() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Getting all gears from database");
        }
        ArrayList targetList = Lists.newArrayList(this.persistenceService.getAllGear());
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + targetList.size() + " gears"));
        }
        List<Gear> toExport = this.persistenceService.retainTemporaryGearList(targetList);
        if (log.isInfoEnabled()) {
            log.info((Object)("Got " + toExport.size() + " temporary gears"));
        }
        return toExport;
    }

    public void exportTemporaryGearExample(File file) throws IOException {
        ArrayList toExport = Lists.newArrayList();
        Gear g = Gears.newGear();
        g.setName("Gear fishing name 1");
        g.setLabel("Gear fishing label 1");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear fishing name 2");
        g.setLabel("Gear fishing label 2");
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 3");
        g.setLabel("Gear scientific label 3");
        g.setScientificGear(true);
        toExport.add(g);
        g = Gears.newGear();
        g.setName("Gear scientific name 4");
        g.setLabel("Gear scientific label 4");
        g.setScientificGear(true);
        toExport.add(g);
        this.exportTemporaryGear(file, toExport);
    }

    public void exportTemporaryGear(File file, List<Gear> toExport) throws IOException {
        try (CsvProducerForTemporaryGear producerForTemporarySpecies = new CsvProducerForTemporaryGear(file.toPath(), this.getCsvSeparator());){
            List<GearRow> dataToExport = producerForTemporarySpecies.getDataToExport(toExport);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.referential.export.gear.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    protected char getCsvSeparator() {
        return ';';
    }
}

