// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.survey.sale;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.SaleMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.declaration.DeclaredDocumentReference;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.takeOver.TakeOver;
import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.SaleType;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.samplingScheme.denormalized.DenormalizedSamplingStrata;
import fr.ifremer.adagio.core.dao.referential.seller.Seller;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

/**
 * Vente observée, par exemple, observation en criée.
 * Dans ce cas, des observateurs peuvent etre liée à la vente.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class ObservedSale
    extends SaleImpl
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = 1023256555823964145L;

    // Generate 0 attributes
    // Generate 2 associations
    private Collection<Person> observerPersons = new HashSet<Person>();

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @return this.observerPersons Collection<Person>
     */
    public Collection<Person> getObserverPersons()
    {
        return this.observerPersons;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param observerPersonsIn Collection<Person>
     */
    public void setObserverPersons(Collection<Person> observerPersonsIn)
    {
        this.observerPersons = observerPersonsIn;
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToAdd Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean addObserverPersons(Person elementToAdd)
    {
        return this.observerPersons.add(elementToAdd);
    }

    /**
     * Personne du référentiel (utilisateur ou non du système).
     * Nombre de lignes : 100
     * @param elementToRemove Person
     * @return <tt>true</tt> if this collection changed as a result of the
     *         call
     */
    public boolean removeObserverPersons(Person elementToRemove)
    {
        return this.observerPersons.remove(elementToRemove);
    }

    private DenormalizedSamplingStrata samplingStrata;

    /**
     * Référence au plan d'échantillonnage
     * @return this.samplingStrata DenormalizedSamplingStrata
     */
    public DenormalizedSamplingStrata getSamplingStrata()
    {
        return this.samplingStrata;
    }

    /**
     * Référence au plan d'échantillonnage
     * @param samplingStrataIn DenormalizedSamplingStrata
     */
    public void setSamplingStrata(DenormalizedSamplingStrata samplingStrataIn)
    {
        this.samplingStrata = samplingStrataIn;
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>SaleImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.survey.sale.Sale#equals(Object)
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * but since it extends the <code>SaleImpl</code> class
     * it will simply delegate the call up there.
     *
     * @see fr.ifremer.adagio.core.dao.data.survey.sale.Sale#hashCode()
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link ObservedSale}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link ObservedSale}.
         * @return new ObservedSaleImpl()
         */
        public static ObservedSale newInstance()
        {
            return new ObservedSaleImpl();
        }

        /**
         * Constructs a new instance of {@link ObservedSale}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param synchronizationStatus String
         * @param creationDate Date
         * @param recorderDepartment Department
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @return newInstance
         */
        public static ObservedSale newInstance(String synchronizationStatus, Date creationDate, Department recorderDepartment, Program program, Vessel vessel, QualityFlag qualityFlag)
        {
            final ObservedSale entity = new ObservedSaleImpl();
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setCreationDate(creationDate);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            return entity;
        }

        /**
         * Constructs a new instance of {@link ObservedSale}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param saleStartDate Date
         * @param saleEndDate Date
         * @param synchronizationStatus String
         * @param comments String
         * @param creationDate Date
         * @param controlDate Date
         * @param validationDate Date
         * @param qualificationDate Date
         * @param qualificationComments String
         * @param updateDate Timestamp
         * @param remoteId Integer
         * @param saleLocation Location
         * @param saleType SaleType
         * @param recorderDepartment Department
         * @param recorderPerson Person
         * @param catchBatch CatchBatch
         * @param fishingTrip FishingTrip
         * @param saleOrigins Collection<SaleOrigin>
         * @param program Program
         * @param vessel Vessel
         * @param qualityFlag QualityFlag
         * @param seller Seller
         * @param declaredDocumentReference DeclaredDocumentReference
         * @param landing Landing
         * @param takeOver TakeOver
         * @param produces Collection<Produce>
         * @param fishingAreas Collection<FishingArea>
         * @param surveyMeasurements Collection<SurveyMeasurement>
         * @param saleMeasurements Collection<SaleMeasurement>
         * @param observerPersons Collection<Person>
         * @param samplingStrata DenormalizedSamplingStrata
         * @return newInstance ObservedSale
         */
        public static ObservedSale newInstance(Date saleStartDate, Date saleEndDate, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Integer remoteId, Location saleLocation, SaleType saleType, Department recorderDepartment, Person recorderPerson, CatchBatch catchBatch, FishingTrip fishingTrip, Collection<SaleOrigin> saleOrigins, Program program, Vessel vessel, QualityFlag qualityFlag, Seller seller, DeclaredDocumentReference declaredDocumentReference, Landing landing, TakeOver takeOver, Collection<Produce> produces, Collection<FishingArea> fishingAreas, Collection<SurveyMeasurement> surveyMeasurements, Collection<SaleMeasurement> saleMeasurements, Collection<Person> observerPersons, DenormalizedSamplingStrata samplingStrata)
        {
            final ObservedSale entity = new ObservedSaleImpl();
            entity.setSaleStartDate(saleStartDate);
            entity.setSaleEndDate(saleEndDate);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setRemoteId(remoteId);
            entity.setSaleLocation(saleLocation);
            entity.setSaleType(saleType);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setRecorderPerson(recorderPerson);
            entity.setCatchBatch(catchBatch);
            entity.setFishingTrip(fishingTrip);
            entity.setSaleOrigins(saleOrigins);
            entity.setProgram(program);
            entity.setVessel(vessel);
            entity.setQualityFlag(qualityFlag);
            entity.setSeller(seller);
            entity.setDeclaredDocumentReference(declaredDocumentReference);
            entity.setLanding(landing);
            entity.setTakeOver(takeOver);
            entity.setProduces(produces);
            entity.setFishingAreas(fishingAreas);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setSaleMeasurements(saleMeasurements);
            entity.setObserverPersons(observerPersons);
            entity.setSamplingStrata(samplingStrata);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(ObservedSale o)
    {
        int cmp = 0;
        if (this.getId() != null)
        {
            cmp = this.getId().compareTo(o.getId());
        }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// ObservedSale.java merge-point
}