/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odi;

import java.util.Comparator;
import java.util.List;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.odi.FilterUtil;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public interface IQuery {
    public void setOrdering(List var1) throws DataException;

    public void setGrouping(List var1) throws DataException;

    public void setMaxRows(int var1);

    public void setRowFetchLimit(int var1);

    public void addOnFetchEvent(IResultObjectEvent var1);

    public void setExprProcessor(IExpressionProcessor var1);

    public void setDistinctValueFlag(boolean var1);

    public void close();

    public IBaseQueryDefinition getQueryDefinition();

    public void setQueryDefinition(IBaseQueryDefinition var1);

    public static class GroupSpec {
        private String keyColumn;
        private int keyIndex;
        private String name;
        private int sortDirection = 0;
        private int interval = 0;
        private boolean isComplexExpression = false;
        private double intervalRange = 0.0;
        private Object intervalStart;
        private int dataType;
        private List filters;
        private List sorts;

        public GroupSpec(String groupKeyColumn) {
            this.keyIndex = -1;
            this.keyColumn = groupKeyColumn;
        }

        public GroupSpec(int groupKeyIndex, String groupKeyColumn) {
            this.keyIndex = groupKeyIndex;
            this.keyColumn = groupKeyColumn;
        }

        public int getKeyIndex() {
            return this.keyIndex;
        }

        public String getKeyColumn() {
            return this.keyColumn;
        }

        public void setName(String groupName) {
            this.name = groupName;
        }

        public String getName() {
            return this.name;
        }

        public void setDataType(int type) {
            this.dataType = type;
        }

        public int getDataType() {
            return this.dataType;
        }

        public void setSortDirection(int groupSortDirection) {
            this.sortDirection = groupSortDirection;
        }

        public int getSortDirection() {
            return this.sortDirection;
        }

        public void setInterval(int groupInterval) {
            this.interval = groupInterval;
        }

        public int getInterval() {
            return this.interval;
        }

        public void setIntervalRange(double groupIntervalRange) {
            this.intervalRange = groupIntervalRange;
        }

        public double getIntervalRange() {
            return this.intervalRange;
        }

        public Object getIntervalStart() {
            return this.intervalStart;
        }

        public void setIntervalStart(Object intervalStart) {
            this.intervalStart = intervalStart;
        }

        public void setIsComplexExpression(boolean isComplexExpr) {
            this.isComplexExpression = isComplexExpr;
        }

        public boolean isCompleteExpression() {
            return this.isComplexExpression;
        }

        public void setSorts(List sorts) {
            if (sorts != null) {
                this.sorts = sorts;
            }
        }

        public List getSorts() {
            return this.sorts;
        }

        public void setFilters(List filters) {
            if (filters != null) {
                this.filters = FilterUtil.sortFilters(filters);
            }
        }

        public List getFilters() {
            return this.filters;
        }
    }

    public static class SortSpec {
        private int index = -1;
        private String field;
        private boolean ascendingOrder;
        private Comparator comparator;

        public SortSpec(int index, String field, boolean ascendingOrder, Comparator comparator) {
            this.index = index;
            this.field = field;
            this.ascendingOrder = ascendingOrder;
            this.comparator = comparator;
        }

        public int getIndex() {
            return this.index;
        }

        public String getField() {
            return this.field;
        }

        public boolean isAscendingOrder() {
            return this.ascendingOrder;
        }

        public Comparator getComparator() {
            return this.comparator;
        }
    }
}

