/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.importactions;

import fr.ifremer.tutti.service.csv.CsvComsumer;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatCsvFileResult;

public abstract class ImportActionSupport {
    protected final GenericFormatContextSupport importContext;

    protected abstract boolean canExecute();

    protected abstract void doExecute();

    protected ImportActionSupport(GenericFormatContextSupport importContext) {
        this.importContext = importContext;
    }

    public void execute() {
        boolean doExecute = this.canExecute();
        if (doExecute) {
            this.doExecute();
        } else {
            this.skipExecute();
        }
    }

    protected void skipExecute() {
    }

    protected void flushConsumer(CsvComsumer consumer, GenericFormatCsvFileResult importFileResult) {
        int maximumRowsInErrorPerFile = this.importContext.getImportRequest().getMaximumRowsInErrorPerFile();
        boolean fullyLoaded = consumer.getNbRowsInErrors() <= maximumRowsInErrorPerFile;
        importFileResult.flushErrors(consumer);
        importFileResult.setFullyLoaded(fullyLoaded);
    }
}

