/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.AbstractSpeciess;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntities;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationBusinessException;

public class Speciess
extends AbstractSpeciess {
    public static final Predicate<Species> IS_TEMPORARY = new Predicate<Species>(){

        public boolean apply(Species input) {
            return Speciess.isTemporary(input);
        }
    };
    public static final Comparator<Species> SPECIES_BY_NAME_COMPARATOR = new Comparator<Species>(){

        @Override
        public int compare(Species o1, Species o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };
    public static final Function<Species, String> GET_REFERECE_TAXON_ID = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getReferenceTaxonId());
        }
    };
    public static final Function<Species, Integer> GET_REFERECE_TAXON_ID_AS_INT = new Function<Species, Integer>(){

        public Integer apply(Species input) {
            return input.getReferenceTaxonId();
        }
    };
    public static final Function<Species, String> GET_REF_TAX_CODE = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getRefTaxCode());
        }
    };
    public static final Function<Species, String> GET_SURVEY_CODE = new Function<Species, String>(){

        public String apply(Species input) {
            return String.valueOf(input.getSurveyCode());
        }
    };
    public static final Function<Species, String> GET_NAME = new Function<Species, String>(){

        public String apply(Species input) {
            return input.getName();
        }
    };

    public static boolean isTemporary(Species species) {
        Preconditions.checkNotNull((Object)species);
        Preconditions.checkNotNull((Object)species.getId());
        return TuttiReferentialEntities.isStatusTemporary(species) && Speciess.isTemporaryId(species.getIdAsInt());
    }

    public static boolean isTemporaryId(Integer id) {
        Preconditions.checkNotNull((Object)id);
        return id < 0;
    }

    public static Map<String, Species> splitReferenceSpeciesByReferenceTaxonId(Iterable<Species> list) {
        for (Species species : list) {
            Preconditions.checkArgument((boolean)species.isReferenceTaxon(), (Object)("L'esp\u00e8ce " + species.getId() + " n'est pas r\u00e9f\u00e9rente."));
        }
        return Maps.uniqueIndex(list, GET_REFERECE_TAXON_ID);
    }

    public static Multimap<String, Species> splitByReferenceTaxonId(Iterable<Species> list) {
        return Multimaps.index(list, GET_REFERECE_TAXON_ID);
    }

    public static Multimap<String, Species> splitByRefTaxCode(Iterable<Species> list) {
        return Multimaps.index(list, GET_REF_TAX_CODE);
    }

    public static Multimap<String, Species> splitBySurveyCode(Iterable<Species> list) {
        return Multimaps.index(list, GET_SURVEY_CODE);
    }

    public static Set<String> toReferenceTaxonIds(List<Species> list) {
        HashSet result = list == null ? Collections.emptySet() : Sets.newHashSet((Iterable)Lists.transform(list, GET_REFERECE_TAXON_ID));
        return result;
    }

    public static String getSurveyCodeOrRefTaxCode(Species species) {
        String code = species.getSurveyCode();
        if (code == null) {
            code = species.getRefTaxCode();
        }
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new ApplicationBusinessException(I18n.t((String)"tutti.persistence.error.species.withNoSurveyCodeOrRefTaxCode", (Object[])new Object[]{species.getReferenceTaxonId(), species.getName()}));
        }
        return code;
    }
}

