// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: hibernate/HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.data.operation;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import fr.ifremer.adagio.core.dao.data.vessel.Vessel;
import java.io.Serializable;

/**
 * Informations permet de décrire, par exemple la stratégie de répartition entre le navire observé
 * et le navire associé pour l'opération.
 * En effet, des navires travaillent en paires (ou en bœufs), par exemple pour tirer à deux un meme
 * chalut.
 * note : Il peut s'agir d'un navire temporaire.
 */
// HibernateEntity.vsl annotations merge-point
public abstract class OperationVesselAssociation
    implements Serializable, Comparable<OperationVesselAssociation>
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -1665621571136924914L;

    private OperationVesselAssociationPK operationVesselAssociationPk;

    /**
     * Get the composite primary key identifier class
     * @return operationVesselAssociationPk
     */
    public OperationVesselAssociationPK getOperationVesselAssociationPk()
    {
        return this.operationVesselAssociationPk;
    }

    /**
     * Set the composite primary key identifier class
     * @param operationVesselAssociationPkIn
     */
    public void setOperationVesselAssociationPk(OperationVesselAssociationPK operationVesselAssociationPkIn) {
        this.operationVesselAssociationPk = operationVesselAssociationPkIn;
    }

    // Generate 2 attributes
    private Boolean isCatchOnOperationVessel;

    /**
     * La capture est elle à bord du navire observé ?
     * @return this.isCatchOnOperationVessel Boolean
     */
    public Boolean getIsCatchOnOperationVessel()
    {
        return this.isCatchOnOperationVessel;
    }

    /**
     * La capture est elle à bord du navire observé ?
     * @param isCatchOnOperationVesselIn Boolean
     */
    public void setIsCatchOnOperationVessel(Boolean isCatchOnOperationVesselIn)
    {
        this.isCatchOnOperationVessel = isCatchOnOperationVesselIn;
    }

    private String comments;

    /**
     * Commentaire sur la nature de l'association avec le navire (optionnel).
     * @return this.comments String
     */
    public String getComments()
    {
        return this.comments;
    }

    /**
     * Commentaire sur la nature de l'association avec le navire (optionnel).
     * @param commentsIn String
     */
    public void setComments(String commentsIn)
    {
        this.comments = commentsIn;
    }

    // Generate 2 associations
    private Vessel vessel;

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @return this.vessel Vessel
     */
    public Vessel getVessel()
    {
        return this.vessel;
    }

    /**
     * Navire. Peut etre un navire de peche professionnel ou non, un navire océanographique, etc.
     * @param vesselIn Vessel
     */
    public void setVessel(Vessel vesselIn)
    {
        this.vessel = vesselIn;
    }

    private Operation operation;

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @return this.operation Operation
     */
    public Operation getOperation()
    {
        return this.operation;
    }

    /**
     * Opération éffectuée dans le cadre d'une marée (observée en mer, observée au débarquement,
     * campagne
     * en mer,  marée déclarée, etc.).
     * Une opération peut etre une opération de peche ou non. Par exemple, au cours de campagne à la
     * mer,
     * le navire peut déployer des engins de collecte de données environnementales (température,
     * salinité,
     * etc. ).
     * @param operationIn Operation
     */
    public void setOperation(Operation operationIn)
    {
        this.operation = operationIn;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    @Override
    public boolean equals(Object object)
    {
        return super.equals(object);
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only take the identifiers of this entity into account when calculating the hash code.
     */
    @Override
    public int hashCode()
    {
        return super.hashCode();
    }

    /**
     * Constructs new instances of {@link OperationVesselAssociation}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link OperationVesselAssociation}.
         * @return new OperationVesselAssociationImpl()
         */
        public static OperationVesselAssociation newInstance()
        {
            return new OperationVesselAssociationImpl();
        }

        /**
         * Constructs a new instance of {@link OperationVesselAssociation}, taking all required and/or
         * read-only properties as arguments, except for identifiers.
         * @param vessel Vessel
         * @param operation Operation
         * @return newInstance
         */
        public static OperationVesselAssociation newInstance(Vessel vessel, Operation operation)
        {
            final OperationVesselAssociation entity = new OperationVesselAssociationImpl();
            entity.setVessel(vessel);
            entity.setOperation(operation);
            return entity;
        }

        /**
         * Constructs a new instance of {@link OperationVesselAssociation}, taking all possible properties
         * (except the identifier(s))as arguments.
         * @param isCatchOnOperationVessel Boolean
         * @param comments String
         * @param vessel Vessel
         * @param operation Operation
         * @return newInstance OperationVesselAssociation
         */
        public static OperationVesselAssociation newInstance(Boolean isCatchOnOperationVessel, String comments, Vessel vessel, Operation operation)
        {
            final OperationVesselAssociation entity = new OperationVesselAssociationImpl();
            entity.setIsCatchOnOperationVessel(isCatchOnOperationVessel);
            entity.setComments(comments);
            entity.setVessel(vessel);
            entity.setOperation(operation);
            return entity;
        }
    }

    /**
     * @see Comparable#compareTo
     */
    public int compareTo(OperationVesselAssociation o)
    {
        int cmp = 0;
        if (this.getOperationVesselAssociationPk() != null)
        {
            cmp = this.getOperationVesselAssociationPk().compareTo(o.getOperationVesselAssociationPk());
        }
            if (this.getIsCatchOnOperationVessel() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getIsCatchOnOperationVessel().compareTo(o.getIsCatchOnOperationVessel()));
            }
            if (this.getComments() != null)
            {
                cmp = (cmp != 0 ? cmp : this.getComments().compareTo(o.getComments()));
            }
        return cmp;
    }
// HibernateEntity.vsl merge-point
// OperationVesselAssociation.java merge-point
}