/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jaxx.widgets.number;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import jaxx.runtime.spi.UIHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.widgets.ModelToBean;
import org.nuiton.jaxx.widgets.MutateOnConditionalPropertyChangeListener;
import org.nuiton.jaxx.widgets.number.NumberEditor;
import org.nuiton.jaxx.widgets.number.NumberEditorConfig;
import org.nuiton.jaxx.widgets.number.NumberEditorModel;
import org.nuiton.util.beans.BeanUtil;

public class NumberEditorHandler
implements UIHandler<NumberEditor> {
    private static final Log log = LogFactory.getLog(NumberEditorHandler.class);
    protected static final ImmutableSet<Class<?>> INT_CLASSES = ImmutableSet.copyOf((Collection)Sets.newHashSet((Object[])new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, BigInteger.class}));
    private static final String VALIDATE_PROPERTY = "validate";
    protected NumberEditor ui;
    protected Pattern numberPattern;
    protected NumberParserFormatter numberParserFormatter;
    private static Map<Class<?>, NumberParserFormatter<?>> numberFactories;
    protected static final ImmutableSet<String> NULL_LIMIT_DECIMALS;
    protected static final ImmutableSet<String> NULL_LIMIT_INTS;

    public void beforeInit(NumberEditor ui) {
        this.ui = ui;
        NumberEditorModel model = new NumberEditorModel(new NumberEditorConfig());
        ui.setContextValue(model);
    }

    public void afterInit(NumberEditor ui) {
    }

    public void addChar(char c) {
        try {
            this.ui.getTextField().getDocument().insertString(this.ui.getTextField().getCaretPosition(), c + "", null);
        }
        catch (BadLocationException e) {
            log.warn((Object)e);
        }
        this.setTextValue(this.ui.getTextField().getText());
    }

    public void removeChar() {
        JTextField textField = this.ui.getTextField();
        int position = textField.getCaretPosition();
        if (position < 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"cannot remove when caret on first position or text empty");
            }
            return;
        }
        try {
            textField.getDocument().remove(position - 1, 1);
        }
        catch (BadLocationException ex) {
            log.debug((Object)ex);
            return;
        }
        String newText = textField.getText();
        if (log.isDebugEnabled()) {
            log.debug((Object)("text updated : " + newText));
        }
        textField.setCaretPosition(--position);
        this.setTextValue(newText);
    }

    public void reset() {
        this.setTextValue("");
    }

    public void toggleSign() {
        String newValue = this.ui.getModel().getTextValue();
        newValue = newValue.startsWith("-") ? newValue.substring(1) : "-" + newValue;
        this.setTextValue(newValue);
    }

    public void setTextValue(String newText) {
        boolean textValid;
        NumberEditorModel model = this.ui.getModel();
        if (StringUtils.isEmpty((CharSequence)newText)) {
            textValid = true;
        } else if (this.numberPattern != null) {
            Matcher matcher = this.numberPattern.matcher(newText);
            textValid = matcher.matches();
            if (!textValid && model.isCanUseSign() && "-".equals(newText)) {
                textValid = true;
            }
        } else {
            textValid = true;
        }
        if (textValid) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Text [" + newText + "] is valid, will set it to model"));
            }
            model.setTextValue(newText);
        } else {
            String oldText = model.getTextValue();
            if (oldText == null) {
                oldText = "";
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Text [" + newText + "] is not valid, will rollback to previous valid text: " + oldText));
            }
            int caretPosition = this.ui.getTextField().getCaretPosition() - 1;
            this.ui.getTextField().setText(oldText);
            if (caretPosition >= 0) {
                this.ui.getTextField().setCaretPosition(caretPosition);
            }
        }
    }

    public void setPopupVisible(Boolean newValue) {
        if (log.isTraceEnabled()) {
            log.trace((Object)newValue);
        }
        if (newValue == null || !newValue.booleanValue()) {
            this.ui.getPopup().setVisible(false);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JComponent invoker = NumberEditorHandler.this.ui.isShowPopupButton() != false ? NumberEditorHandler.this.ui.getShowPopUpButton() : NumberEditorHandler.this.ui;
                Dimension dim = NumberEditorHandler.this.ui.getPopup().getPreferredSize();
                int x = (int)(invoker.getPreferredSize().getWidth() - dim.getWidth());
                NumberEditorHandler.this.ui.getPopup().show(invoker, x, invoker.getHeight());
                NumberEditorHandler.this.ui.getTextField().requestFocus();
            }
        });
    }

    protected void init() {
        String property;
        boolean canBeDecimal;
        NumberEditorModel model = this.ui.getModel();
        NumberEditorConfig config = model.getConfig();
        Class<?> numberType = config.getNumberType();
        Preconditions.checkState((numberType != null ? 1 : 0) != 0, (Object)("Required a number type on " + this.ui));
        this.numberParserFormatter = NumberEditorHandler.getNumberFactory(numberType);
        if (log.isInfoEnabled()) {
            log.info((Object)("init numberType: " + numberType + " on " + this.ui));
        }
        Boolean useDecimal = config.getUseDecimal();
        boolean bl = canBeDecimal = !INT_CLASSES.contains(numberType);
        if (useDecimal == null) {
            useDecimal = canBeDecimal;
            config.setUseDecimal(useDecimal);
        } else {
            Preconditions.checkState((useDecimal == false || canBeDecimal ? 1 : 0) != 0, (Object)("Can't use decimal with the following number type " + numberType + " on " + this.ui));
        }
        String numberPatternDef = model.getNumberPattern();
        if (StringUtils.isNotEmpty((CharSequence)numberPatternDef)) {
            this.setNumberPattern(numberPatternDef);
        }
        model.addPropertyChangeListener("numberPattern", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String newPattern = (String)evt.getNewValue();
                NumberEditorHandler.this.setNumberPattern(newPattern);
                if (log.isInfoEnabled()) {
                    log.info((Object)("set new numberPattern" + newPattern));
                }
                NumberEditorHandler.this.numberPattern = StringUtils.isEmpty((CharSequence)newPattern) ? null : Pattern.compile(newPattern);
            }
        });
        model.addPropertyChangeListener("numberValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Number newValue = (Number)evt.getNewValue();
                NumberEditorHandler.this.setTextValueFromNumberValue(newValue);
            }
        });
        model.addPropertyChangeListener("textValue", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String newValue = (String)evt.getNewValue();
                NumberEditorHandler.this.setNumberValueFromTextValue(newValue);
            }
        });
        Serializable bean = model.getBean();
        if (bean != null && (property = config.getProperty()) != null) {
            Method mutator = BeanUtil.getMutator((Object)bean, (String)property);
            Preconditions.checkNotNull((Object)mutator, (Object)("could not find mutator for " + property));
            Class<?>[] parameterTypes = mutator.getParameterTypes();
            Preconditions.checkNotNull((Object)parameterTypes[0].equals(numberType), (Object)("Mismatch mutator type, required a " + numberType + " but was " + parameterTypes[0]));
            model.addPropertyChangeListener("numberValue", (PropertyChangeListener)new MutateOnConditionalPropertyChangeListener((ModelToBean)model, mutator, model.canUpdateBeanNumberValuePredicate()));
        }
        this.ui.addPropertyChangeListener("showPopupButton", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (NumberEditorHandler.this.ui.getPopup().isVisible()) {
                    NumberEditorHandler.this.setPopupVisible(false);
                }
            }
        });
        this.ui.addPropertyChangeListener("autoPopup", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (NumberEditorHandler.this.ui.getPopup().isVisible()) {
                    NumberEditorHandler.this.setPopupVisible(false);
                }
            }
        });
        this.ui.addPropertyChangeListener("popupVisible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NumberEditorHandler.this.setPopupVisible((Boolean)evt.getNewValue());
            }
        });
        this.ui.getTextField().addMouseListener(new PopupListener());
        Number numberValue = model.getNumberValue();
        this.setTextValueFromNumberValue(numberValue);
    }

    protected void setNumberPattern(String newPattern) {
        try {
            this.numberPattern = Pattern.compile(newPattern);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not compute numberPattern " + newPattern + " on " + this.ui, e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("init numberPattern: " + this.numberPattern + " on " + this.ui));
        }
    }

    protected void setNumberValueFromTextValue(String textValue) {
        if (this.ui.getModel().isNumberValueIsAdjusting()) {
            return;
        }
        Number numberValue = StringUtils.isBlank((CharSequence)textValue) ? (Number)null : (Number)((Number)this.numberParserFormatter.parse(textValue));
        if (log.isInfoEnabled()) {
            log.info((Object)("Set numberValue " + numberValue + " from textValue " + textValue));
        }
        this.ui.getModel().setNumberValue(numberValue);
    }

    protected void setTextValueFromNumberValue(Number numberValue) {
        if (this.ui.getModel().isTextValueIsAdjusting()) {
            return;
        }
        String textValue = this.numberParserFormatter.format(numberValue);
        if (log.isInfoEnabled()) {
            log.info((Object)("Set textValue " + textValue + " from numberValue " + numberValue));
        }
        this.ui.getModel().setTextValue(textValue);
    }

    protected void validate() {
        this.setPopupVisible(false);
        this.ui.firePropertyChange(VALIDATE_PROPERTY, null, (Object)true);
    }

    protected static NumberParserFormatter<?> getNumberFactory(Class<?> numberType) {
        if (numberFactories == null) {
            numberFactories = new HashMap();
            NumberParserFormatter<Byte> byteSupport = new NumberParserFormatter<Byte>(){

                @Override
                public String format(Byte numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Byte parse(String textValue) {
                    Byte v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Byte.valueOf(Byte.parseByte(textValue));
                    return v;
                }
            };
            numberFactories.put(Byte.TYPE, byteSupport);
            numberFactories.put(Byte.class, byteSupport);
            NumberParserFormatter<Short> shortSupport = new NumberParserFormatter<Short>(){

                @Override
                public String format(Short numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Short parse(String textValue) {
                    Short v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Short.valueOf(Short.parseShort(textValue));
                    return v;
                }
            };
            numberFactories.put(Short.TYPE, shortSupport);
            numberFactories.put(Short.class, shortSupport);
            NumberParserFormatter<Integer> integerSupport = new NumberParserFormatter<Integer>(){

                @Override
                public String format(Integer numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Integer parse(String textValue) {
                    Integer v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Integer.valueOf(Integer.parseInt(textValue));
                    return v;
                }
            };
            numberFactories.put(Integer.TYPE, integerSupport);
            numberFactories.put(Integer.class, integerSupport);
            NumberParserFormatter<Long> longSupport = new NumberParserFormatter<Long>(){

                @Override
                public String format(Long numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public Long parse(String textValue) {
                    Long v = NULL_LIMIT_INTS.contains((Object)textValue) ? null : Long.valueOf(Long.parseLong(textValue));
                    return v;
                }
            };
            numberFactories.put(Long.TYPE, longSupport);
            numberFactories.put(Long.class, longSupport);
            NumberParserFormatter<Float> floatSupport = new NumberParserFormatter<Float>(){
                final DecimalFormat df = new DecimalFormat("#.##########");

                @Override
                public String format(Float numberValue) {
                    String format;
                    if (numberValue == null) {
                        format = "";
                    } else {
                        format = String.valueOf(numberValue);
                        if (format.contains("E") && (format = this.df.format(numberValue)).contains(",")) {
                            format = format.replace(",", ".");
                        }
                    }
                    return format;
                }

                @Override
                public Float parse(String textValue) {
                    Float v;
                    if (NULL_LIMIT_DECIMALS.contains((Object)textValue)) {
                        v = null;
                    } else {
                        boolean addSign = false;
                        if (textValue.startsWith("-")) {
                            addSign = true;
                            if ((textValue = textValue.substring(1)).startsWith(".")) {
                                textValue = "0" + textValue;
                            }
                        }
                        v = Float.valueOf(Float.parseFloat(textValue));
                        if (addSign) {
                            v = Float.valueOf(-v.floatValue());
                        }
                    }
                    return v;
                }
            };
            numberFactories.put(Float.TYPE, floatSupport);
            numberFactories.put(Float.class, floatSupport);
            NumberParserFormatter<Double> doubleSupport = new NumberParserFormatter<Double>(){
                final DecimalFormat df = new DecimalFormat("#.##########");

                @Override
                public String format(Double numberValue) {
                    String format;
                    if (numberValue == null) {
                        format = "";
                    } else {
                        format = String.valueOf(numberValue);
                        if (format.contains("E") && (format = this.df.format(numberValue)).contains(",")) {
                            format = format.replace(",", ".");
                        }
                    }
                    return format;
                }

                @Override
                public Double parse(String textValue) {
                    Double v;
                    if (NULL_LIMIT_DECIMALS.contains((Object)textValue)) {
                        v = null;
                    } else {
                        boolean addSign = false;
                        if (textValue.startsWith("-")) {
                            addSign = true;
                            if ((textValue = textValue.substring(1)).startsWith(".")) {
                                textValue = "0" + textValue;
                            }
                        }
                        v = Double.parseDouble(textValue);
                        if (addSign) {
                            v = -v.doubleValue();
                        }
                    }
                    return v;
                }
            };
            numberFactories.put(Double.TYPE, doubleSupport);
            numberFactories.put(Double.class, doubleSupport);
            NumberParserFormatter<BigInteger> bigIntegerSupport = new NumberParserFormatter<BigInteger>(){

                @Override
                public String format(BigInteger numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public BigInteger parse(String textValue) {
                    return new BigInteger(textValue);
                }
            };
            numberFactories.put(BigInteger.class, bigIntegerSupport);
            NumberParserFormatter<BigDecimal> bigDecimalSupport = new NumberParserFormatter<BigDecimal>(){

                @Override
                public String format(BigDecimal numberValue) {
                    return numberValue == null ? "" : String.valueOf(numberValue);
                }

                @Override
                public BigDecimal parse(String textValue) {
                    return new BigDecimal(textValue);
                }
            };
            numberFactories.put(BigDecimal.class, bigDecimalSupport);
        }
        for (Map.Entry<Class<?>, NumberParserFormatter<?>> entry : numberFactories.entrySet()) {
            if (!entry.getKey().equals(numberType)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Could not find a NumberFactory for type " + numberType);
    }

    static {
        NULL_LIMIT_DECIMALS = ImmutableSet.copyOf((Object[])new String[]{"-", ".", "-."});
        NULL_LIMIT_INTS = ImmutableSet.copyOf((Object[])new String[]{"-"});
    }

    static interface NumberParserFormatter<N extends Number> {
        public N parse(String var1);

        public String format(N var1);
    }

    protected class PopupListener
    extends MouseAdapter {
        protected PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        protected void maybeShowPopup(MouseEvent e) {
            if (!e.isPopupTrigger()) {
                return;
            }
            if (NumberEditorHandler.this.ui.isAutoPopup().booleanValue()) {
                if (NumberEditorHandler.this.ui.isPopupVisible().booleanValue()) {
                    if (!NumberEditorHandler.this.ui.getPopup().isVisible()) {
                        NumberEditorHandler.this.setPopupVisible(true);
                    }
                } else {
                    NumberEditorHandler.this.ui.setPopupVisible(true);
                }
            } else if (NumberEditorHandler.this.ui.isPopupVisible().booleanValue()) {
                NumberEditorHandler.this.setPopupVisible(true);
            }
        }
    }
}

