/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value;

public class StringMap {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;

    public StringMap() {
        this.table = new Entry[11];
    }

    public StringMap(StringMap stringMap) {
        this.count = stringMap.count;
        this.table = new Entry[stringMap.table.length];
        int n = 0;
        while (n < this.table.length) {
            Entry entry = stringMap.table[n];
            Entry entry2 = null;
            if (entry != null) {
                this.table[n] = entry2 = new Entry(entry.hash, entry.key, entry.value, null);
                entry = entry.next;
                while (entry != null) {
                    entry2 = entry2.next = new Entry(entry.hash, entry.key, entry.value, null);
                    entry = entry.next;
                }
            }
            ++n;
        }
    }

    public Object get(String string) {
        int n = string.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == string) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(String string, Object object) {
        Entry entry;
        int n = string.hashCode() & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry2 = this.table[n2];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.key == string) {
                Object object2 = entry2.value;
                entry2.value = object;
                return object2;
            }
            entry2 = entry2.next;
        }
        int n3 = this.table.length;
        if (this.count++ >= n3 * 3 >>> 2) {
            this.rehash();
            n2 = n % this.table.length;
        }
        this.table[n2] = entry = new Entry(n, string, object, this.table[n2]);
        return null;
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        int n = entryArray.length - 1;
        while (n >= 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n2 = entry2.hash % this.table.length;
                entry2.next = this.table[n2];
                this.table[n2] = entry2;
            }
            --n;
        }
    }

    protected static class Entry {
        public int hash;
        public String key;
        public Object value;
        public Entry next;

        public Entry(int n, String string, Object object, Entry entry) {
            this.hash = n;
            this.key = string;
            this.value = object;
            this.next = entry;
        }
    }
}

