/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.socket;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.HttpServerConnection;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpService;

public class SynchroWorkerThread
extends Thread {
    private static final Log log = LogFactory.getLog(SynchroWorkerThread.class);
    private final HttpService httpservice;
    private final HttpServerConnection conn;

    public SynchroWorkerThread(HttpService httpservice, HttpServerConnection conn) {
        this.httpservice = httpservice;
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        log.debug((Object)"New connection thread");
        BasicHttpContext context = new BasicHttpContext(null);
        try {
            while (!Thread.interrupted() && this.conn.isOpen()) {
                this.httpservice.handleRequest(this.conn, (HttpContext)context);
            }
        }
        catch (ConnectionClosedException ex) {
            log.warn((Object)"Client closed connection");
        }
        catch (IOException ex) {
            log.error((Object)("I/O error: " + ex.getMessage()));
        }
        catch (HttpException ex) {
            log.error((Object)("Unrecoverable HTTP protocol violation: " + ex.getMessage()));
        }
        finally {
            try {
                this.conn.shutdown();
            }
            catch (IOException ignore) {}
        }
    }
}

