package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import jaxx.runtime.swing.JAXXWidgetUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.swing.DefaultLookup;

import javax.swing.*;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

import static org.nuiton.i18n.I18n.t;

/**
 * Component to render and delete log items from logs table.
 *
 * @author Kevin Morin (Code Lutin)
 * @since 3.8
 */
public class SpeciesFrequencyLogCellComponent extends JPanel implements Serializable {

    private static final long serialVersionUID = 1L;

    /** Logger. */
    private static final Log log = LogFactory.getLog(SpeciesFrequencyLogCellComponent.class);

    private JLabel label = new JLabel();

    private JButton deleteButton = new JButton();

    private SpeciesFrequencyLogRowModel row;

    public SpeciesFrequencyLogCellComponent() {
        setLayout(new BorderLayout());

        Font defaultFont = UIManager.getFont("Table.font");
        label.setFont(defaultFont);
        label.setOpaque(false);
        add(label, BorderLayout.CENTER);

        deleteButton.setIcon(JAXXWidgetUtil.createActionIcon("delete"));
        deleteButton.setBorderPainted(false);
        deleteButton.setBorder(null);
        deleteButton.setBackground(null);
        label.setOpaque(false);
        add(deleteButton, BorderLayout.EAST);
    }

    public SpeciesFrequencyLogCellComponent(final SpeciesFrequencyUIHandler speciesFrequencyUIHandler) {
        this();
        deleteButton.addActionListener(new ActionListener() {
            @Override
            public void actionPerformed(ActionEvent e) {
                if (row != null) {
                    int i = JOptionPane.showConfirmDialog(
                            speciesFrequencyUIHandler.getTopestUI(),
                            t("tutti.editSpeciesFrequencies.logTable.removeRow.confirm.message", row.getLabel()),
                            t("tutti.editSpeciesFrequencies.logTable.removeRow.confirm.title"),
                            JOptionPane.YES_NO_OPTION,
                            JOptionPane.QUESTION_MESSAGE);

                    if (i == JOptionPane.YES_OPTION) {
                        speciesFrequencyUIHandler.decrementLengthStep(row);
                    }
                }
            }
        });
    }

    public void setData(String data) {
        label.setText(data);
    }

    public void setRow(SpeciesFrequencyLogRowModel row) {
        this.row = row;
    }

    public static TableCellRenderer newRender() {
        return new FrequencyLogCellRenderer();
    }

    public static TableCellEditor newEditor(SpeciesFrequencyUIHandler speciesFrequencyUIHandler) {
        return new FrequencyLogCellEditor(speciesFrequencyUIHandler);
    }

    public static class FrequencyLogCellEditor extends AbstractCellEditor implements TableCellEditor {

        private static final long serialVersionUID = 1L;

        protected final SpeciesFrequencyLogCellComponent component;

        public FrequencyLogCellEditor(SpeciesFrequencyUIHandler speciesFrequencyUIHandler) {
            component = new SpeciesFrequencyLogCellComponent(speciesFrequencyUIHandler);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table,
                                                     Object value,
                                                     boolean isSelected,
                                                     int row,
                                                     int column) {

            SpeciesFrequencyLogsTableModel tableModel = (SpeciesFrequencyLogsTableModel) table.getModel();
            SpeciesFrequencyLogRowModel editRow = tableModel.getEntry(row);
            component.setRow(editRow);

            String data = (String) value;
            component.setData(data);

            return component;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }

    }

    public static class FrequencyLogCellRenderer implements TableCellRenderer {

        protected final SpeciesFrequencyLogCellComponent component;

        public FrequencyLogCellRenderer() {
            component = new SpeciesFrequencyLogCellComponent();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table,
                                                       Object value,
                                                       boolean isSelected,
                                                       boolean hasFocus,
                                                       int row,
                                                       int column) {
            String data = (String) value;
            component.setData(data);

            component.setBackground(Color.WHITE);

            return component;
        }

    }

}
