/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.gvt.flow;

import java.awt.geom.Point2D;
import org.apache.batik.gvt.flow.BlockInfo;
import org.apache.batik.gvt.flow.FlowRegions;
import org.apache.batik.gvt.flow.GlyphGroupInfo;
import org.apache.batik.gvt.flow.WordInfo;
import org.apache.batik.gvt.font.GVTGlyphVector;

public class LineInfo {
    FlowRegions fr;
    double lineHeight = -1.0;
    double ascent = -1.0;
    double descent = -1.0;
    double hLeading = -1.0;
    double baseline;
    int numGlyphs;
    int words = 0;
    int size = 0;
    GlyphGroupInfo[] ggis = null;
    int newSize = 0;
    GlyphGroupInfo[] newGGIS = null;
    int numRanges;
    double[] ranges;
    double[] rangeAdv;
    BlockInfo bi = null;
    boolean paraStart;
    boolean paraEnd;
    protected static final int FULL_WORD = 0;
    protected static final int FULL_ADV = 1;
    static final float MAX_COMPRESS = 0.1f;
    static final float COMRESS_SCALE = 3.0f;

    public LineInfo(FlowRegions flowRegions, BlockInfo blockInfo, boolean bl) {
        this.fr = flowRegions;
        this.bi = blockInfo;
        this.lineHeight = blockInfo.getLineHeight();
        this.ascent = blockInfo.getAscent();
        this.descent = blockInfo.getDescent();
        this.hLeading = (this.lineHeight - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(flowRegions.getCurrentY() + this.hLeading + this.ascent);
        this.paraStart = bl;
        this.paraEnd = false;
        if (this.lineHeight > 0.0) {
            flowRegions.newLineHeight(this.lineHeight);
            this.updateRangeInfo();
        }
    }

    public void setParaEnd(boolean bl) {
        this.paraEnd = bl;
    }

    public boolean addWord(WordInfo wordInfo) {
        double d = wordInfo.getLineHeight();
        if (d <= this.lineHeight) {
            return this.insertWord(wordInfo);
        }
        this.fr.newLineHeight(d);
        if (!this.updateRangeInfo()) {
            if (this.lineHeight > 0.0) {
                this.fr.newLineHeight(this.lineHeight);
            }
            return false;
        }
        if (!this.insertWord(wordInfo)) {
            if (this.lineHeight > 0.0) {
                this.setLineHeight(this.lineHeight);
            }
            return false;
        }
        this.lineHeight = d;
        if ((double)wordInfo.getAscent() > this.ascent) {
            this.ascent = wordInfo.getAscent();
        }
        if ((double)wordInfo.getDescent() > this.descent) {
            this.descent = wordInfo.getDescent();
        }
        this.hLeading = (d - (this.ascent + this.descent)) / 2.0;
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return true;
    }

    public boolean insertWord(WordInfo wordInfo) {
        this.mergeGlyphGroups(wordInfo);
        if (!this.assignGlyphGroupRanges(this.newSize, this.newGGIS)) {
            return false;
        }
        this.swapGlyphGroupInfo();
        return true;
    }

    public boolean assignGlyphGroupRanges(int n, GlyphGroupInfo[] glyphGroupInfoArray) {
        int n2 = 0;
        for (int i = 0; i < this.numRanges; ++i) {
            GlyphGroupInfo glyphGroupInfo;
            double d = this.ranges[2 * i + 1] - this.ranges[2 * i];
            float f = 0.0f;
            float f2 = 0.0f;
            double d2 = d;
            while (n2 < n) {
                glyphGroupInfo = glyphGroupInfoArray[n2];
                glyphGroupInfo.setRange(i);
                f = glyphGroupInfo.getAdvance();
                double d3 = d - (double)(f2 + f);
                if (d3 < 0.0) break;
                ++n2;
                f2 += f;
            }
            if (n2 == n) {
                --n2;
                f2 -= f;
            }
            glyphGroupInfo = glyphGroupInfoArray[n2];
            float f3 = glyphGroupInfo.getLastAdvance();
            while ((double)(f2 + f3) > d) {
                f3 = 0.0f;
                if (--n2 < 0 || i != (glyphGroupInfo = glyphGroupInfoArray[n2]).getRange()) break;
                f2 -= glyphGroupInfo.getAdvance();
                f3 = glyphGroupInfo.getLastAdvance();
            }
            this.rangeAdv[i] = f2 + f3;
            if (++n2 != n) continue;
            return true;
        }
        return false;
    }

    public boolean setLineHeight(double d) {
        this.fr.newLineHeight(d);
        if (this.updateRangeInfo()) {
            this.lineHeight = d;
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.fr.newLineHeight(this.lineHeight);
        }
        return false;
    }

    public double getCurrentY() {
        return this.fr.getCurrentY();
    }

    public boolean gotoY(double d) {
        if (this.fr.gotoY(d)) {
            return true;
        }
        if (this.lineHeight > 0.0) {
            this.updateRangeInfo();
        }
        this.baseline = (float)(this.fr.getCurrentY() + this.hLeading + this.ascent);
        return false;
    }

    protected boolean updateRangeInfo() {
        int n;
        this.fr.resetRange();
        int n2 = this.fr.getNumRangeOnLine();
        if (n2 == 0) {
            return false;
        }
        this.numRanges = n2;
        if (this.ranges == null) {
            this.rangeAdv = new double[this.numRanges];
            this.ranges = new double[2 * this.numRanges];
        } else if (this.numRanges > this.rangeAdv.length) {
            n = 2 * this.rangeAdv.length;
            if (n < this.numRanges) {
                n = this.numRanges;
            }
            this.rangeAdv = new double[n];
            this.ranges = new double[2 * n];
        }
        n = 0;
        while (n < this.numRanges) {
            double d;
            double[] dArray = this.fr.nextRange();
            double d2 = dArray[0];
            if (n == 0) {
                d = this.bi.getLeftMargin();
                if (this.paraStart) {
                    double d3 = this.bi.getIndent();
                    d = d < -d3 ? 0.0 : (d += d3);
                }
                d2 += d;
            }
            d = dArray[1];
            if (n == this.numRanges - 1) {
                d -= (double)this.bi.getRightMargin();
            }
            this.ranges[2 * n] = d2;
            this.ranges[2 * n + 1] = d;
            ++n;
        }
        return true;
    }

    protected void swapGlyphGroupInfo() {
        GlyphGroupInfo[] glyphGroupInfoArray = this.ggis;
        this.ggis = this.newGGIS;
        this.newGGIS = glyphGroupInfoArray;
        this.size = this.newSize;
        this.newSize = 0;
    }

    protected void mergeGlyphGroups(WordInfo wordInfo) {
        int n = wordInfo.getNumGlyphGroups();
        this.newSize = 0;
        if (this.ggis == null) {
            this.newSize = n;
            this.newGGIS = new GlyphGroupInfo[n];
            int n2 = 0;
            while (n2 < n) {
                this.newGGIS[n2] = wordInfo.getGlyphGroup(n2);
                ++n2;
            }
        } else {
            int n3 = 0;
            int n4 = 0;
            GlyphGroupInfo glyphGroupInfo = wordInfo.getGlyphGroup(n4);
            int n5 = glyphGroupInfo.getStart();
            GlyphGroupInfo glyphGroupInfo2 = this.ggis[this.size - 1];
            int n6 = glyphGroupInfo2.getStart();
            this.newGGIS = LineInfo.assureSize(this.newGGIS, this.size + n);
            if (n5 < n6) {
                glyphGroupInfo2 = this.ggis[n3];
                n6 = glyphGroupInfo2.getStart();
                while (n3 < this.size && n4 < n) {
                    if (n5 < n6) {
                        this.newGGIS[this.newSize++] = glyphGroupInfo;
                        if (++n4 >= n) continue;
                        glyphGroupInfo = wordInfo.getGlyphGroup(n4);
                        n5 = glyphGroupInfo.getStart();
                        continue;
                    }
                    this.newGGIS[this.newSize++] = glyphGroupInfo2;
                    if (++n3 >= this.size) continue;
                    glyphGroupInfo2 = this.ggis[n3];
                    n6 = glyphGroupInfo2.getStart();
                }
            }
            while (n3 < this.size) {
                this.newGGIS[this.newSize++] = this.ggis[n3++];
            }
            while (n4 < n) {
                this.newGGIS[this.newSize++] = wordInfo.getGlyphGroup(n4++);
            }
        }
    }

    public void layout() {
        int n;
        if (this.size == 0) {
            return;
        }
        this.assignGlyphGroupRanges(this.size, this.ggis);
        GVTGlyphVector gVTGlyphVector = this.ggis[0].getGlyphVector();
        boolean bl = false;
        double d = 0.0;
        double d2 = 0.0;
        int[] nArray = new int[this.numRanges];
        int[] nArray2 = new int[this.numRanges];
        GlyphGroupInfo[] glyphGroupInfoArray = new GlyphGroupInfo[this.numRanges];
        GlyphGroupInfo glyphGroupInfo = this.ggis[0];
        int n2 = n = glyphGroupInfo.getRange();
        nArray[n2] = nArray[n2] + 1;
        int n3 = n;
        nArray2[n3] = nArray2[n3] + glyphGroupInfo.getGlyphCount();
        int n4 = 1;
        while (n4 < this.size) {
            glyphGroupInfo = this.ggis[n4];
            n = glyphGroupInfo.getRange();
            if (glyphGroupInfoArray[n] == null || !glyphGroupInfoArray[n].getHideLast()) {
                int n5 = n;
                nArray[n5] = nArray[n5] + 1;
            }
            glyphGroupInfoArray[n] = glyphGroupInfo;
            int n6 = n;
            nArray2[n6] = nArray2[n6] + glyphGroupInfo.getGlyphCount();
            GlyphGroupInfo glyphGroupInfo2 = this.ggis[n4 - 1];
            int n7 = glyphGroupInfo2.getRange();
            if (n != n7) {
                int n8 = n7;
                nArray2[n8] = nArray2[n8] + (glyphGroupInfo2.getLastGlyphCount() - glyphGroupInfo2.getGlyphCount());
            }
            ++n4;
        }
        int n9 = n;
        nArray2[n9] = nArray2[n9] + (glyphGroupInfo.getLastGlyphCount() - glyphGroupInfo.getGlyphCount());
        int n10 = -1;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        n = -1;
        glyphGroupInfo = null;
        int n11 = 0;
        while (n11 < this.size) {
            int n12;
            block20: {
                GlyphGroupInfo glyphGroupInfo3;
                block19: {
                    glyphGroupInfo3 = glyphGroupInfo;
                    int n13 = n10;
                    glyphGroupInfo = this.ggis[n11];
                    n10 = glyphGroupInfo.getRange();
                    if (n10 == n13) break block19;
                    d3 = this.ranges[2 * n10];
                    d4 = this.ranges[2 * n10 + 1] - d3;
                    d5 = this.rangeAdv[n10];
                    n12 = this.bi.getTextAlignment();
                    if (this.paraEnd && n12 == 3) {
                        n12 = 0;
                    }
                    switch (n12) {
                        default: {
                            double d6 = d4 - d5;
                            if (!bl) {
                                int n14 = nArray[n10] - 1;
                                if (n14 >= 1) {
                                    d = d6 / (double)n14;
                                    break;
                                }
                            } else {
                                int n15 = nArray2[n10] - 1;
                                if (n15 >= 1) {
                                    d2 = d6 / (double)n15;
                                    break;
                                }
                            }
                            break block20;
                        }
                        case 0: {
                            break;
                        }
                        case 1: {
                            d3 += (d4 - d5) / 2.0;
                            break;
                        }
                        case 2: {
                            d3 += d4 - d5;
                            break;
                        }
                    }
                    break block20;
                }
                if (glyphGroupInfo3 != null && glyphGroupInfo3.getHideLast()) {
                    gVTGlyphVector.setGlyphVisible(glyphGroupInfo3.getEnd(), false);
                }
            }
            n12 = glyphGroupInfo.getStart();
            int n16 = glyphGroupInfo.getEnd();
            boolean[] blArray = glyphGroupInfo.getHide();
            Point2D point2D = gVTGlyphVector.getGlyphPosition(n12);
            double d7 = point2D.getX();
            double d8 = 0.0;
            int n17 = n12;
            while (n17 <= n16) {
                Point2D point2D2 = gVTGlyphVector.getGlyphPosition(n17 + 1);
                if (blArray[n17 - n12]) {
                    gVTGlyphVector.setGlyphVisible(n17, false);
                    d8 += point2D2.getX() - point2D.getX();
                } else {
                    gVTGlyphVector.setGlyphVisible(n17, true);
                }
                point2D.setLocation(point2D.getX() - d7 - d8 + d3, point2D.getY() + this.baseline);
                gVTGlyphVector.setGlyphPosition(n17, point2D);
                point2D = point2D2;
                d8 -= d2;
                ++n17;
            }
            d3 = glyphGroupInfo.getHideLast() ? (d3 += (double)glyphGroupInfo.getAdvance() - d8) : (d3 += (double)glyphGroupInfo.getAdvance() - d8 + d);
            ++n11;
        }
    }

    public static GlyphGroupInfo[] assureSize(GlyphGroupInfo[] glyphGroupInfoArray, int n) {
        if (glyphGroupInfoArray == null) {
            if (n < 10) {
                n = 10;
            }
            return new GlyphGroupInfo[n];
        }
        if (n <= glyphGroupInfoArray.length) {
            return glyphGroupInfoArray;
        }
        int n2 = glyphGroupInfoArray.length * 2;
        if (n2 < n) {
            n2 = n;
        }
        return new GlyphGroupInfo[n2];
    }
}

