/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise.tree;

import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.cruise.tree.CruiseTreeNode;
import fr.ifremer.tutti.ui.swing.content.cruise.tree.MessageTreeNode;
import fr.ifremer.tutti.ui.swing.content.cruise.tree.OperationTreeNode;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import jaxx.runtime.SwingUtil;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class ValidationTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;
    private final Decorator<Cruise> cruiseDecorator;
    private final Decorator<FishingOperation> fishingOperationDecorator;

    public ValidationTreeCellRenderer(Decorator<Cruise> cruiseDecorator, Decorator<FishingOperation> fishingOperationDecorator) {
        this.cruiseDecorator = cruiseDecorator;
        this.fishingOperationDecorator = fishingOperationDecorator;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (value != null) {
            if (value instanceof CruiseTreeNode) {
                CruiseTreeNode node = (CruiseTreeNode)value;
                String text = this.cruiseDecorator.toString((Object)node.getUserObject());
                label.setText(text);
                label.setToolTipText(text);
                label.setIcon(SwingUtil.createActionIcon((String)"cruise"));
            } else if (value instanceof OperationTreeNode) {
                OperationTreeNode node = (OperationTreeNode)value;
                String text = this.fishingOperationDecorator.toString((Object)node.getUserObject());
                label.setText(text);
                label.setToolTipText(text);
                label.setIcon(SwingUtil.createActionIcon((String)"observed_fishing_trip"));
            } else if (value instanceof MessageTreeNode) {
                MessageTreeNode node = (MessageTreeNode)value;
                String text = I18n.t((String)String.valueOf(node.getUserObject()), (Object[])new Object[0]);
                label.setText(text);
                label.setToolTipText(text);
                String iconName = node.getScope().toString().toLowerCase();
                label.setIcon(SwingUtil.createImageIcon((String)(iconName + ".png")));
            }
        }
        return label;
    }
}

