/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.service.referential;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import fr.ifremer.adagio.synchro.config.SynchroConfiguration;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import fr.ifremer.adagio.synchro.dao.SynchroTableDao;
import fr.ifremer.adagio.synchro.dao.SynchroTableDaoImpl;
import fr.ifremer.adagio.synchro.intercept.SynchroInterceptor;
import fr.ifremer.adagio.synchro.meta.SynchroColumnMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroDatabaseMetadata;
import fr.ifremer.adagio.synchro.meta.SynchroMetadataUtils;
import fr.ifremer.adagio.synchro.meta.SynchroTableMetadata;
import fr.ifremer.adagio.synchro.service.SynchroBaseService;
import fr.ifremer.adagio.synchro.service.SynchroContext;
import fr.ifremer.adagio.synchro.service.SynchroResult;
import fr.ifremer.adagio.synchro.service.SynchroServiceUtils;
import fr.ifremer.adagio.synchro.service.referential.ReferentialSynchroService;
import fr.ifremer.adagio.synchro.type.ProgressionModel;
import java.io.Closeable;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.dialect.Dialect;
import org.nuiton.i18n.I18n;
import org.nuiton.util.TimeLog;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.jdbc.datasource.DataSourceUtils;
import org.springframework.stereotype.Service;

@Service(value="referentialSynchroService")
@Lazy
public class ReferentialSynchroServiceImpl
extends SynchroBaseService
implements ReferentialSynchroService {
    private static final Log log = LogFactory.getLog(ReferentialSynchroServiceImpl.class);
    private static final TimeLog TIME = new TimeLog(ReferentialSynchroServiceImpl.class);

    @Autowired
    public ReferentialSynchroServiceImpl(DataSource dataSource, SynchroConfiguration config) {
        super(dataSource, config);
    }

    public ReferentialSynchroServiceImpl() {
    }

    @Override
    public SynchroContext createSynchroContext(File sourceDbDirectory) {
        String dbName = this.config.getDbName();
        Properties targetConnectionProperties = this.config.getConnectionProperties();
        Properties sourceConnectionProperties = new Properties(targetConnectionProperties);
        sourceConnectionProperties.setProperty("hibernate.connection.url", DaoUtils.getJdbcUrl(sourceDbDirectory, dbName));
        Set<String> tableToIncludes = this.config.getImportReferentialTablesIncludes();
        SynchroContext context = SynchroContext.newContext(tableToIncludes, sourceConnectionProperties, targetConnectionProperties, new SynchroResult());
        return context;
    }

    @Override
    public SynchroContext createSynchroContext(Properties sourceConnectionProperties) {
        Properties targetConnectionProperties = this.config.getConnectionProperties();
        Set<String> tableToIncludes = this.config.getImportReferentialTablesIncludes();
        SynchroContext context = SynchroContext.newContext(tableToIncludes, sourceConnectionProperties, targetConnectionProperties, new SynchroResult());
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(SynchroContext synchroContext) {
        Preconditions.checkNotNull((Object)synchroContext);
        Properties sourceConnectionProperties = synchroContext.getSourceConnectionProperties();
        Preconditions.checkNotNull((Object)sourceConnectionProperties);
        Properties targetConnectionProperties = synchroContext.getTargetConnectionProperties();
        Preconditions.checkNotNull((Object)targetConnectionProperties);
        Set<String> tableNames = synchroContext.getTableNames();
        Predicate<String> tableFilter = synchroContext.getTableFilter();
        if (CollectionUtils.isEmpty(tableNames) && tableFilter == null) {
            log.info((Object)I18n.t((String)"adagio.persistence.synchronizeReferential.prepare.noTableFilter", (Object[])new Object[0]));
        }
        SynchroResult result = synchroContext.getResult();
        Preconditions.checkNotNull((Object)result);
        result.setLocalUrl(DaoUtils.getUrl(targetConnectionProperties));
        result.setRemoteUrl(DaoUtils.getUrl(sourceConnectionProperties));
        Connection targetConnection = null;
        Connection sourceConnection = null;
        try {
            ProgressionModel progressionModel = result.getProgressionModel();
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeReferential.prepare.step1", (Object[])new Object[0]));
            targetConnection = this.createConnection(targetConnectionProperties);
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeReferential.prepare.step2", (Object[])new Object[0]));
            sourceConnection = this.createConnection(sourceConnectionProperties);
            SynchroDatabaseMetadata targetMeta = SynchroDatabaseMetadata.loadDatabaseMetadata(targetConnection, DaoUtils.getDialect(targetConnectionProperties), DaoUtils.getConfiguration(targetConnectionProperties), synchroContext, tableNames, tableFilter, null, false);
            SynchroDatabaseMetadata sourceMeta = SynchroDatabaseMetadata.loadDatabaseMetadata(sourceConnection, DaoUtils.getDialect(sourceConnectionProperties), DaoUtils.getConfiguration(sourceConnectionProperties), synchroContext, tableNames, tableFilter, null, false);
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeReferential.prepare.step3", (Object[])new Object[0]));
            SynchroServiceUtils.checkSchemas(sourceMeta, targetMeta, true, true, result);
            if (result.isSuccess()) {
                for (String tableName : targetMeta.getLoadedTableNames()) {
                    long t0 = TimeLog.getTime();
                    progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeReferential.prepare.step4", (Object[])new Object[]{tableName}));
                    SynchroTableMetadata sourceTable = sourceMeta.getTable(tableName);
                    SynchroTableMetadata targetTable = targetMeta.getTable(tableName);
                    this.prepareTable(sourceTable, targetTable, synchroContext, targetConnection, sourceConnection, result);
                    TIME.log(t0, "prepare table " + tableName);
                }
                long totalRows = result.getTotalRows();
                if (log.isInfoEnabled()) {
                    log.info((Object)("Total rows to update: " + totalRows));
                }
                targetConnection.rollback();
            }
            this.closeSilently(sourceConnection);
            this.closeSilently(targetConnection);
        }
        catch (SQLException e) {
            try {
                if (targetConnection != null) {
                    targetConnection.rollback();
                }
            }
            catch (SQLException e1) {
                // empty catch block
            }
            result.setError(e);
        }
        finally {
            this.closeSilently(sourceConnection);
            this.closeSilently(targetConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchronize(SynchroContext synchroContext) {
        Preconditions.checkNotNull((Object)synchroContext);
        Properties sourceConnectionProperties = synchroContext.getSourceConnectionProperties();
        Preconditions.checkNotNull((Object)sourceConnectionProperties);
        Properties targetConnectionProperties = synchroContext.getTargetConnectionProperties();
        Preconditions.checkNotNull((Object)targetConnectionProperties);
        Set<String> tableNames = synchroContext.getTableNames();
        Predicate<String> tableFilter = synchroContext.getTableFilter();
        SynchroResult result = synchroContext.getResult();
        Preconditions.checkNotNull((Object)result);
        Connection targetConnection = null;
        Connection sourceConnection = null;
        try {
            targetConnection = this.createConnection(targetConnectionProperties);
            sourceConnection = this.createConnection(sourceConnectionProperties);
            Predicate<SynchroColumnMetadata> columnFilter = null;
            if (!result.getMissingOptionalColumnNameMaps().isEmpty()) {
                columnFilter = SynchroMetadataUtils.newExcludeColumnPredicate(result.getMissingOptionalColumnNameMaps());
            }
            Dialect targetDialect = DaoUtils.getDialect(targetConnectionProperties);
            SynchroDatabaseMetadata dbMetas = SynchroDatabaseMetadata.loadDatabaseMetadata(targetConnection, DaoUtils.getDialect(targetConnectionProperties), DaoUtils.getConfiguration(targetConnectionProperties), synchroContext, tableNames, tableFilter, columnFilter, false);
            ProgressionModel progressionModel = result.getProgressionModel();
            progressionModel.setTotal(result.getTotalRows());
            this.prepareSynch(targetConnection);
            try {
                for (String tableName : dbMetas.getLoadedTableNames()) {
                    long countToUpdate;
                    long t0 = TimeLog.getTime();
                    progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeReferential.synchronize.step1", (Object[])new Object[]{tableName}));
                    SynchroTableMetadata table = dbMetas.getTable(tableName);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Synchronize table: " + tableName));
                    }
                    if ((countToUpdate = (long)result.getNbRows(tableName)) > 0L) {
                        this.synchronizeTable(table, targetConnection, sourceConnection, result);
                    }
                    TIME.log(t0, "synchronize table " + tableName);
                }
                if (log.isInfoEnabled()) {
                    long totalInserts = result.getTotalInserts();
                    long totalUpdates = result.getTotalUpdates();
                    log.info((Object)("Total rows to treat: " + result.getTotalRows()));
                    log.info((Object)("Total rows inserted: " + totalInserts));
                    log.info((Object)("Total rows  updated: " + totalUpdates));
                    log.info((Object)("Total rows  treated: " + (totalInserts + totalUpdates)));
                }
            }
            finally {
                this.releaseSynch(targetConnection);
            }
            progressionModel.setMessage(I18n.t((String)"adagio.persistence.synchronizeReferential.synchronize.step2", (Object[])new Object[0]));
            targetConnection.commit();
            this.closeSilently(sourceConnection);
            this.closeSilently(targetConnection);
        }
        catch (SQLException e) {
            try {
                try {
                    if (targetConnection != null) {
                        targetConnection.rollback();
                    }
                }
                catch (SQLException e1) {
                    // empty catch block
                }
                result.setError(e);
                this.closeSilently(sourceConnection);
                this.closeSilently(targetConnection);
            }
            catch (Throwable throwable) {
                this.closeSilently(sourceConnection);
                this.closeSilently(targetConnection);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareTable(SynchroTableMetadata sourceTable, SynchroTableMetadata targetTable, SynchroContext context, Connection targetConnection, Connection sourceConnection, SynchroResult result) throws SQLException {
        String tableName = sourceTable.getName();
        String tablePrefix = sourceTable.getTableLogPrefix();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Prepare table: " + tableName));
        }
        SynchroTableDaoImpl targetDao = new SynchroTableDaoImpl(targetConnection, targetTable, false);
        SynchroTableDaoImpl sourceDao = new SynchroTableDaoImpl(sourceConnection, sourceTable, false);
        try {
            long targetCount = targetDao.count();
            Timestamp updateDate = null;
            if (targetCount < 50000L && (updateDate = targetDao.getLastUpdateDate()) != null) {
                updateDate = new Timestamp(DateUtils.setMilliseconds((Date)updateDate, (int)0).getTime());
                updateDate = new Timestamp(DateUtils.addSeconds((Date)updateDate, (int)1).getTime());
            }
            long countToUpdate = sourceDao.countDataToUpdate(updateDate);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("%s nb rows to update: %s", tablePrefix, countToUpdate));
            }
            result.setUpdateDate(tableName, updateDate);
            result.addRows(tableName, (int)countToUpdate);
        }
        finally {
            IOUtils.closeQuietly((Closeable)targetDao);
            IOUtils.closeQuietly((Closeable)sourceDao);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeTable(SynchroTableMetadata table, Connection targetConnection, Connection sourceConnection, SynchroResult result) throws SQLException {
        String tableName = table.getName();
        result.getProgressionModel().setMessage(I18n.t((String)"adagio.persistence.synchronizeReferential.synchronizeTable", (Object[])new Object[]{tableName}));
        SynchroTableDaoImpl sourceDao = new SynchroTableDaoImpl(sourceConnection, table, false);
        SynchroTableDaoImpl targetDao = new SynchroTableDaoImpl(targetConnection, table, true);
        Timestamp updateDate = result.getUpdateDate(tableName);
        long count = targetDao.count();
        boolean bigTable = count > 50000L;
        ResultSet dataToUpdate = sourceDao.getDataToUpdate(bigTable ? null : updateDate);
        try {
            if (bigTable) {
                this.updateBigTable(targetDao, sourceDao, dataToUpdate, result);
            } else {
                this.updateTable(targetDao, dataToUpdate, result);
            }
            dataToUpdate.close();
        }
        finally {
            IOUtils.closeQuietly((Closeable)targetDao);
            IOUtils.closeQuietly((Closeable)sourceDao);
            DaoUtils.closeSilently(dataToUpdate);
        }
    }

    protected void updateTable(SynchroTableDao targetDao, ResultSet incomingData, SynchroResult result) throws SQLException {
        SynchroTableMetadata table = targetDao.getTable();
        String tableName = table.getName();
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        Set<String> existingIds = targetDao.getExistingPrimaryKeys();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " existing rows: " + existingIds.size()));
        }
        result.addTableName(tableName);
        int countR = 0;
        while (incomingData.next()) {
            List<Object> pk = table.getPk(incomingData);
            String pkStr = table.toPkStr(pk);
            boolean doUpdate = existingIds.contains(pkStr);
            if (doUpdate) {
                targetDao.executeUpdate(pk, incomingData);
            } else {
                targetDao.executeInsert(incomingData);
            }
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        targetDao.flush();
        int insertCount = targetDao.getInsertCount();
        int updateCount = targetDao.getUpdateCount();
        result.addInserts(tableName, insertCount);
        result.addUpdates(tableName, updateCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s, updates: %s)", tablePrefix, countR, insertCount, updateCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, result.getNbInserts(tableName)));
            log.debug((Object)String.format("%s UPDATE count: %s", tablePrefix, result.getNbUpdates(tableName)));
        }
        result.getProgressionModel().increments(countR % 1000);
    }

    protected void updateBigTable(SynchroTableDao targetDao, SynchroTableDao sourceDao, ResultSet incomingData, SynchroResult result) throws SQLException {
        SynchroTableMetadata table = targetDao.getTable();
        String tableName = targetDao.getTable().getName();
        result.addTableName(tableName);
        String tablePrefix = table.getTableLogPrefix() + " - " + result.getNbRows(tableName);
        Set<String> existingIds = targetDao.getExistingPrimaryKeys();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " target existing rows: " + existingIds.size()));
        }
        Set<String> sourceExistingIds = sourceDao.getExistingPrimaryKeys();
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " source existing rows: " + sourceExistingIds.size()));
        }
        existingIds.removeAll(sourceExistingIds);
        if (log.isDebugEnabled()) {
            log.debug((Object)(tablePrefix + " target existing rows not in source: " + existingIds.size()));
        }
        if (log.isTraceEnabled()) {
            for (String existingId : existingIds) {
                log.trace((Object)("- " + existingId));
            }
        }
        Map<Object, Object> extraRows = Maps.newLinkedHashMap();
        for (String pkStr : existingIds) {
            List<Object> pk = table.fromPkStr(pkStr);
            Object[] extraRow = targetDao.findByPk(pk);
            extraRows.put(pk, extraRow);
        }
        List<SynchroInterceptor> interceptors = table.getInterceptors();
        for (SynchroInterceptor interceptor : interceptors) {
            extraRows = interceptor.transformExtraLocalData(targetDao, sourceDao, (Map<List<Object>, Object[]>)extraRows);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)(tablePrefix + " target data existingIds not in source (after apply task): " + extraRows.size()));
        }
        targetDao.deleteAll();
        int countR = 0;
        while (incomingData.next()) {
            targetDao.executeInsert(incomingData);
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        for (Map.Entry entry : extraRows.entrySet()) {
            Object[] row = (Object[])entry.getValue();
            targetDao.executeInsert(row);
            this.reportProgress(result, targetDao, ++countR, tablePrefix);
        }
        targetDao.flush();
        int insertCount = targetDao.getInsertCount();
        result.addInserts(tableName, insertCount);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("%s done: %s (inserts: %s)", tablePrefix, countR, insertCount));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("%s INSERT count: %s", tablePrefix, result.getNbInserts(tableName)));
        }
        result.getProgressionModel().increments(countR % 1000);
    }

    @Override
    protected void reportProgress(SynchroResult result, SynchroTableDao dao, int countR, String tablePrefix) {
        if (countR % 1000 == 0) {
            result.getProgressionModel().increments(1000);
        }
        if (countR % 10000 == 0 && log.isInfoEnabled()) {
            log.info((Object)String.format("%s Done: %s (inserts: %s, updates: %s)", tablePrefix, countR, dao.getInsertCount(), dao.getUpdateCount()));
        }
    }

    protected Connection createConnection(Properties connectionProperties) throws SQLException {
        return this.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    protected Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)jdbcUrl));
        if (jdbcUrl.equals(this.config.getJdbcURL()) && this.dataSource != null) {
            return DataSourceUtils.getConnection((DataSource)this.dataSource);
        }
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    protected void closeSilently(Connection connection) {
        String jdbcUrl = null;
        try {
            jdbcUrl = connection.getMetaData().getURL();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (jdbcUrl != null && jdbcUrl.equals(this.config.getJdbcURL()) && this.dataSource != null) {
            DataSourceUtils.releaseConnection((Connection)connection, (DataSource)this.dataSource);
        } else {
            DaoUtils.closeSilently(connection);
        }
    }

    protected void prepareSynch(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SET REFERENTIAL_INTEGRITY FALSE;");
        statement.executeUpdate();
    }

    protected void releaseSynch(Connection connection) throws SQLException {
        PreparedStatement statement = connection.prepareStatement("SET REFERENTIAL_INTEGRITY TRUE;");
        statement.executeUpdate();
    }
}

