/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.config;

import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableSet;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import fr.ifremer.adagio.synchro.config.SynchroConfigurationAction;
import fr.ifremer.adagio.synchro.config.SynchroConfigurationOption;
import fr.ifremer.adagio.synchro.dao.DaoUtils;
import java.io.File;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfig;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ArgumentsParserException;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.i18n.I18n;

public class SynchroConfiguration {
    private static final Log log = LogFactory.getLog(SynchroConfiguration.class);
    protected final ApplicationConfig applicationConfig;
    private static SynchroConfiguration instance;
    protected final String[] optionKeyToNotSave;
    protected File configFile;

    public static SynchroConfiguration getInstance() {
        return instance;
    }

    public static void setInstance(SynchroConfiguration instance) {
        SynchroConfiguration.instance = instance;
    }

    public SynchroConfiguration(ApplicationConfig applicationConfig) {
        this.applicationConfig = applicationConfig;
        this.optionKeyToNotSave = null;
    }

    public SynchroConfiguration(String file, String ... args) {
        this.applicationConfig = new ApplicationConfig();
        this.applicationConfig.setEncoding(Charsets.UTF_8.name());
        this.applicationConfig.setConfigFileName(file);
        Set providers = ApplicationConfigHelper.getProviders(null, null, null, (boolean)true);
        ApplicationConfigHelper.loadAllDefaultOption((ApplicationConfig)this.applicationConfig, (Set)providers);
        for (ApplicationConfigProvider provider : providers) {
            this.applicationConfig.loadActions(provider.getActions());
        }
        this.applicationConfig.loadActions((ConfigActionDef[])SynchroConfigurationAction.values());
        this.applicationConfig.addAlias("-u", new String[]{"--option", SynchroConfigurationOption.JDBC_USERNAME.getKey()});
        this.applicationConfig.addAlias("--user", new String[]{"--option", SynchroConfigurationOption.JDBC_USERNAME.getKey()});
        this.applicationConfig.addAlias("-p", new String[]{"--option", SynchroConfigurationOption.JDBC_PASSWORD.getKey()});
        this.applicationConfig.addAlias("--password", new String[]{"--option", SynchroConfigurationOption.JDBC_PASSWORD.getKey()});
        this.applicationConfig.addAlias("-db", new String[]{"--option", SynchroConfigurationOption.JDBC_URL.getKey()});
        this.applicationConfig.addAlias("--database", new String[]{"--option", SynchroConfigurationOption.JDBC_URL.getKey()});
        this.applicationConfig.addAlias("-iu", new String[]{"--option", SynchroConfigurationOption.IMPORT_JDBC_USERNAME.getKey()});
        this.applicationConfig.addAlias("--import-user", new String[]{"--option", SynchroConfigurationOption.IMPORT_JDBC_USERNAME.getKey()});
        this.applicationConfig.addAlias("-ip", new String[]{"--option", SynchroConfigurationOption.IMPORT_JDBC_PASSWORD.getKey()});
        this.applicationConfig.addAlias("--import-password", new String[]{"--option", SynchroConfigurationOption.IMPORT_JDBC_PASSWORD.getKey()});
        this.applicationConfig.addAlias("-idb", new String[]{"--option", SynchroConfigurationOption.IMPORT_JDBC_URL.getKey()});
        this.applicationConfig.addAlias("--import-database", new String[]{"--option", SynchroConfigurationOption.IMPORT_JDBC_URL.getKey()});
        this.applicationConfig.addAlias("--port", new String[]{"--option", SynchroConfigurationOption.SERVER_PORT.getKey()});
        this.applicationConfig.addAlias("--keystore", new String[]{"--option", SynchroConfigurationOption.SERVER_SSL_KEYSTORE.getKey()});
        Set optionToSkip = ApplicationConfigHelper.getTransientOptionKeys((Set)providers);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Option that won't be saved: " + optionToSkip));
        }
        this.optionKeyToNotSave = optionToSkip.toArray(new String[optionToSkip.size()]);
        try {
            this.applicationConfig.parse(args);
        }
        catch (ArgumentsParserException e) {
            throw new SynchroTechnicalException(I18n.t((String)"adagio.config.parse.error", (Object[])new Object[0]), e);
        }
        File allegroBasedir = this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.BASEDIR.getKey());
        if (allegroBasedir == null) {
            allegroBasedir = new File("");
        }
        if (!allegroBasedir.isAbsolute()) {
            allegroBasedir = new File(allegroBasedir.getAbsolutePath());
        }
        if (allegroBasedir.getName().equals("..")) {
            allegroBasedir = allegroBasedir.getParentFile().getParentFile();
        }
        if (allegroBasedir.getName().equals(".")) {
            allegroBasedir = allegroBasedir.getParentFile();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Application basedir: " + allegroBasedir));
        }
        this.applicationConfig.setOption(SynchroConfigurationOption.BASEDIR.getKey(), allegroBasedir.getAbsolutePath());
    }

    public File getConfigFile() {
        if (this.configFile == null) {
            File dir = this.getBasedir();
            if (dir == null || !dir.exists()) {
                dir = new File(this.applicationConfig.getUserConfigDirectory());
            }
            this.configFile = new File(dir, this.applicationConfig.getConfigFileName());
        }
        return this.configFile;
    }

    public File getBasedir() {
        File result = this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.BASEDIR.getKey());
        return result;
    }

    public File getDataDirectory() {
        File result = this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.DATA_DIRECTORY.getKey());
        return result;
    }

    public ApplicationConfig getApplicationConfig() {
        return this.applicationConfig;
    }

    public File getDbDirectory() {
        return this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.DB_DIRECTORY.getKey());
    }

    public void setDbDirectory(File dbDirectory) {
        this.applicationConfig.setOption(SynchroConfigurationOption.DB_DIRECTORY.getKey(), dbDirectory.getPath());
    }

    public File getDbAttachmentDirectory() {
        return this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.DB_ATTACHMENT_DIRECTORY.getKey());
    }

    public File getCacheDirectory() {
        return this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.DB_CACHE_DIRECTORY.getKey());
    }

    public File getDbBackupDirectory() {
        return this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.DB_BACKUP_DIRECTORY.getKey());
    }

    public String getHibernateDialect() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.HIBERNATE_DIALECT.getKey());
    }

    public String getJdbcDriver() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.JDBC_DRIVER.getKey());
    }

    public String getJdbcURL() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.JDBC_URL.getKey());
    }

    public String getDbName() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.DB_NAME.getKey());
    }

    public String getDbValidationQuery() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.DB_VALIDATION_QUERY.getKey());
    }

    public String getJdbcUsername() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.JDBC_USERNAME.getKey());
    }

    public String getJdbcPassword() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.JDBC_PASSWORD.getKey());
    }

    public File getI18nDirectory() {
        return this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.I18N_DIRECTORY.getKey());
    }

    public Locale getI18nLocale() {
        return this.applicationConfig.getOptionAsLocale(SynchroConfigurationOption.I18N_LOCALE.getKey());
    }

    public void setI18nLocale(Locale locale) {
        this.applicationConfig.setOption(SynchroConfigurationOption.I18N_LOCALE.getKey(), locale.toString());
    }

    public String getImportJdbcURL() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_JDBC_URL.getKey());
    }

    public String getImportJdbcUsername() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_JDBC_USERNAME.getKey());
    }

    public String getImportJdbcPassword() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_JDBC_PASSWORD.getKey());
    }

    public String getImportJdbcSchema() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_JDBC_SCHEMA.getKey());
    }

    public String getImportJdbcCatalog() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_JDBC_CATALOG.getKey());
    }

    public String getImportJdbcDriver() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_JDBC_DRIVER.getKey());
    }

    public int getImportJdbcBatchSize() {
        int importJdbcBatchSize = this.applicationConfig.getOptionAsInt(SynchroConfigurationOption.IMPORT_JDBC_BATCH_SIZE.getKey());
        if (importJdbcBatchSize == 0) {
            return 1000;
        }
        return importJdbcBatchSize;
    }

    public String getImportHibernateDialect() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_HIBERNATE_DIALECT.getKey());
    }

    public String getSynchronizationStatusSynchronized() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.SYNCHRONIZATION_STATUS_SYNCHRONIZED.getKey());
    }

    public String getSynchronizationStatusReadyToSynchronize() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.SYNCHRONIZATION_STATUS_READY_TO_SYNCHRONIZE.getKey());
    }

    public String getSynchronizationStatusDeleted() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.SYNCHRONIZATION_STATUS_DELETED.getKey());
    }

    public String getSynchronizationStatusDirty() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.SYNCHRONIZATION_STATUS_DIRTY.getKey());
    }

    public int getServerPort() {
        return this.applicationConfig.getOptionAsInt(SynchroConfigurationOption.SERVER_PORT.getKey());
    }

    public File getServerSslKeyStore() {
        return this.applicationConfig.getOptionAsFile(SynchroConfigurationOption.SERVER_SSL_KEYSTORE.getKey());
    }

    public Properties getConnectionProperties() {
        return DaoUtils.getConnectionProperties(this.getJdbcURL(), this.getJdbcUsername(), this.getJdbcPassword(), null, this.getHibernateDialect(), this.getJdbcDriver());
    }

    public Properties getImportConnectionProperties() {
        return DaoUtils.getConnectionProperties(this.getImportJdbcURL(), this.getImportJdbcUsername(), this.getImportJdbcPassword(), this.getImportJdbcSchema(), this.getImportHibernateDialect(), this.getImportJdbcDriver());
    }

    public String getImportVesselProgramCode() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.DEFAULT_VESSEL_PROGRAM_CODE.getKey());
    }

    public String getImportTranscribingItemTypeIds() {
        return this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_TRANSCRIBING_ITEM_TYPE_IDS.getKey());
    }

    public Set<String> getImportDataTablesIncludes() {
        String dataTablesStr = this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_TABLES_DATA_INCLUDES.getKey());
        ImmutableSet result = null;
        if (StringUtils.isNotBlank((CharSequence)dataTablesStr)) {
            result = ImmutableSet.builder().add((Object[])dataTablesStr.split("\\s*,\\s*")).build();
        }
        return result;
    }

    public Set<String> getImportReferentialTablesIncludes() {
        String referentialTablesStr = this.applicationConfig.getOption(SynchroConfigurationOption.IMPORT_TABLES_REFERENTIAL_INCLUDES.getKey());
        ImmutableSet result = null;
        if (StringUtils.isNotBlank((CharSequence)referentialTablesStr)) {
            result = ImmutableSet.builder().add((Object[])referentialTablesStr.split("\\s*,\\s*")).build();
        }
        return result;
    }
}

