/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.ModuleHandle;

public class ResourceLocatorWrapper {
    private HashMap<URL, byte[]> cache = new HashMap();
    private static final byte[] DUMMY_BYTES = new byte[0];
    protected static Logger logger = Logger.getLogger(ResourceLocatorWrapper.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        HashMap<URL, byte[]> hashMap = this.cache;
        synchronized (hashMap) {
            this.cache.clear();
            this.cache = null;
        }
    }

    public byte[] findResource(ModuleHandle design, String fileName, int fileType, Map appContext) {
        URL url = design.findResource(fileName, fileType, appContext);
        if (url == null) {
            logger.log(Level.WARNING, "Error.ResourceNotAccessible", fileName);
            return DUMMY_BYTES;
        }
        return this.findResource(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] findResource(URL url) {
        if (url == null) {
            return DUMMY_BYTES;
        }
        HashMap<URL, byte[]> hashMap = this.cache;
        synchronized (hashMap) {
            if (this.cache == null) {
                return DUMMY_BYTES;
            }
            byte[] inBytes = this.cache.get(url);
            if (inBytes == null) {
                try {
                    InputStream in = url.openStream();
                    inBytes = this.getByteArrayFromInputStream(in);
                    in.close();
                    this.cache.put(url, inBytes);
                }
                catch (IOException iOException) {
                    logger.log(Level.WARNING, "Error.ResourceNotAccessible", url.toExternalForm());
                    this.cache.put(url, DUMMY_BYTES);
                    return DUMMY_BYTES;
                }
            }
            return inBytes;
        }
    }

    private byte[] getByteArrayFromInputStream(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int size = in.read(buffer);
        while (size != -1) {
            out.write(buffer, 0, size);
            size = in.read(buffer);
        }
        buffer = out.toByteArray();
        out.close();
        return buffer;
    }
}

