/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.BatchContainer;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.AbstractTuttiBatchTableUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.MarineLitterBatchUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.marinelitter.create.CreateMarineLitterBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellEditor;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentCellRenderer;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellEditor;
import fr.ifremer.tutti.ui.swing.util.comment.CommentCellRenderer;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.jaxx.application.listener.PropagatePropertyChangeListener;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.table.ColumnIdentifier;
import org.nuiton.validator.NuitonValidatorResult;

public class MarineLitterBatchUIHandler
extends AbstractTuttiBatchTableUIHandler<MarineLitterBatchRowModel, MarineLitterBatchUIModel, MarineLitterBatchTableModel, MarineLitterBatchUI> {
    private static final Log log = LogFactory.getLog(MarineLitterBatchUIHandler.class);
    protected WeightUnit weightUnit;

    public MarineLitterBatchUIHandler() {
        super("marineLitterCategory", "marineLitterSizeCategory", "weight", "number", "comment");
    }

    @Override
    protected ColumnIdentifier<MarineLitterBatchRowModel> getCommentIdentifier() {
        return MarineLitterBatchTableModel.COMMENT;
    }

    @Override
    protected ColumnIdentifier<MarineLitterBatchRowModel> getAttachementIdentifier() {
        return MarineLitterBatchTableModel.ATTACHMENT;
    }

    @Override
    public void selectFishingOperation(FishingOperation bean) {
        ArrayList rows;
        boolean empty = bean == null;
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        if (empty) {
            rows = null;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Get marineLitter batch for fishingOperation: " + bean.getId()));
            }
            rows = Lists.newArrayList();
            if (!TuttiEntities.isNew(bean)) {
                BatchContainer batchContainer = this.getPersistenceService().getRootMarineLitterBatch(bean.getId());
                for (MarineLitterBatch aBatch : batchContainer.getChildren()) {
                    MarineLitterBatchRowModel entry = this.loadBatch(aBatch);
                    rows.add(entry);
                }
            }
        }
        model.setRows(rows);
    }

    public MarineLitterBatchTableModel getTableModel() {
        return (MarineLitterBatchTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((MarineLitterBatchUI)this.ui).getTable();
    }

    @Override
    protected boolean isRowValid(MarineLitterBatchRowModel row) {
        MarineLitterBatch batch = (MarineLitterBatch)row.toBean();
        NuitonValidatorResult validator = this.getValidationService().validateMarineLitterBatch(batch);
        boolean result = !validator.hasErrorMessagess();
        return result;
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<MarineLitterBatchRowModel> rowMonitor, MarineLitterBatchRowModel row) {
        if (row != null && row.isValid() && rowMonitor.wasModified()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Row " + row + " was modified, will save it"));
            }
            String title = this.buildReminderLabelTitle(this.decorate(row.getMarineLitterCategory()) + " - " + this.decorate(row.getMarineLitterSizeCategory()), null, "Sauvegarde du lot Macro d\u00e9chet : ", "Ligne :" + (this.getTableModel().getRowIndex(row) + 1));
            this.showInformationMessage(title);
            rowMonitor.setBean(null);
            this.saveRow(row);
            rowMonitor.setBean(row);
            rowMonitor.clearModified();
        }
    }

    @Override
    protected void onModelRowsChanged(List<MarineLitterBatchRowModel> rows) {
        super.onModelRowsChanged(rows);
        for (MarineLitterBatchRowModel row : rows) {
            this.addToMarineLitterCategoriesUsed(row);
        }
    }

    public SwingValidator<MarineLitterBatchUIModel> getValidator() {
        return ((MarineLitterBatchUI)this.ui).getValidator();
    }

    public void beforeInit(MarineLitterBatchUI ui) {
        super.beforeInit((ApplicationUI)ui);
        if (log.isDebugEnabled()) {
            log.debug((Object)("beforeInit: " + ui));
        }
        this.weightUnit = this.getConfig().getMarineLitterWeightUnit();
        EditCatchesUIModel catchesUIModel = ui.getContextValue(EditCatchesUIModel.class);
        MarineLitterBatchUIModel model = new MarineLitterBatchUIModel(catchesUIModel);
        ui.setContextValue(model);
        PropagatePropertyChangeListener.listenAndPropagate((AbstractBean)catchesUIModel, (PropagatePropertyChangeListener.PropagatePropertyChange)model, (String)"marineLitterTotalWeight", (String)"marineLitterTotalWeight");
    }

    public void afterInit(MarineLitterBatchUI ui) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("afterInit: " + ui));
        }
        this.initUI(ui);
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(CaracteristicQualitativeValue.class, null), MarineLitterBatchTableModel.MACRO_WASTE_CATEGORY);
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(CaracteristicQualitativeValue.class, null), MarineLitterBatchTableModel.MACRO_WASTE_SIZE_CATEGORY);
        this.addIntegerColumnToModel((TableColumnModel)columnModel, MarineLitterBatchTableModel.NUMBER, "\\d{0,3}", (JTable)table);
        this.addFloatColumnToModel((TableColumnModel)columnModel, MarineLitterBatchTableModel.WEIGHT, this.weightUnit, (JTable)table);
        this.addColumnToModel((TableColumnModel)columnModel, CommentCellEditor.newEditor(ui), CommentCellRenderer.newRender(), MarineLitterBatchTableModel.COMMENT);
        this.addColumnToModel((TableColumnModel)columnModel, AttachmentCellEditor.newEditor(ui), AttachmentCellRenderer.newRender(this.getDecorator(Attachment.class, null)), MarineLitterBatchTableModel.ATTACHMENT);
        MarineLitterBatchTableModel tableModel = new MarineLitterBatchTableModel(this.weightUnit, (TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initBatchTable(table, (TableColumnModelExt)columnModel, tableModel);
    }

    protected JComponent getComponentToFocus() {
        return ((MarineLitterBatchUI)this.getUI()).getTable();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        boolean enableRemove = false;
        if (rowIndex != -1) {
            enableRemove = true;
        }
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        model.setRemoveBatchEnabled(enableRemove);
    }

    public void createBatch() {
        EditCatchesUI parent = (EditCatchesUI)this.getParentContainer(EditCatchesUI.class);
        CreateMarineLitterBatchUI createBatchEditor = parent.getMarineLitterTabCreateBatch();
        createBatchEditor.getHandler().openUI((MarineLitterBatchUIModel)this.getModel());
        parent.getHandler().setMarineLitterSelectedCard("createBatch");
    }

    public void addBatch(CreateMarineLitterBatchUIModel model) {
        if (model.isValid()) {
            MarineLitterBatchTableModel tableModel = this.getTableModel();
            MarineLitterBatchRowModel newRow = tableModel.createNewRow();
            newRow.setMarineLitterCategory(model.getMarineLitterCategory());
            newRow.setMarineLitterSizeCategory(model.getMarineLitterSizeCategory());
            newRow.setNumber(model.getNumber());
            newRow.setWeight(model.getWeight());
            this.recomputeRowValidState(newRow);
            this.saveRow(newRow);
            tableModel.addNewRow(newRow);
            TuttiUIUtil.selectFirstCellOnLastRow((JXTable)this.getTable());
            this.addToMarineLitterCategoriesUsed(newRow);
        }
    }

    protected MarineLitterBatchRowModel loadBatch(MarineLitterBatch aBatch) {
        MarineLitterBatchRowModel newRow = new MarineLitterBatchRowModel(this.weightUnit, aBatch);
        List attachments = this.getPersistenceService().getAllAttachments(newRow.getObjectType(), newRow.getObjectId());
        newRow.addAllAttachment(attachments);
        return newRow;
    }

    protected void saveRow(MarineLitterBatchRowModel row) {
        MarineLitterBatch entityToSave = row.toEntity();
        FishingOperation fishingOperation = ((MarineLitterBatchUIModel)this.getModel()).getFishingOperation();
        entityToSave.setFishingOperation(fishingOperation);
        if (log.isInfoEnabled()) {
            log.info((Object)("Selected fishingOperation: " + fishingOperation.getId()));
        }
        if (TuttiEntities.isNew(entityToSave)) {
            entityToSave = this.getPersistenceService().createMarineLitterBatch(entityToSave);
            row.setId(entityToSave.getId());
        } else {
            this.getPersistenceService().saveMarineLitterBatch(entityToSave);
        }
        ((MarineLitterBatchUIModel)this.getModel()).fireBatchUpdated(row);
    }

    public void removeFromMarineLitterCategoriesUsed(MarineLitterBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getMarineLitterCategory());
        Preconditions.checkNotNull((Object)row.getMarineLitterSizeCategory());
        if (log.isInfoEnabled()) {
            log.info((Object)("Remove from speciesUsed: " + this.decorate(row.getMarineLitterSizeCategory()) + " - " + this.decorate(row.getMarineLitterCategory())));
        }
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        model.getMarineLitterCategoriesUsed().remove((Object)row.getMarineLitterSizeCategory(), (Object)row.getMarineLitterCategory());
    }

    protected void addToMarineLitterCategoriesUsed(MarineLitterBatchRowModel row) {
        Preconditions.checkNotNull((Object)row);
        Preconditions.checkNotNull((Object)row.getMarineLitterCategory());
        Preconditions.checkNotNull((Object)row.getMarineLitterSizeCategory());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Add to marineLitterCategoriesUsed: " + this.decorate(row.getMarineLitterSizeCategory()) + " - " + this.decorate(row.getMarineLitterCategory())));
        }
        MarineLitterBatchUIModel model = (MarineLitterBatchUIModel)this.getModel();
        model.getMarineLitterCategoriesUsed().put((Object)row.getMarineLitterSizeCategory(), (Object)row.getMarineLitterCategory());
    }
}

