/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Date;
import liquibase.database.Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.core.DeleteStatement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteGenerator
extends AbstractSqlGenerator<DeleteStatement> {
    @Override
    public boolean supports(DeleteStatement statement, Database database) {
        return !(database instanceof SQLiteDatabase);
    }

    @Override
    public ValidationErrors validate(DeleteStatement deleteStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", deleteStatement.getTableName());
        return validationErrors;
    }

    @Override
    public Sql[] generateSql(DeleteStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuffer sql = new StringBuffer("DELETE FROM " + database.escapeTableName(statement.getSchemaName(), statement.getTableName()));
        if (statement.getWhereClause() != null) {
            String fixedWhereClause = " WHERE " + statement.getWhereClause();
            for (Object param : statement.getWhereParameters()) {
                fixedWhereClause = fixedWhereClause.replaceFirst("\\?", this.convertToString(param, database));
            }
            sql.append(" ").append(fixedWhereClause);
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }

    private String convertToString(Object newValue, Database database) {
        String sqlString = newValue == null ? "NULL" : (newValue instanceof String && database.shouldQuoteValue((String)newValue) ? "'" + newValue + "'" : (newValue instanceof Date ? database.getDateLiteral((Date)newValue) : (newValue instanceof Boolean ? (((Boolean)newValue).booleanValue() ? TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getTrueBooleanValue() : TypeConverterFactory.getInstance().findTypeConverter(database).getBooleanType().getFalseBooleanValue()) : newValue.toString())));
        return sqlString;
    }
}

