/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat;

import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.AccidentalBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.BenthosBatchFrequency;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.MarineLitterBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatContextSupport;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportCruiseContext;
import fr.ifremer.tutti.service.genericformat.GenericFormatImportOperationContext;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.i18n.I18n;

public class GenericformatImportPersitenceHelper {
    private static final Log log = LogFactory.getLog(GenericformatImportPersitenceHelper.class);
    private final GenericFormatImportContext importContext;
    private final PersistenceService persistenceService;
    private final Decorator<Cruise> cruiseDecorator;
    private final Decorator<FishingOperation> fishingOperationDecorator;

    public GenericformatImportPersitenceHelper(GenericFormatImportContext importContext, PersistenceService persistenceService, Decorator<Cruise> cruiseDecorator, Decorator<FishingOperation> fishingOperationDecorator) {
        this.importContext = importContext;
        this.persistenceService = persistenceService;
        this.cruiseDecorator = cruiseDecorator;
        this.fishingOperationDecorator = fishingOperationDecorator;
    }

    public void persistCruise(Cruise cruise) {
        Cruise savedCruise;
        String cruiseStr = this.cruiseDecorator.toString((Object)cruise);
        boolean createCruise = TuttiEntities.isNew((TuttiEntity)cruise);
        if (createCruise) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Create cruise: " + cruiseStr));
            }
            this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.cruise", (Object[])new Object[]{cruiseStr}));
            savedCruise = this.persistenceService.createCruise(cruise);
        } else {
            if (log.isInfoEnabled()) {
                log.info((Object)("Save existing cruise: " + cruiseStr));
            }
            this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.cruise", (Object[])new Object[]{cruiseStr}));
            savedCruise = this.persistenceService.saveCruise(cruise, false, false);
            List<String> fishingOperationIds = this.persistenceService.getAllFishingOperationIds(savedCruise.getId());
            this.importContext.addStepsInProgressionModel(fishingOperationIds.size());
            for (String fishingOperationId : fishingOperationIds) {
                FishingOperation fishingOperation = this.persistenceService.getFishingOperation(fishingOperationId);
                this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.remove.existingCruise.fishingOperation", (Object[])new Object[]{cruiseStr, this.fishingOperationDecorator.toString((Object)fishingOperation)}));
                this.persistenceService.deleteFishingOperation(fishingOperationId);
            }
        }
        this.importContext.addImportedCruise(savedCruise, !createCruise);
    }

    public void persistGearCaracteristics() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                GenericformatImportPersitenceHelper.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.gearCaracteristics", (Object[])new Object[]{cruiseContext.getCruiseLabel()}));
                if (cruiseContext.withGearCaracteristics()) {
                    Set<Gear> gears = cruiseContext.getGearsWithcaracteristics();
                    Cruise cruise = cruiseContext.getCruise();
                    for (Gear gear : gears) {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + gear.getCaracteristics().size() + " gear caracteristics for gear: " + gear.getName() + " for cruise: " + cruiseContext.getCruiseLabel()));
                        }
                        GenericformatImportPersitenceHelper.this.persistenceService.saveGearCaracteristics(gear, cruise);
                    }
                }
            }
        });
    }

    public void persistFishingOperation(GenericFormatImportCruiseContext cruiseContext, FishingOperation fishingOperation, CatchBatch catchBatch) {
        String operationStr = this.fishingOperationDecorator.toString((Object)fishingOperation);
        String cruiseStr = cruiseContext.getCruiseLabel();
        if (log.isInfoEnabled()) {
            log.info((Object)("Persist fishing Operation: " + operationStr + " for cruise: " + cruiseStr));
        }
        this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation", (Object[])new Object[]{cruiseStr, operationStr}));
        FishingOperation createdFishingOperation = this.persistenceService.createFishingOperation(fishingOperation);
        catchBatch.setFishingOperation(createdFishingOperation);
        CatchBatch createdCatchBatch = this.persistenceService.createCatchBatch(catchBatch);
        this.importContext.addImportedFishingOperation(createdFishingOperation, createdCatchBatch);
    }

    public void persistFishingOperationParameters() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext.getFishingOperationContexts()) {
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    GenericformatImportPersitenceHelper.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.parameters", (Object[])new Object[]{cruiseStr, operationStr}));
                    boolean persist = false;
                    FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                    if (fishingOperationContext.withGearFeatures()) {
                        CaracteristicMap gearUseFeatures = fishingOperationContext.getGearUseFeatures();
                        fishingOperation.setGearUseFeatures(gearUseFeatures);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + gearUseFeatures.size() + " gear use features of " + operationStr + " for cruise: " + cruiseStr));
                        }
                        persist = true;
                    }
                    if (fishingOperationContext.withVesselFeatures()) {
                        CaracteristicMap vesselUseFeatures = fishingOperationContext.getVesselUseFeatures();
                        fishingOperation.setVesselUseFeatures(vesselUseFeatures);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + vesselUseFeatures.size() + " vessel use features of " + operationStr + " for cruise: " + cruiseStr));
                        }
                        persist = true;
                    }
                    if (!persist) continue;
                    GenericformatImportPersitenceHelper.this.persistenceService.saveFishingOperation(fishingOperation);
                }
            }
        });
    }

    public void persistSpeciesBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext.getFishingOperationContexts()) {
                    Collection<SpeciesBatch> batches;
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    GenericformatImportPersitenceHelper.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.speciesBatches", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (fishingOperationContext.withSpeciesBatches(true)) {
                        batches = fishingOperationContext.getSpeciesBatches(true);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + batches.size() + " VRAC root species batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                        }
                        this.persistSpeciesBatches(fishingOperationContext, batches, null);
                    }
                    if (!fishingOperationContext.withSpeciesBatches(false)) continue;
                    batches = fishingOperationContext.getSpeciesBatches(false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + batches.size() + " HORS VRAC root species batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    this.persistSpeciesBatches(fishingOperationContext, batches, null);
                }
            }

            protected void persistSpeciesBatches(GenericFormatImportOperationContext fishingOperationContext, Collection<SpeciesBatch> batches, String parentId) {
                for (SpeciesBatch batch : batches) {
                    List<SpeciesBatchFrequency> frequencies = fishingOperationContext.getSpeciesFrequencies(batch);
                    batch.setId((Integer)null);
                    SpeciesBatch createdBatch = GenericformatImportPersitenceHelper.this.persistenceService.createSpeciesBatch(batch, parentId);
                    if (CollectionUtils.isNotEmpty(frequencies)) {
                        String batchId = batch.getId();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + frequencies.size() + " frequency(ies) (species batch: " + batchId + ") of " + fishingOperationContext.getFishingOperationLabel() + " for cruise: " + GenericformatImportPersitenceHelper.this.cruiseDecorator.toString((Object)fishingOperationContext.getFishingOperation().getCruise())));
                        }
                        GenericformatImportPersitenceHelper.this.persistenceService.saveSpeciesBatchFrequency(batchId, frequencies);
                    }
                    if (batch.isChildBatchsEmpty()) continue;
                    this.persistSpeciesBatches(fishingOperationContext, batch.getChildBatchs(), createdBatch.getId());
                }
            }
        });
    }

    public void persistBenthosBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext.getFishingOperationContexts()) {
                    Collection<BenthosBatch> batches;
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    GenericformatImportPersitenceHelper.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.benthosBatches", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (fishingOperationContext.withBenthosBatches(true)) {
                        batches = fishingOperationContext.getBenthosBatches(true);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + batches.size() + " VRAC benthos batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                        }
                        this.persistBenthosBatches(fishingOperationContext, batches, null);
                    }
                    if (!fishingOperationContext.withBenthosBatches(false)) continue;
                    batches = fishingOperationContext.getBenthosBatches(false);
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + batches.size() + " HORS VRAC benthos batch(es) of " + operationStr + " for cruise: " + cruiseContext.getCruiseLabel()));
                    }
                    this.persistBenthosBatches(fishingOperationContext, batches, null);
                }
            }

            protected void persistBenthosBatches(GenericFormatImportOperationContext fishingOperationContext, Collection<BenthosBatch> batches, String parentId) {
                for (BenthosBatch batch : batches) {
                    List<BenthosBatchFrequency> frequencies = fishingOperationContext.getBenthosFrequencies(batch);
                    batch.setId((Integer)null);
                    BenthosBatch createdBatch = GenericformatImportPersitenceHelper.this.persistenceService.createBenthosBatch(batch, parentId);
                    if (CollectionUtils.isNotEmpty(frequencies)) {
                        String batchId = batch.getId();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Persist " + frequencies.size() + " frequency(ies) (benthos batch: " + batchId + ") of " + fishingOperationContext.getFishingOperationLabel() + " for cruise: " + GenericformatImportPersitenceHelper.this.cruiseDecorator.toString((Object)fishingOperationContext.getFishingOperation().getCruise())));
                        }
                        GenericformatImportPersitenceHelper.this.persistenceService.saveBenthosBatchFrequency(batchId, frequencies);
                    }
                    if (batch.isChildBatchsEmpty()) continue;
                    this.persistBenthosBatches(fishingOperationContext, batch.getChildBatchs(), createdBatch.getId());
                }
            }
        });
    }

    public void persistMarineLitterBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext.getFishingOperationContexts()) {
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    GenericformatImportPersitenceHelper.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.marineLitters", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (!fishingOperationContext.withMarineLitterBatches()) continue;
                    Collection<MarineLitterBatch> marineLitterBatches = fishingOperationContext.getMarineLitterBatches();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + marineLitterBatches.size() + " marine litter(s) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    for (MarineLitterBatch marineLitterBatch : marineLitterBatches) {
                        GenericformatImportPersitenceHelper.this.persistenceService.createMarineLitterBatch(marineLitterBatch);
                    }
                }
            }
        });
    }

    public void persistIndividualObservationBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext.getFishingOperationContexts()) {
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    GenericformatImportPersitenceHelper.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.individualObservations", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (!fishingOperationContext.withIndividualObservationBatches()) continue;
                    FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                    String fishingOperationId = fishingOperation.getId();
                    Collection<IndividualObservationBatch> individualObservationBatches = fishingOperationContext.getIndividualObservationBatches();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + individualObservationBatches.size() + " individual observation(s) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    GenericformatImportPersitenceHelper.this.persistenceService.createIndividualObservationBatches(fishingOperationId, individualObservationBatches);
                }
            }
        });
    }

    public void persistAccidentalBatches() {
        this.importContext.doActionOnCruiseContexts(new GenericFormatContextSupport.CruiseContextAction(){

            @Override
            public void onCruise(GenericFormatImportCruiseContext cruiseContext, ProgressionModel progressionModel) {
                for (GenericFormatImportOperationContext fishingOperationContext : cruiseContext.getFishingOperationContexts()) {
                    String cruiseStr = cruiseContext.getCruiseLabel();
                    String operationStr = fishingOperationContext.getFishingOperationLabel();
                    GenericformatImportPersitenceHelper.this.importContext.increments(I18n.t((String)"tutti.service.genericFormat.persist.operation.accidentalBatches", (Object[])new Object[]{cruiseStr, operationStr}));
                    if (!fishingOperationContext.withAccidentalBatches()) continue;
                    FishingOperation fishingOperation = fishingOperationContext.getFishingOperation();
                    String fishingOperationId = fishingOperation.getId();
                    Collection<AccidentalBatch> accidentalBatches = fishingOperationContext.getAccidentalBatches();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Persist " + accidentalBatches.size() + " accidental batch(es) of " + operationStr + " for cruise: " + cruiseStr));
                    }
                    GenericformatImportPersitenceHelper.this.persistenceService.createAccidentalBatches(fishingOperationId, accidentalBatches);
                }
            }
        });
    }
}

