/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.csv;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportExportModel;
import fr.ifremer.tutti.service.csv.TuttiRepeatableExport;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public abstract class CsvProducer<O, M extends AbstractTuttiImportExportModel<O>>
implements Closeable {
    private final BufferedWriter writer;
    private final TuttiRepeatableExport<O> export;

    public CsvProducer(Path file, M model) {
        try {
            this.writer = Files.newWriter((File)file.toFile(), (Charset)Charsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            throw new ApplicationTechnicalException("file not found " + file, (Throwable)e);
        }
        this.export = new TuttiRepeatableExport(model);
    }

    @Override
    public void close() throws IOException {
        IOUtils.closeQuietly((Writer)this.writer);
    }

    public void write(O row) throws Exception {
        if (row != null) {
            ArrayList<O> rows = new ArrayList<O>(1);
            rows.add(row);
            this.write((List<O>)rows);
        }
    }

    public void write(List<O> rows) throws Exception {
        if (rows != null) {
            this.export.write(rows, this.writer);
        }
    }

    public void writeEmpty() throws Exception {
        this.export.write(Collections.emptyList(), this.writer);
    }
}

