/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.referential.location;

public class LocationUtils {
    private static final double EARTH_RADIUS = 6378288.0;

    protected LocationUtils() {
    }

    public static String computeStatisticalRectangle(Float latitude, Float longitude) {
        if (longitude == null || latitude == null) {
            return null;
        }
        String locationLabel = null;
        if (longitude.floatValue() >= 0.0f && longitude.floatValue() < 42.0f && latitude.floatValue() >= 30.0f && (double)latitude.floatValue() < 47.5 || longitude.floatValue() >= -6.0f && longitude.floatValue() < 0.0f && latitude.floatValue() >= 35.0f && latitude.floatValue() < 40.0f) {
            double nbdemidegreeLat = Math.floor(latitude.floatValue() - 30.0f) * 2.0;
            double nbdemidegreeLong = Math.floor(longitude.floatValue() + 6.0f) * 2.0;
            char letter = new Character((char)(Math.floor(nbdemidegreeLong / 10.0) + 65.0)).charValue();
            int rest = (int)(nbdemidegreeLong % 10.0);
            locationLabel = "M" + String.valueOf((int)nbdemidegreeLat) + letter + String.valueOf(rest);
        } else if (longitude.floatValue() >= -50.0f && longitude.floatValue() <= 70.0f && latitude.floatValue() >= 36.0f && latitude.floatValue() <= 89.0f) {
            int halfDegreesNb = (int)Math.floor((latitude.floatValue() - 36.0f) * 2.0f) + 1;
            double degreesNb = Math.floor(longitude.floatValue() + 50.0f);
            char letter = new Character((char)(Math.floor(degreesNb / 10.0) + 65.0)).charValue();
            int rest = (int)(degreesNb % 10.0);
            locationLabel = String.valueOf(halfDegreesNb) + letter + String.valueOf(rest);
        }
        return locationLabel;
    }

    public static int computeDistanceInMeters(Float startLatitude, Float startLongitude, Float endLatitude, Float endLongitude) {
        double sLat = (double)startLatitude.floatValue() * Math.PI / 180.0;
        double sLong = (double)startLongitude.floatValue() * Math.PI / 180.0;
        double eLat = (double)endLatitude.floatValue() * Math.PI / 180.0;
        double eLong = (double)endLongitude.floatValue() * Math.PI / 180.0;
        Double d = 6378288.0 * (1.5707963267948966 - Math.asin(Math.sin(eLat) * Math.sin(sLat) + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = Float.valueOf(distance.floatValue() / 1852.0f);
            distanceText = String.format("%.3f", distanceInMilles);
        } else {
            distanceText = "";
        }
        return distanceText;
    }
}

