/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.document;

import java.io.IOException;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.data.engine.olap.data.document.IRandomAccessObject;

public class RAWriter
implements IRandomAccessObject {
    private RAOutputStream outputStream;
    private long length;

    RAWriter(RAOutputStream outputStream) {
        this.outputStream = outputStream;
        this.length = 0L;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.flush();
        this.outputStream.close();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.outputStream.getOffset();
    }

    @Override
    public long length() throws IOException {
        return this.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long pos) throws IOException {
        this.outputStream.seek(pos);
    }

    @Override
    public void setLength(long newLength) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long start = this.getFilePointer();
        this.outputStream.write(b, off, len);
        if (start + (long)len > this.length) {
            this.length = start + (long)len;
        }
    }

    @Override
    public void flush() throws IOException {
        this.outputStream.flush();
    }

    @Override
    public int read() throws IOException {
        throw new UnsupportedOperationException();
    }
}

