/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.io.Serializable;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import org.nuiton.i18n.I18n;

public class AddCaracteristicMappingAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    protected Caracteristic caracteristic;
    protected EditProtocolCaracteristicsRowModel newRow;

    public AddCaracteristicMappingAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        EditProtocolUI ui = (EditProtocolUI)this.getUI();
        BeanFilterableComboBox<Caracteristic> caracteristicMappingCombBox = ui.getCaracteristicMappingComboBox();
        this.caracteristic = (Caracteristic)caracteristicMappingCombBox.getSelectedItem();
        Preconditions.checkNotNull((Object)this.caracteristic, (Object)"Can't add a speciesProtocol with a null species");
        this.newRow = ((EditProtocolUIHandler)this.handler).createEditProtocolCaracteristicsRowModel();
        this.newRow.setPsfm(this.caracteristic);
        ((EditProtocolUIModel)this.getModel()).addCaracteristicMappingRow(this.newRow);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditProtocolUI)this.getUI()).getCaracteristicMappingComboBox().removeItem((Object)this.caracteristic);
        EditProtocolCaracteristicsTableModel tableModel = ((EditProtocolUIHandler)this.getHandler()).getCaracteristicMappingTableModel();
        tableModel.addNewRow((Serializable)((Object)this.newRow));
        int rowIndex = tableModel.getRowIndex((Serializable)((Object)this.newRow));
        SwingUtil.setSelectionInterval((JTable)((EditProtocolUIHandler)this.handler).getCaracteristicsMappingTable(), (int)rowIndex);
        String caracteristicStr = this.decorate(this.caracteristic);
        this.sendMessage(I18n.t((String)"tutti.flash.info.caracteristic.add.to.protocol", (Object[])new Object[]{caracteristicStr}));
    }
}

