/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.computable;

import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableData;
import fr.ifremer.tutti.ui.swing.util.computable.ComputableDataEditor;
import fr.ifremer.tutti.util.Weights;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.DecimalFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jaxx.runtime.JAXXUtil;

public class ComputableDataTableCell
extends DefaultTableCellRenderer {
    private static final long serialVersionUID = 1L;

    public static TableCellRenderer newRender(TableCellRenderer renderer, WeightUnit weightUnit, Color computedDataColor) {
        return new TuttiComputedOrNotDataTableCellRenderer(renderer, true, weightUnit.getNumberDigits(), computedDataColor);
    }

    public static TableCellEditor newEditor(Class type, WeightUnit weightUnit, Color computedDataColor) {
        return new TuttiComputedOrNotDataTableCellEditor(type, false, true, weightUnit.getNumberDigits(), weightUnit.getNumberEditorPattern(), computedDataColor);
    }

    public static class TuttiComputedOrNotDataTableCellRenderer
    implements TableCellRenderer {
        protected final TableCellRenderer delegate;
        protected Integer decimalNumber;
        protected Color computedDataColor;
        protected boolean useFloat;

        public TuttiComputedOrNotDataTableCellRenderer(TableCellRenderer delegate, boolean useFloat, Integer decimalNumber, Color computedDataColor) {
            this.delegate = delegate;
            this.useFloat = useFloat;
            this.decimalNumber = decimalNumber;
            this.computedDataColor = computedDataColor;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            Color foreground;
            Font font;
            ComputableData data = (ComputableData)((Object)value);
            Object dataValue = data.getData();
            if (dataValue == null) {
                dataValue = data.getComputedData();
                font = TuttiUI.TEXTFIELD_COMPUTED_FONT;
                foreground = this.computedDataColor;
                if (this.useFloat && this.decimalNumber != null && dataValue != null) {
                    DecimalFormat decimalFormat = Weights.getDecimalFormat((int)1, (int)this.decimalNumber);
                    text = JAXXUtil.getStringValue((Object)decimalFormat.format(dataValue));
                } else {
                    text = JAXXUtil.getStringValue(dataValue);
                }
            } else {
                font = TuttiUI.TEXTFIELD_NORMAL_FONT;
                foreground = Color.BLACK;
                text = JAXXUtil.getStringValue(dataValue);
            }
            Component component = this.delegate.getTableCellRendererComponent(table, text, isSelected, hasFocus, row, column);
            if (isSelected) {
                font = font.deriveFont(1);
            }
            component.setFont(font);
            component.setForeground(foreground);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                jLabel.setHorizontalAlignment(4);
            }
            return component;
        }
    }

    public static class TuttiComputedOrNotDataTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    FocusListener,
    AncestorListener {
        private static final long serialVersionUID = 1L;
        protected final ComputableDataEditor numberEditor = new ComputableDataEditor();
        protected ComputableData data;

        public TuttiComputedOrNotDataTableCellEditor(Class type, boolean useSign, boolean useFloat, Integer decimalNumber, String numberPattern, Color computedDataColor) {
            this.numberEditor.setComputedDataColor(computedDataColor);
            this.numberEditor.getTextField().setHorizontalAlignment(4);
            this.numberEditor.getTextField().addFocusListener(this);
            this.numberEditor.getTextField().addAncestorListener(this);
            this.numberEditor.getTextField().setBorder(new LineBorder(Color.GRAY, 2));
            this.numberEditor.setSelectAllTextOnError(true);
            this.numberEditor.setNumberPattern(numberPattern);
            this.numberEditor.setNumberType(type);
            this.numberEditor.setUseSign(useSign);
            this.numberEditor.setDecimalNumber(decimalNumber);
            this.numberEditor.init();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.data = (ComputableData)((Object)value);
            this.numberEditor.setNumberValue((Number)this.data.getData());
            return this.numberEditor;
        }

        public ComputableDataEditor getNumberEditor() {
            return this.numberEditor;
        }

        public ComputableData getCellEditorValue() {
            return this.data;
        }

        @Override
        public void focusGained(FocusEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().requestFocus();
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().requestFocus();
                    TuttiComputedOrNotDataTableCellEditor.this.numberEditor.getTextField().selectAll();
                }
            });
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }

        @Override
        public boolean stopCellEditing() {
            boolean result = super.stopCellEditing();
            if (result) {
                this.data.setData(this.numberEditor.getModel().getNumberValue());
                this.numberEditor.setBean(null);
                this.data = null;
            }
            return result;
        }
    }
}

