/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.converter;

import java.util.ServiceLoader;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.converter.EnumConverter;
import org.nuiton.converter.NuitonConverter;

public class ConverterUtil {
    private static final Log LOGGER = LogFactory.getLog(ConverterUtil.class);
    protected static final String CONVERTER_PACKAGE = "org.nuiton.converter";
    private static Boolean wasInit = Boolean.FALSE;

    public static <T> Converter getConverter(Class<T> type) {
        Converter converter;
        if (!wasInit.booleanValue()) {
            ConverterUtil.initConverters();
        }
        if ((converter = ConvertUtils.lookup(type)) != null) {
            return converter;
        }
        if (type.isEnum()) {
            ConverterUtil.registerEnumConverter(type);
            return ConvertUtils.lookup(type);
        }
        try {
            ConverterUtil.registerConverter0(type);
            converter = ConvertUtils.lookup(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return converter;
    }

    public static <T> T convert(Class<T> type, Object toConvert) {
        if (!wasInit.booleanValue()) {
            ConverterUtil.initConverters();
        }
        Object result = null;
        Converter converter = ConverterUtil.getConverter(type);
        if (converter != null) {
            result = converter.convert(type, toConvert);
        }
        return (T)result;
    }

    public static void registerConverter(Class<?> type) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        if (ConvertUtils.lookup(type) == null) {
            ConverterUtil.registerConverter0(type);
        }
    }

    protected static void registerConverter0(Class<?> type) throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        Class<?> aClass = Class.forName("org.nuiton.converter." + type.getSimpleName() + "Converter");
        Converter converter = (Converter)aClass.newInstance();
        LOGGER.info((Object)("for type : " + type + " : " + converter));
        ConvertUtils.register((Converter)converter, type);
    }

    public static <E extends Enum> void registerEnumConverter(Class<E> type, Object defaultValue) {
        if (EnumConverter.isEnabled(type, type) && ConvertUtils.lookup(type) == null) {
            EnumConverter<E> converter = new EnumConverter<E>(type, defaultValue);
            LOGGER.info((Object)("for type : " + type + " : " + converter));
            ConvertUtils.register(converter, type);
        }
    }

    public static <E extends Enum> void registerEnumConverter(Class<E> type) {
        ConverterUtil.registerEnumConverter(type, null);
    }

    public static byte[] convert(char[] chars) {
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)(chars[i] & 0xFF);
        }
        return bytes;
    }

    public static synchronized void deregister() {
        ConvertUtils.deregister();
        wasInit = false;
    }

    public static synchronized void initConverters() {
        if (wasInit != null && wasInit.booleanValue()) {
            return;
        }
        ServiceLoader<NuitonConverter> converters = ServiceLoader.load(NuitonConverter.class);
        for (NuitonConverter converter : converters) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("discovered converter " + converter));
            }
            Class type = converter.getType();
            LOGGER.info((Object)("register converter " + converter));
            ConvertUtils.register((Converter)converter, type);
        }
        wasInit = true;
    }

    protected ConverterUtil() {
    }
}

