package fr.ifremer.tutti.ui.swing.util.attachment;

/*
 * #%L
 * Tutti :: UI
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2015 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import jaxx.runtime.swing.editor.FileEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import static org.nuiton.i18n.I18n.t;

public class AttachmentEditorUI extends JDialog implements TuttiUI<TuttiUIContext, AttachmentEditorUIHandler>, JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_BEAN = "bean";
    public static final String PROPERTY_EDITABLE = "editable";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1VQW8bRRQeO3Ya201JGyUEWkQKAVUc1kVCAilRaBKwGsuhCLtShC+MvZNkwnhnmH2LN4IifgI/Ae5ckLhxQhw4c+CC+AsIceCKeG/X3vXGa5xiySt75nvf++bNe99++wcr+5bdPedh6NjAAzkQTnPv+PhR71z04R3h9600oC2LP4UiK3ZZzU3WfWAvd1sUXh+F1w/0wGhPeBPR2y1W9eFCCf9MCAD2Qjai7/v1drK9HZrAjlkTUXmsX//1Z/Er98tvioyFBtXdxKNszotKT1JqsaJ0gd3CTJ/yuuLeKcqw0jtFvcu0dqC477/HB+IT9gW71mKLhlskA/bS1Y8ccUTxoQG2wgF4/2xAWMmVPgW2c2IdeWLFQFgHAgDpBNLxhyjDCUAqJ41w9pKf77oSkzw+NCbiXgS2JHCJ95QAdpO0O3QeZ19rJbiXwko9/Ats9/8kPdKuUHtDrEHKVx7QIrB7swk79Pfx4YH2QISQht5Ik+xr9wLYXW1PnXNsro9Bmzg4dJrHHQlKuO9zTyiKrCQEG1mCdt9qpQgH7FkqQTgS0Ex3KHItIagMuPQiYiTLNM5IOdWTsBtJSC3Nib1/K5MmkXg7gV/farYFdg3H27oPbD0ra7yTjamcSCVavEeqsgmixSy4RGBgWznqRdQjTgMBcbtcSsNddx+vBq+FrWbSxKtZ9DLloVFINLyaBSyNAZdP2cFLb0ih3Cx+hfA4OFTJWZzLWxNXd58Wn88CahMkwNam8u5ZwQn6hkFruJ2pEZqOk5pO6gqFLivbAJexJbrTPvUBbsUOtXHJoYgw2v1nffXXH37/vjG2pQrmXsuFTrgq2oWx2ggLklI/E3sSzWL9iJvtLrIIhZYcWe6dHGHt0TaKw3yxBUSj/JD7Z0hRvvbbjz+tf/TLAis2WFVp7jY44Q9ZBc4sVkErNzRvP4gUXR8u4XMFv0UscuC5oq+xUwW6ZQlsIGgO1JBf+I+8jjajxRCLcienKImyXuXnv1fb3z0YF6aAQp+bCU+LU/6QLUpPSU9Ejj0y41yHrhlfBK5OTTfPhlmOD5uRL+1Gz/2pOhTQ6oCMCKsf+xu/ZMZOtB0GFP8wOh39arIpo5uXCku+pGgiGtqig3xW3cQPNXr1CVUa2xqtcoaGExo0h8B5QlJneToNK6kGqvWEjlfm6qCAPC1ZQ3k6PaupntHwT0i6N1fSKCZP1ZQrzRO2AKyKcyS1d9gnJ11AV8VLk6+/5R15YqA92Qf22gxJcaCDIc4gAdcA39kdaTr/WeCJUJAm97ITf79Cby8qfqERzG7suBz4Zk96Lrro7hRxgZ7VuYy0/Dk9nuQzvHgFTSWrh/SO3YlnfxNrYGUvADFD1ZvI+S8QEby00QoAAA==";
    private static final Log log = LogFactory.getLog(AttachmentEditorUI.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton addButton;
    protected JXTitledPanel attachmentBody;
    protected JScrollPane attachmentBodyScrollPane;
    protected AttachmentEditorUI attachmentDialog = this;
    protected JPanel attachments;
    protected AttachmentModelAware bean;
    protected Boolean editable;
    protected FileEditor file;
    protected JTextArea fileComment;
    protected JLabel fileCommentLabel;
    protected JLabel fileLabel;
    protected JTextField fileName;
    protected JLabel fileNameLabel;
    protected final AttachmentEditorUIHandler handler = createHandler();
    protected Table mainPanel;
    protected TuttiUIContext model;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;
    private JSeparator $JSeparator0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
    
    public void openEditor(JComponent component) {
       handler.openEditor(component);
    }
    
    public void closeEditor() {
       handler.closeEditor();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AttachmentEditorUI(TuttiUIContext context) {
        super(context.getMainUI());
            TuttiUIUtil.setApplicationContext(this, context);
            $initialize();
    }

    public AttachmentEditorUI(Frame param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI() {
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Window param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0) {
        super(param0);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AttachmentEditorUI(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AttachmentEditorUI(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAttachment();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getAddButton() {
        return addButton;
    }

    public JXTitledPanel getAttachmentBody() {
        return attachmentBody;
    }

    public JScrollPane getAttachmentBodyScrollPane() {
        return attachmentBodyScrollPane;
    }

    public JPanel getAttachments() {
        return attachments;
    }

    public AttachmentModelAware getBean() {
        return bean;
    }

    public Boolean getEditable() {
        return editable;
    }

    public FileEditor getFile() {
        return file;
    }

    public JTextArea getFileComment() {
        return fileComment;
    }

    public JLabel getFileCommentLabel() {
        return fileCommentLabel;
    }

    public JLabel getFileLabel() {
        return fileLabel;
    }

    public JTextField getFileName() {
        return fileName;
    }

    public JLabel getFileNameLabel() {
        return fileNameLabel;
    }

    public AttachmentEditorUIHandler getHandler() {
        return handler;
    }

    public Table getMainPanel() {
        return mainPanel;
    }

    public TuttiUIContext getModel() {
        return model;
    }

    public Boolean isEditable() {
        return editable !=null && editable;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setBean(AttachmentModelAware bean) {
        AttachmentModelAware oldValue = this.bean;
        this.bean = bean;
        firePropertyChange(PROPERTY_BEAN, oldValue, bean);
    }

    public void setEditable(Boolean editable) {
        Boolean oldValue = this.editable;
        this.editable = editable;
        firePropertyChange(PROPERTY_EDITABLE, oldValue, editable);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected JSeparator get$JSeparator0() {
        return $JSeparator0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToAttachmentBody() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBody.add(attachmentBodyScrollPane);
    }

    protected void addChildrenToAttachmentBodyScrollPane() {
        if (!allComponentsCreated) {
            return;
        }
        attachmentBodyScrollPane.getViewport().add(mainPanel);
    }

    protected void addChildrenToAttachmentDialog() {
        if (!allComponentsCreated) {
            return;
        }
        add(attachmentBody, BorderLayout.CENTER);
    }

    protected void addChildrenToMainPanel() {
        if (!allComponentsCreated) {
            return;
        }
        mainPanel.add(attachments, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JSeparator0, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileLabel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(file, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(addButton, new GridBagConstraints(2, 2, 1, 3, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileNameLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileName, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add(fileCommentLabel, new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        mainPanel.add($JScrollPane0, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setToolTipText(t("tutti.attachmentEditor.action.add.tip"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createAttachmentBody() {
        $objectMap.put("attachmentBody", attachmentBody = new JXTitledPanel());
        
        attachmentBody.setName("attachmentBody");
        attachmentBody.setTitle(t("tutti.attachmentEditor.title"));
    }

    protected void createAttachmentBodyScrollPane() {
        $objectMap.put("attachmentBodyScrollPane", attachmentBodyScrollPane = new JScrollPane());
        
        attachmentBodyScrollPane.setName("attachmentBodyScrollPane");
    }

    protected void createAttachments() {
        $objectMap.put("attachments", attachments = new JPanel());
        
        attachments.setName("attachments");
        attachments.setLayout(new GridLayout(0, 1));
    }

    protected void createBean() {
        $objectMap.put("bean", bean = null);
    }

    protected void createEditable() {
        $objectMap.put("editable", editable = true);
    }

    protected void createFile() {
        $objectMap.put("file", file = new FileEditor());
        
        file.setName("file");
    }

    protected void createFileComment() {
        $objectMap.put("fileComment", fileComment = new JTextArea());
        
        fileComment.setName("fileComment");
        fileComment.setColumns(15);
        fileComment.setLineWrap(true);
        fileComment.setWrapStyleWord(true);
        fileComment.setRows(3);
    }

    protected void createFileCommentLabel() {
        $objectMap.put("fileCommentLabel", fileCommentLabel = new JLabel());
        
        fileCommentLabel.setName("fileCommentLabel");
        fileCommentLabel.setText(t("tutti.attachmentEditor.field.fileComment"));
    }

    protected void createFileLabel() {
        $objectMap.put("fileLabel", fileLabel = new JLabel());
        
        fileLabel.setName("fileLabel");
        fileLabel.setText(t("tutti.attachmentEditor.field.file"));
    }

    protected void createFileName() {
        $objectMap.put("fileName", fileName = new JTextField());
        
        fileName.setName("fileName");
        fileName.setColumns(15);
    }

    protected void createFileNameLabel() {
        $objectMap.put("fileNameLabel", fileNameLabel = new JLabel());
        
        fileNameLabel.setName("fileNameLabel");
        fileNameLabel.setText(t("tutti.attachmentEditor.field.fileName"));
    }

    protected AttachmentEditorUIHandler createHandler() {
        return new AttachmentEditorUIHandler();
    }

    protected void createMainPanel() {
        $objectMap.put("mainPanel", mainPanel = new Table());
        
        mainPanel.setName("mainPanel");
    }

    protected void createModel() {
        $objectMap.put("model", model = getContextValue(TuttiUIContext.class));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToAttachmentDialog();
        addChildrenToAttachmentBody();
        addChildrenToAttachmentBodyScrollPane();
        addChildrenToMainPanel();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(fileComment);
        
        // apply 7 property setters
        fileLabel.setLabelFor(
            file
        );
        addButton.setIcon(SwingUtil.createActionIcon("add"));
        addButton.setMnemonic(SwingUtil.getFirstCharAt(t("tutti.attachmentEditor.action.add.mnemonic"),'Z'));
        fileNameLabel.setLabelFor(
            fileName
        );
        fileCommentLabel.setLabelFor(
            fileComment
        );
        // late initializer
        attachmentDialog.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        handler.beforeInit(this);
        $objectMap.put("attachmentDialog", attachmentDialog);
        createEditable();
        createBean();
        createModel();
        createAttachmentBody();
        createAttachmentBodyScrollPane();
        createMainPanel();
        createAttachments();
        // inline creation of $JSeparator0
        $objectMap.put("$JSeparator0", $JSeparator0 = new JSeparator());
        
        $JSeparator0.setName("$JSeparator0");
        createFileLabel();
        createFile();
        createAddButton();
        createFileNameLabel();
        createFileName();
        createFileCommentLabel();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFileComment();
        // inline creation of attachmentDialog
        setName("attachmentDialog");
        attachmentDialog.getContentPane().setLayout(new BorderLayout());
        setUndecorated(true);
        setAlwaysOnTop(true);
        
        $completeSetup();
        handler.afterInit(this);
    }

}