/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    @Override
    public void doAction() throws Exception {
        TuttiProtocol saved;
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiUIContext context = this.getContext();
        PersistenceService persistenceService = context.getPersistenceService();
        TuttiProtocol bean = (TuttiProtocol)model.toBean();
        Collection<EditProtocolCaracteristicsRowModel> protocolCaracteristicMappingRows = ((EditProtocolUI)this.getUI()).getModel().getCaracteristicMappingRows();
        ArrayList caracteristicMappingRows = new ArrayList();
        for (EditProtocolCaracteristicsRowModel row : protocolCaracteristicMappingRows) {
            if (!row.isValid()) continue;
            caracteristicMappingRows.add(row.toEntity());
        }
        bean.setCaracteristicMapping(caracteristicMappingRows);
        List<EditProtocolOperationFieldsRowModel> protocolOperationFieldMappingRows = ((EditProtocolUI)this.getUI()).getModel().getOperationFieldMappingRows();
        ArrayList operationFieldMappingRows = new ArrayList();
        for (EditProtocolOperationFieldsRowModel row : protocolOperationFieldMappingRows) {
            if (!StringUtils.isNotBlank((CharSequence)row.getField()) || !StringUtils.isNotBlank((CharSequence)row.getImportColumn()) || !row.isValid()) continue;
            operationFieldMappingRows.add(row.toEntity());
        }
        bean.setOperationFieldMapping(operationFieldMappingRows);
        ArrayList speciesProtocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getSpeciesRow()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            speciesProtocols.add(protocol);
        }
        bean.setSpecies((List)speciesProtocols);
        ArrayList benthosProtocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getBenthosRow()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            benthosProtocols.add(protocol);
        }
        bean.setBenthos((List)benthosProtocols);
        if (log.isDebugEnabled()) {
            log.debug((Object)("protocol id to save: " + bean.getId()));
        }
        if (TuttiEntities.isNew((TuttiEntity)bean)) {
            saved = persistenceService.createProtocol(bean);
            model.setId(saved.getId());
            this.sendMessage(I18n.t((String)"tutti.flash.info.protocolCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            saved = persistenceService.saveProtocol(bean);
            this.sendMessage(I18n.t((String)"tutti.flash.info.protocolSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProtocolId(saved.getId());
        model.setModify(false);
    }

    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditProtocolUIHandler.getTitle(true));
        ((EditProtocolUI)this.getUI()).getSaveWarningContainer().setVisible(false);
    }
}

