/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.shared.application.swing.action;

import fr.ifremer.shared.application.swing.action.AbstractApplicationAction;
import fr.ifremer.shared.application.swing.action.ApplicationActionUI;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ApplicationActionSwingWorker<A extends AbstractApplicationAction>
extends SwingWorker<Void, String> {
    private static final Log log = LogFactory.getLog(ApplicationActionSwingWorker.class);
    private static final Timer t = new Timer();
    protected final ApplicationActionUI actionUI;
    protected final A action;
    protected Throwable error;
    protected TimerTask timer;

    protected ApplicationActionSwingWorker(A action) {
        this.action = action;
        this.actionUI = ((AbstractApplicationAction)((Object)action)).getContext().getActionUI();
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isFailed() {
        return this.error != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Void doInBackground() throws Exception {
        if (!this.isCancelled()) {
            this.timer = new TuttiActionTimerTask();
            t.schedule(this.timer, 1000L);
            try {
                ((AbstractApplicationAction)((Object)this.action)).doAction();
            }
            catch (Throwable e) {
                if (log.isErrorEnabled()) {
                    log.error((Object)("Task [" + this + "] Error while doAction: "), e);
                }
                this.error = e;
            }
            finally {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + this + "] done"));
                }
            }
        }
        return null;
    }

    @Override
    protected void done() {
        super.done();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Task [" + this + "] execute done method after all"));
        }
        if (this.error == null) {
            ((AbstractApplicationAction)((Object)this.action)).postSuccessAction();
        } else {
            ((AbstractApplicationAction)((Object)this.action)).postFailedAction(this.error);
        }
        ((AbstractApplicationAction)((Object)this.action)).releaseAction();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.actionUI.close();
        this.updateBusyState(false);
    }

    protected void updateBusyState(boolean busy) {
        boolean hideBody = ((AbstractApplicationAction)((Object)this.action)).isHideBody();
        ((AbstractApplicationAction)((Object)this.action)).getContext().setBusy(busy);
        if (hideBody) {
            ((AbstractApplicationAction)((Object)this.action)).getContext().setHideBody(!busy);
        }
    }

    protected class TuttiActionTimerTask
    extends TimerTask {
        public TuttiActionTimerTask() {
            ApplicationActionSwingWorker.this.action.addPropertyChangeListener("done", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if (ApplicationActionSwingWorker.this.actionUI.isVisible()) {
                        ApplicationActionSwingWorker.this.actionUI.close();
                    }
                    TuttiActionTimerTask.this.cancel();
                }
            });
        }

        @Override
        public void run() {
            if (ApplicationActionSwingWorker.this.isCancelled() || ApplicationActionSwingWorker.this.isDone()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + ApplicationActionSwingWorker.this.action + "] was already canceled or done, do nothing"));
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Task [" + ApplicationActionSwingWorker.this.action + "] is started, show waiting dialog"));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ApplicationActionSwingWorker.this.actionUI.open((AbstractApplicationAction)((Object)ApplicationActionSwingWorker.this.action));
                    }
                });
            }
        }
    }
}

