/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import fr.ifremer.tutti.service.catches.ValidateCruiseOperationsService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.ValidateCruiseUIModel;
import java.io.File;
import org.nuiton.i18n.I18n;

public class ExportCruiseValidationMessagesAction
extends AbstractTuttiAction<ValidateCruiseUIModel, ValidateCruiseUI, ValidateCruiseUIHandler> {
    protected File file;
    protected ValidateCruiseOperationsService validationService = this.getContext().getValidateCruiseOperationsService();

    public ExportCruiseValidationMessagesAction(ValidateCruiseUIHandler handler) {
        super(handler, false);
        this.setActionDescription(I18n._((String)"tutti.validateCruise.action.export.all.tip", (Object[])new Object[0]));
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile(String.format("validation_%s", this.getDataContext().getCruise().getName()), "txt", I18n._((String)"tutti.validateCruise.action.export.all.chooseFile.title", (Object[])new Object[0]), I18n._((String)"tutti.validateCruise.action.export.all.chooseFile.label", (Object[])new Object[0]), new String[0]);
            doAction = this.file != null;
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)this.getModel();
        this.validationService.exportValidationResults(this.file, uiModel.getValidator());
    }

    public void releaseAction() {
        super.releaseAction();
        this.file = null;
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.validateCruise.action.export.all.success", (Object[])new Object[]{this.file}));
    }
}

