/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service.technical.synchro;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.adagio.core.service.technical.synchro.ReferentialSynchroTableMetadata;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReferentialSynchroTableTool
implements Closeable {
    private static final Log log = LogFactory.getLog(ReferentialSynchroTableTool.class);
    protected final Connection connection;
    protected final ReferentialSynchroTableMetadata table;
    protected final PreparedStatement insertStatement;
    protected final PreparedStatement updateStatement;
    protected final int columnCount;
    protected final String tableName;
    protected int insertCount = 0;
    protected int updateCount = 0;
    protected boolean debug;

    public ReferentialSynchroTableTool(ReferentialSynchroTableTool tool, ReferentialSynchroTableMetadata table) throws SQLException {
        this(tool.connection, table);
    }

    public ReferentialSynchroTableTool(Connection connection, ReferentialSynchroTableMetadata table) throws SQLException {
        this.connection = connection;
        this.table = table;
        this.columnCount = table.getColumnsCount();
        this.tableName = table.getName();
        String insertSql = table.getInsertQuery();
        String updateSql = table.getUpdateQuery();
        this.insertStatement = connection.prepareStatement(insertSql);
        this.updateStatement = connection.prepareStatement(updateSql);
        this.debug = log.isTraceEnabled();
    }

    public void deleteAll() throws SQLException {
        PreparedStatement deleteStatement = this.connection.prepareStatement("DELETE FROM " + this.table.getName());
        deleteStatement.execute();
    }

    public Object[] findByPk(List<Object> pk) throws SQLException {
        String selectDataSql = this.table.getSelectDataQueryFromPk();
        PreparedStatement selectStatement = this.connection.prepareStatement(selectDataSql);
        int columnCountIndex = 1;
        for (Object pkColumn : pk) {
            selectStatement.setObject(columnCountIndex++, pkColumn);
        }
        int columnsCount = this.table.getColumnsCount();
        ResultSet resultSet = selectStatement.executeQuery();
        resultSet.next();
        Object[] result = new Object[columnsCount];
        for (int i = 1; i <= columnsCount; ++i) {
            result[i - 1] = resultSet.getObject(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getExistingPrimaryKeys() throws SQLException {
        String sql = this.table.getSelectPrimaryKeysQuery();
        PreparedStatement statement = this.connection.prepareStatement(sql);
        HashSet result = Sets.newHashSet();
        try {
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String pk = resultSet.getString(1);
                result.add(pk);
            }
            statement.close();
            HashSet hashSet = result;
            return hashSet;
        }
        finally {
            this.closeSilently(statement);
        }
    }

    public ResultSet getDataToUpdate(Date fromDate) throws SQLException {
        String sql = this.table.getSelectDataToUpdateQuery(fromDate);
        PreparedStatement statement = this.connection.prepareStatement(sql);
        if (this.table.isWithUpdateDateColumn() && fromDate != null) {
            statement.setTimestamp(1, new Timestamp(fromDate.getTime()));
        }
        statement.setFetchSize(1000);
        ResultSet result = statement.executeQuery();
        return result;
    }

    @Override
    public void close() throws IOException {
        this.closeSilently(this.insertStatement);
        this.closeSilently(this.updateStatement);
    }

    public void executeInsert(List<Object> pk, ResultSet incomingData) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        for (int c = 1; c <= this.columnCount; ++c) {
            Object object = incomingData.getObject(c);
            this.insertStatement.setObject(c, object);
            if (!this.debug) continue;
            params.add(object);
        }
        ++this.insertCount;
        this.insertStatement.addBatch();
        if (this.debug) {
            log.debug((Object)String.format("%s Execute insert query (pk:%s), params: %s", this.tableName, pk, params));
        }
        if (this.insertCount > 0 && this.insertCount % 1000 == 0) {
            this.insertStatement.executeBatch();
            this.insertStatement.clearBatch();
        }
    }

    public void executeInsert(List<Object> pk, Object[] incomingData) throws SQLException {
        for (int c = 1; c <= this.columnCount; ++c) {
            Object object = incomingData[c - 1];
            this.insertStatement.setObject(c, object);
        }
        ++this.insertCount;
        this.insertStatement.addBatch();
        if (this.debug) {
            log.debug((Object)String.format("%s Execute insert query (pk:%s), params: %s", this.tableName, pk, Arrays.toString(incomingData)));
        }
        if (this.insertCount > 0 && this.insertCount % 1000 == 0) {
            this.insertStatement.executeBatch();
            this.insertStatement.clearBatch();
        }
    }

    public void executeUpdate(List<Object> pk, ResultSet incomingData) throws SQLException {
        ArrayList params = null;
        if (this.debug) {
            params = Lists.newArrayList();
        }
        for (int c = 1; c <= this.columnCount; ++c) {
            Object object = incomingData.getObject(c);
            this.updateStatement.setObject(c, object);
            if (!this.debug) continue;
            params.add(object);
        }
        int columnCountIndex = this.columnCount + 1;
        for (Object pkColumn : pk) {
            this.updateStatement.setObject(columnCountIndex++, pkColumn);
        }
        ++this.updateCount;
        this.updateStatement.addBatch();
        if (this.debug) {
            log.debug((Object)String.format("%s Execute update query (pk:%s), params: %s", this.tableName, pk, params));
        }
        if (this.updateCount > 0 && this.updateCount % 1000 == 0) {
            this.updateStatement.executeBatch();
            this.updateStatement.clearBatch();
        }
    }

    public int getInsertCount() {
        return this.insertCount;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public void flushQueries() throws SQLException {
        if (this.insertCount > 0 && this.insertCount % 1000 != 0) {
            this.insertStatement.executeBatch();
        }
        if (this.updateCount > 0 && this.updateCount % 1000 != 0) {
            this.updateStatement.executeBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLastUpdateDate() throws SQLException {
        Timestamp result = null;
        if (this.table.isWithUpdateDateColumn()) {
            String sql = this.table.getSelectMaxUpdateDateQuery();
            PreparedStatement statement = this.connection.prepareStatement(sql);
            try {
                ResultSet resultSet = statement.executeQuery();
                if (resultSet.next()) {
                    result = resultSet.getTimestamp(1);
                }
                statement.close();
            }
            finally {
                this.closeSilently(statement);
            }
        }
        return result;
    }

    public long countDataToUpdate(Date fromDate) throws SQLException {
        String sql = this.table.getCountDataToUpdateQuery(fromDate);
        PreparedStatement statement = this.connection.prepareStatement(sql);
        if (this.table.isWithUpdateDateColumn() && fromDate != null) {
            statement.setTimestamp(1, new Timestamp(fromDate.getTime()));
        }
        ResultSet queryResult = statement.executeQuery();
        queryResult.next();
        long result = queryResult.getLong(1);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count() throws SQLException {
        String sql = this.table.getCountQuery();
        PreparedStatement statement = this.connection.prepareStatement(sql);
        try {
            ResultSet resultSet = statement.executeQuery();
            resultSet.next();
            long result = resultSet.getLong(1);
            statement.close();
            long l = result;
            return l;
        }
        finally {
            this.closeSilently(statement);
        }
    }

    void closeSilently(Statement statement) {
        block7: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block7;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public ReferentialSynchroTableMetadata getTable() {
        return this.table;
    }
}

