/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.report;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.shared.application.ApplicationTechnicalException;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.TuttiServiceContext;
import fr.ifremer.tutti.service.export.generic.TuttiExportService;
import fr.ifremer.tutti.service.report.ReportModel;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOption;
import org.nuiton.i18n.I18n;

public class ReportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ReportService.class);
    public static final FileFilter REPORT_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(".rptdesign");
        }
    };
    public static final String REPORT_FILENAME_PATTERN = "tutti-report-%s.pdf";
    public static final DateFormat df = new SimpleDateFormat("yyy-MM-dd_HH-mm");
    private static final int RENDER_DPI = 300;
    protected IReportEngineFactory factory;
    protected EngineConfig engineConfig;

    @Override
    public void setServiceContext(TuttiServiceContext context) {
        super.setServiceContext(context);
        this.engineConfig = new EngineConfig();
        this.engineConfig.setBIRTHome(context.getConfig().getReportHomeDirectory().getAbsolutePath());
        this.engineConfig.setResourcePath(context.getConfig().getReportHomeDirectory().getAbsolutePath());
        this.engineConfig.setLogConfig(context.getConfig().getReportLogDirectory().getAbsolutePath(), Level.FINE);
        try {
            Platform.startup((PlatformConfig)this.engineConfig);
        }
        catch (BirtException e) {
            throw new ApplicationTechnicalException("Could not init birt", (Throwable)e);
        }
        this.factory = (IReportEngineFactory)Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory");
    }

    public ReportModel createModel() {
        File defaultOutputFile = this.getDefaultOutputFile();
        ReportModel model = new ReportModel();
        model.setOutputFile(defaultOutputFile);
        return model;
    }

    public void generateReport(ReportModel model, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)model);
        Preconditions.checkNotNull((Object)model.getReport());
        Preconditions.checkState((boolean)model.getReport().exists());
        Preconditions.checkNotNull((Object)model.getCruiseId());
        Preconditions.checkNotNull((Object)model.getFishingOperationId());
        Preconditions.checkNotNull((Object)model.getOutputFile());
        progressionModel.increments(I18n._((String)"tutti.report.step.load.fishingOperation", (Object[])new Object[0]));
        FishingOperation operation = this.getService(PersistenceService.class).getFishingOperation(model.getFishingOperationId());
        progressionModel.increments(I18n._((String)"tutti.report.step.export.fishingOperation", (Object[])new Object[0]));
        File exportDirectory = this.getService(TuttiExportService.class).exportFishingOperation(model.getCruiseId(), model.getFishingOperationId());
        ReportContext reportContext = new ReportContext(model, operation, exportDirectory);
        this.generateReport(reportContext, progressionModel);
    }

    protected void generateReport(ReportContext reportContext, ProgressionModel progressionModel) {
        Preconditions.checkNotNull((Object)reportContext.getFishingOperation());
        Preconditions.checkNotNull((Object)reportContext.getExportDirectory());
        Preconditions.checkState((boolean)reportContext.getExportDirectory().exists());
        File dataDirectory = reportContext.getExportDirectory();
        if (log.isInfoEnabled()) {
            log.info((Object)("Will generate report using report " + reportContext.getReport().getName()));
        }
        progressionModel.increments(I18n._((String)"tutti.report.step.generateReport", (Object[])new Object[]{reportContext.getReport().getName()}));
        IReportEngine engine = this.factory.createReportEngine(this.engineConfig);
        try {
            IReportRunnable rptDoc = engine.openReportDesign(reportContext.getReport().getAbsolutePath());
            HashMap context = Maps.newHashMap();
            context.put("CHART_RESOLUTION", 300);
            RenderOption renderOption = new RenderOption();
            renderOption.setOutputFileName(reportContext.getOutputFile().getAbsolutePath());
            renderOption.setOutputFormat("pdf");
            IRunAndRenderTask task = engine.createRunAndRenderTask(rptDoc);
            task.setRenderOption((IRenderOption)renderOption);
            task.setAppContext((Map)context);
            task.setParameterValue("rpt-param_dirfile", (Object)dataDirectory.getAbsolutePath());
            task.setParameterValue("rpt-param_codestation", (Object)reportContext.getFishingOperation().getStationNumber());
            task.setParameterValue("rpt-param_numerotrait", (Object)reportContext.getFishingOperation().getFishingOperationNumber());
            task.run();
            task.close();
            if (log.isInfoEnabled()) {
                log.info((Object)("Report generated at " + reportContext.getOutputFile()));
            }
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not generate report", (Throwable)e);
        }
        finally {
            engine.destroy();
        }
    }

    @Override
    public void close() throws IOException {
        Platform.shutdown();
        super.close();
    }

    public List<File> getAvailableReports() {
        ArrayList result = Lists.newArrayList();
        File reportDirectory = this.context.getConfig().getReportDirectory();
        File[] files = reportDirectory.listFiles(REPORT_FILTER);
        if (files != null) {
            result.addAll(Arrays.asList(files));
        }
        return result;
    }

    public File getDefaultOutputFile() {
        String filename = String.format(REPORT_FILENAME_PATTERN, df.format(this.context.currentDate()));
        File result = new File(this.context.getConfig().getReportBackupDirectory(), filename);
        return result;
    }

    protected static class ReportContext {
        final ReportModel model;
        final FishingOperation fishingOperation;
        final File exportDirectory;

        public ReportContext(ReportModel model, FishingOperation fishingOperation, File exportFileDirectory) {
            this.model = model;
            this.fishingOperation = fishingOperation;
            this.exportDirectory = exportFileDirectory;
        }

        public File getExportDirectory() {
            return this.exportDirectory;
        }

        public FishingOperation getFishingOperation() {
            return this.fishingOperation;
        }

        public File getReport() {
            return this.model.getReport();
        }

        public File getOutputFile() {
            return this.model.getOutputFile();
        }
    }
}

