/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.psionimport;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.psionimport.PsionImportBatchModel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PsionImportModel {
    private static final Log log = LogFactory.getLog(PsionImportModel.class);
    protected final Map<String, PsionImportBatchModel> batchsByCategory = Maps.newLinkedHashMap();
    protected final List<String> errors = Lists.newArrayList();

    public boolean withBatchs() {
        return !this.batchsByCategory.isEmpty();
    }

    public Set<Species> getSpecies() {
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (PsionImportBatchModel batch : this.batchsByCategory.values()) {
            result.add(batch.getSpecies());
        }
        return result;
    }

    public List<PsionImportBatchModel> getBatchs(Species species) {
        ArrayList result = Lists.newArrayList();
        for (PsionImportBatchModel batch : this.batchsByCategory.values()) {
            if (!species.equals(batch.getSpecies())) continue;
            result.add(batch);
        }
        return result;
    }

    public boolean withErrors() {
        return !this.errors.isEmpty();
    }

    void addBatch(PsionImportBatchModel batchModel) {
        String cacheCode = batchModel.getSpecies().getSurveyCode() + "_" + batchModel.getCategoryCode();
        PsionImportBatchModel mergeBatch = this.batchsByCategory.get(cacheCode);
        if (mergeBatch == null) {
            this.batchsByCategory.put(cacheCode, batchModel);
            if (log.isInfoEnabled()) {
                log.info((Object)("Added " + batchModel));
            }
        } else {
            mergeBatch.setWeight(Float.valueOf(mergeBatch.getWeight().floatValue() + batchModel.getWeight().floatValue()));
            mergeBatch.setSampleWeight(Float.valueOf(mergeBatch.getSampleWeight().floatValue() + batchModel.getSampleWeight().floatValue()));
            for (Map.Entry<Float, MutableInt> entry : batchModel.getFrequencies().entrySet()) {
                Float stepClass = entry.getKey();
                int number = entry.getValue().intValue();
                mergeBatch.addFrequency(stepClass, number);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Merged " + batchModel + " to " + mergeBatch));
            }
        }
    }

    void addError(String error) {
        this.errors.add(error);
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

