/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesTableModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RemoveBenthosProtocolAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    protected Set<Species> removedSpecies;
    protected Set<EditProtocolSpeciesRowModel> removedRows;

    public RemoveBenthosProtocolAction(EditProtocolUIHandler handler) {
        super(handler, false);
    }

    @Override
    public void doAction() throws Exception {
        JXTable table = ((EditProtocolUIHandler)this.handler).getBenthosTable();
        Preconditions.checkState((!table.getSelectionModel().isSelectionEmpty() ? 1 : 0) != 0);
        EditProtocolSpeciesTableModel tableModel = (EditProtocolSpeciesTableModel)((Object)table.getModel());
        this.removedSpecies = Sets.newHashSet();
        this.removedRows = Sets.newHashSet();
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        int[] arr$ = SwingUtil.getSelectedModelRows((JTable)table);
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer rowIndex = arr$[i$];
            EditProtocolSpeciesRowModel selectedRow = (EditProtocolSpeciesRowModel)((Object)tableModel.getEntry(rowIndex));
            Species species = selectedRow.getSpecies();
            this.removedSpecies.add(species);
            Integer taxonId = species.getReferenceTaxonId();
            ArrayList allSynonyms = Lists.newArrayList(model.getAllSynonyms(String.valueOf(taxonId)));
            allSynonyms.remove(species);
            model.getAllSynonyms().addAll(allSynonyms);
            this.removedRows.add(selectedRow);
        }
        Collections.sort(model.getAllSynonyms(), TuttiEntities.SPECIES_BY_NAME_COMPARATOR);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        ((EditProtocolUI)this.getUI()).getBenthosComboBox().addItems(this.removedSpecies);
        ((EditProtocolUI)this.getUI()).getSpeciesComboBox().addItems(this.removedSpecies);
        ((EditProtocolUIModel)this.getModel()).getBenthosRow().removeAll(this.removedRows);
        ((EditProtocolUIHandler)this.handler).getBenthosTableModel().fireTableDataChanged();
        ((EditProtocolUIHandler)this.handler).getBenthosTable().clearSelection();
        this.sendMessage(I18n._((String)"tutti.flash.info.benthos.remove.from.protocol", (Object[])new Object[0]));
    }
}

