/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.action;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.pupitri.PupitriImportExportService;
import fr.ifremer.tutti.ui.swing.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportPupitriAction
extends AbstractTuttiAction<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ExportPupitriAction.class);
    private File file;

    public ExportPupitriAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile("tuttiProtocol-" + ((EditProtocolUIModel)this.getModel()).getName() + "-pupitri", "csv", I18n._((String)"tutti.editProtocol.title.choose.speciesExportFile", (Object[])new Object[0]), I18n._((String)"tutti.editProtocol.action.chooseProtocolSpeciesFile", (Object[])new Object[0]), new String[0]);
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export protocol species to file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        ArrayList speciesList = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getSpeciesRow()) {
            if (!row.isValid()) continue;
            Species species = row.getSpecies();
            species.setSurveyCode(row.getSpeciesSurveyCode());
            speciesList.add(species);
        }
        PupitriImportExportService service = this.getContext().getTuttiPupitriImportExportService();
        service.exportSpecies((List)speciesList, this.file);
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n._((String)"tutti.flash.info.species.exported.from.protocol", (Object[])new Object[]{this.file}));
    }
}

