/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout.area.impl;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.LayoutEngine;
import org.eclipse.birt.report.engine.nLayout.area.ILayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ForeignHtmlRegionArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RootArea;

public class ForeignHTMLRegionLayout
implements ILayout {
    private ContainerArea parent;
    private IForeignContent content;
    private LayoutContext context;

    public ForeignHTMLRegionLayout(ContainerArea parent, LayoutContext context, IForeignContent foreign) {
        this.parent = parent;
        this.content = foreign;
        this.context = context;
    }

    @Override
    public void layout() throws BirtException {
        LayoutContext regionLayoutContext = new LayoutContext();
        regionLayoutContext.setFormat("pdf");
        regionLayoutContext.setFixedLayout(true);
        regionLayoutContext.setLocale(this.context.getLocale());
        regionLayoutContext.setHtmlLayoutContext(this.context.getHtmlLayoutContext());
        regionLayoutContext.setMaxBP(Integer.MAX_VALUE);
        regionLayoutContext.setMaxHeight(Integer.MAX_VALUE);
        regionLayoutContext.setReport(this.context.getReport());
        ForeignHtmlRegionArea region = new ForeignHtmlRegionArea(this.content, regionLayoutContext);
        region.setParent(this.parent);
        ForeignHTMLRegionLayoutEngine regionLayoutEngine = new ForeignHTMLRegionLayoutEngine(region, regionLayoutContext);
        regionLayoutEngine.layout(this.content);
        if (this.parent != null) {
            int aHeight;
            this.parent.add(region);
            if (!this.parent.isInInlineStacking && this.context.isAutoPageBreak() && (aHeight = region.getAllocatedHeight()) + this.parent.getAbsoluteBP() > this.context.getMaxBP()) {
                this.parent.autoPageBreak();
                if (this.parent instanceof RootArea) {
                    return;
                }
            }
            this.parent.update(region);
        }
    }

    class ForeignHTMLRegionLayoutEngine
    extends LayoutEngine {
        protected ContainerArea root;

        public ForeignHTMLRegionLayoutEngine(ContainerArea container, LayoutContext context) {
            super(context);
            this.current = container;
            this.root = container;
            if (ForeignHTMLRegionLayout.this.parent != null) {
                this.current.setMaxAvaWidth(ForeignHTMLRegionLayout.this.parent.getMaxAvaWidth());
            }
        }

        public void layout(IContent content) throws BirtException {
            this.current.initialize();
            if (this.current.specifiedWidth > 0) {
                this.current.setMaxAvaWidth(this.current.specifiedWidth);
            }
            if (this.current.getSpecifiedHeight() <= 0) {
                this.visitChildren(content, this);
            }
            while (this.current != this.root) {
                this.current.close();
                this.current = this.current.getParent();
            }
            this.current.close();
        }
    }
}

