/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.shared.application.swing.util;

import fr.ifremer.shared.application.ApplicationBusinessException;
import fr.ifremer.shared.application.swing.ApplicationUIContext;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.i18n.I18n;

public class ApplicationErrorHelper
implements ErrorReporter {
    protected ApplicationUIContext context;

    public ApplicationErrorHelper(ApplicationUIContext context) {
        this.context = context;
    }

    public void showErrorDialog(String message, Throwable cause) {
        if (cause == null) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), "<html><body>" + message + "</body></html>", I18n._((String)"application.error.ui.business.error", (Object[])new Object[0]), 0);
        } else if (cause instanceof ApplicationBusinessException) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), "<html><body>" + cause.getMessage() + "</body></html>", I18n._((String)"application.error.ui.business.error", (Object[])new Object[0]), 0);
        } else if (cause instanceof ImportRuntimeException) {
            JOptionPane.showMessageDialog(this.context.getMainUI(), cause.getMessage(), I18n._((String)"application.error.ui.business.error", (Object[])new Object[0]), 0);
        } else {
            JXErrorPane pane = new JXErrorPane();
            ErrorInfo info = new ErrorInfo(I18n._((String)"application.error.ui.other.error", (Object[])new Object[0]), I18n._((String)"application.error.errorpane.htmlmessage", (Object[])new Object[]{message}), null, null, cause, null, null);
            pane.setErrorInfo(info);
            pane.setErrorReporter((ErrorReporter)this);
            JXErrorPane.showDialog((Component)this.context.getActionUI(), (JXErrorPane)pane);
        }
    }

    public void showErrorDialog(String message) {
        this.showErrorDialog(message, null);
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        this.showErrorDialog(errorInfo.getBasicErrorMessage(), errorInfo.getErrorException());
    }

    public void showWarningDialog(String message) {
        JOptionPane.showMessageDialog(this.context.getMainUI(), "<html><body>" + message + "</body></html>", I18n._((String)"application.error.ui.business.warning", (Object[])new Object[0]), 2);
    }
}

