/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.report;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.service.report.ReportService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.report.ReportUI;
import fr.ifremer.tutti.ui.swing.content.report.ReportUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.CloseableUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import jaxx.runtime.swing.editor.FileEditor;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class ReportUIHandler
extends AbstractTuttiUIHandler<ReportUIModel, ReportUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(ReportUIHandler.class);
    private final ReportService reportService;

    public ReportUIHandler(TuttiUI parentUi, ReportUI ui) {
        super(((AbstractTuttiUIHandler)parentUi.getHandler()).getContext(), ui);
        this.reportService = this.context.getReportService();
    }

    @Override
    public void beforeInitUI() {
        this.getDataContext().resetValidationDataContext();
        ReportUIModel model = new ReportUIModel();
        List reports = this.reportService.getAvailableReports();
        model.setReports(reports);
        File outputFile = this.reportService.getDefaultOutputFile();
        model.setOutputFile(outputFile);
        this.listModelIsModify(model);
        ((ReportUI)this.ui).setContextValue(model);
    }

    @Override
    public void afterInitUI() {
        this.initUI(this.ui);
        ReportUIModel model = (ReportUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(((ReportUI)this.ui).getReportComboBox(), Lists.newArrayList(model.getReports()), model.getReport());
        FileEditor inputFileField = ((ReportUI)this.ui).getInputFileField();
        inputFileField.setDirectoryEnabled(Boolean.valueOf(false));
        inputFileField.setFileEnabled(Boolean.valueOf(true));
        inputFileField.setExts(".csv");
        inputFileField.setExtsDescription("Fichier csv");
        FileEditor outputFileField = ((ReportUI)this.ui).getOutputFileField();
        outputFileField.setDirectoryEnabled(Boolean.valueOf(false));
        outputFileField.setFileEnabled(Boolean.valueOf(true));
        outputFileField.setExts(".pdf");
        outputFileField.setExtsDescription("Fichier pdf");
        SwingValidator<ReportUIModel> validator = ((ReportUI)this.ui).getValidator();
        this.listenValidatorValid((SimpleBeanValidator)validator, model);
        this.registerValidators(validator);
    }

    @Override
    protected JComponent getComponentToFocus() {
        return ((ReportUI)this.getUI()).getReportComboBox();
    }

    @Override
    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    @Override
    public boolean quitUI() {
        return true;
    }

    @Override
    public SwingValidator<ReportUIModel> getValidator() {
        return ((ReportUI)this.ui).getValidator();
    }

    public void showReport() {
        File file = ((ReportUIModel)((Object)this.getModel())).getOutputFile();
        Preconditions.checkState((boolean)file.exists());
        Desktop desktop = TuttiUIUtil.getDesktopForBrowse();
        try {
            desktop.browse(file.toURI());
        }
        catch (IOException e) {
            TuttiUIContext.getErrorHelper().showErrorDialog(I18n._((String)"swing.error.cannot.open.file", (Object[])new Object[0]));
        }
    }
}

