/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.individualobservation.create;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatch;
import fr.ifremer.tutti.persistence.entities.data.IndividualObservationBatchs;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.jdesktop.beans.AbstractSerializableBean;

public class CreateIndividualObservationBatchUIModel
extends AbstractTuttiBeanUIModel<IndividualObservationBatch, CreateIndividualObservationBatchUIModel> {
    private static final long serialVersionUID = 1L;
    public static final String PROPERTY_AVAILABLE_SPECIES = "availableSpecies";
    public static final String PROPERTY_BATCH_SPECIES = "batchSpecies";
    public static final String PROPERTY_SPECIES_FROM_BATCH = "speciesFromBatch";
    public static final String PROPERTY_SPECIES_FROM_BATCH_WITH_ONE_COUNT = "speciesFromBatchWihtOneCount";
    public static final String PROPERTY_CREATE_FROM_BATCH = "createFromBatch";
    public static final String PROPERTY_CARACTERISTICS = "caracteristics";
    protected List<Species> availableSpecies;
    protected Map<Species, Integer> batchSpecies;
    protected boolean createFromBatch;
    protected final IndividualObservationBatch editObject = IndividualObservationBatchs.newIndividualObservationBatch();
    protected final List<Caracteristic> defaultCaracteristic;
    protected final List<CaracteristicMapPropertyEditor> caracteristicEditors = Lists.newArrayList();

    public CreateIndividualObservationBatchUIModel(List<Caracteristic> defaultCaracteristic) {
        super(IndividualObservationBatch.class, null, null);
        this.defaultCaracteristic = defaultCaracteristic;
        this.editObject.setCaracteristics(new CaracteristicMap());
    }

    public Species getSpecies() {
        return this.editObject.getSpecies();
    }

    public void setSpecies(Species species) {
        Species oldValue = this.getSpecies();
        Boolean oldSpeciesFromBatch = this.isSpeciesFromBatch();
        Boolean oldSpeciesFromBatchWithOneCount = this.isSpeciesFromBatchWithOneCount();
        this.editObject.setSpecies(species);
        this.firePropertyChange("species", oldValue, species);
        this.firePropertyChange(PROPERTY_SPECIES_FROM_BATCH, oldSpeciesFromBatch, this.isSpeciesFromBatch());
        this.firePropertyChange(PROPERTY_SPECIES_FROM_BATCH_WITH_ONE_COUNT, oldSpeciesFromBatchWithOneCount, this.isSpeciesFromBatchWithOneCount());
    }

    public Float getWeight() {
        return this.editObject.getWeight();
    }

    public void setWeight(Float weight) {
        Float oldValue = this.getWeight();
        this.editObject.setWeight(weight);
        this.firePropertyChange("weight", oldValue, weight);
    }

    public Float getSize() {
        return this.editObject.getSize();
    }

    public void setSize(Float size) {
        Float oldValue = this.getSize();
        this.editObject.setSize(size);
        this.firePropertyChange("size", oldValue, size);
    }

    public Caracteristic getLengthStepCaracteristic() {
        return this.editObject.getLengthStepCaracteristic();
    }

    public void setLengthStepCaracteristic(Caracteristic lengthStepCaracteristic) {
        Caracteristic oldValue = this.getLengthStepCaracteristic();
        this.editObject.setLengthStepCaracteristic(lengthStepCaracteristic);
        this.firePropertyChange("lengthStepCaracteristic", oldValue, lengthStepCaracteristic);
    }

    public CaracteristicMap getCaracteristics() {
        return this.editObject.getCaracteristics();
    }

    public void setCaracteristics(CaracteristicMap caracteristics) {
        this.editObject.setCaracteristics(caracteristics);
        this.firePropertyChange(PROPERTY_CARACTERISTICS, null, caracteristics);
    }

    public List<Species> getAvailableSpecies() {
        return this.availableSpecies;
    }

    public void setAvailableSpecies(List<Species> availableSpecies) {
        this.availableSpecies = availableSpecies;
        this.firePropertyChange(PROPERTY_AVAILABLE_SPECIES, null, availableSpecies);
    }

    public Map<Species, Integer> getBatchSpecies() {
        return this.batchSpecies;
    }

    public boolean isSpeciesFromBatch() {
        return MapUtils.isNotEmpty(this.batchSpecies) && this.getSpecies() != null && this.batchSpecies.containsKey(this.getSpecies());
    }

    public boolean isSpeciesFromBatchWithOneCount() {
        return this.isSpeciesFromBatch() && this.batchSpecies.get(this.getSpecies()) == 1;
    }

    public boolean isSpeciesFromBatchWithCount() {
        return this.isSpeciesFromBatch() && this.batchSpecies.get(this.getSpecies()) > 0;
    }

    public void setBatchSpecies(Map<Species, Integer> batchSpecies) {
        this.batchSpecies = batchSpecies;
        this.firePropertyChange(PROPERTY_BATCH_SPECIES, null, batchSpecies);
        this.firePropertyChange(PROPERTY_SPECIES_FROM_BATCH, null, this.isSpeciesFromBatch());
        this.firePropertyChange(PROPERTY_SPECIES_FROM_BATCH_WITH_ONE_COUNT, null, this.isSpeciesFromBatchWithOneCount());
        this.setCreateFromBatch(this.isCreateFromBatch());
    }

    public boolean isCreateFromBatch() {
        return this.createFromBatch;
    }

    public void setCreateFromBatch(boolean createFromBatch) {
        Boolean oldValue = this.isCreateFromBatch();
        this.createFromBatch = createFromBatch;
        this.firePropertyChange(PROPERTY_CREATE_FROM_BATCH, oldValue, createFromBatch);
    }

    @Override
    protected IndividualObservationBatch newEntity() {
        return IndividualObservationBatchs.newIndividualObservationBatch();
    }

    public void reset() {
        this.setAvailableSpecies(Lists.newArrayList());
        this.setBatchSpecies(Maps.newHashMap());
        this.setSpecies(null);
        this.setWeight(null);
        this.setSize(null);
        this.setLengthStepCaracteristic(null);
        for (CaracteristicMapPropertyEditor editor : this.caracteristicEditors) {
            editor.setProperty(null);
        }
        this.getCaracteristics().clear();
    }

    public CaracteristicMapPropertyEditor newCaracteristicEditor(Caracteristic caracteristic) {
        CaracteristicMapPropertyEditor editor = new CaracteristicMapPropertyEditor(caracteristic);
        this.caracteristicEditors.add(editor);
        return editor;
    }

    public class CaracteristicMapPropertyEditor
    extends AbstractSerializableBean {
        private static final long serialVersionUID = 1L;
        public static final String PROPERTY_PROPERTY = "property";
        private final Caracteristic caracteristic;
        protected Serializable property;

        public Serializable getProperty() {
            return this.property;
        }

        public void setProperty(Serializable property) {
            Serializable oldValue = this.getProperty();
            this.property = property;
            CreateIndividualObservationBatchUIModel.this.getCaracteristics().put((Object)this.caracteristic, (Object)property);
            if (ObjectUtils.notEqual((Object)oldValue, (Object)property)) {
                this.firePropertyChange(PROPERTY_PROPERTY, oldValue, property);
                CreateIndividualObservationBatchUIModel.this.firePropertyChanged(CreateIndividualObservationBatchUIModel.PROPERTY_CARACTERISTICS, null, CreateIndividualObservationBatchUIModel.this.getCaracteristics());
            }
        }

        public CaracteristicMapPropertyEditor(Caracteristic caracteristic) {
            this.caracteristic = caracteristic;
        }
    }
}

