package fr.ifremer.tutti.ui.swing.content.operation.catches;

/*
 * #%L
 * Tutti :: UI
 * $Id: ExportFishingOperationForSumatraAction.java 1268 2013-10-02 23:39:48Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/tags/tutti-2.8/tutti-ui-swing/src/main/java/fr/ifremer/tutti/ui/swing/content/operation/catches/ExportFishingOperationForSumatraAction.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.sumatra.CatchesSumatraExportService;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.DateUtil;

import java.io.File;
import java.util.Date;

import static org.nuiton.i18n.I18n._;

/**
 * Created on 10/1/13.
 *
 * @author Tony Chemit <chemit@codelutin.com>
 * @since 2.7
 */
public class ExportFishingOperationForSumatraAction extends AbstractTuttiAction<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {

    /** Logger. */
    private static final Log log =
            LogFactory.getLog(ExportFishingOperationForSumatraAction.class);

    protected File file;

    public ExportFishingOperationForSumatraAction(EditCatchesUIHandler handler) {
        super(handler, true);
    }

    @Override
    public boolean prepareAction() throws Exception {

        boolean doAction = super.prepareAction();

        if (doAction) {

            FishingOperation fishingOperation = getModel().getFishingOperation();

            String date = DateUtil.formatDate(new Date(), "dd-MM-yyyy");
            // choose file to export
            file = saveFile(
                    String.format("sumatra_%s_%s_%s", getDataContext().getCruise().getName(), fishingOperation.getId(), date),
                    "csv",
                    _("tutti.exportFishingOperationForSumatra.title.choose.exportFile"),
                    _("tutti.exportFishingOperationForSumatra.action.chooseFile"),
                    "^.+\\.csv$", _("tutti.common.file.csv")
            );
            doAction = file != null;
        }
        return doAction;
    }

    @Override
    public void releaseAction() {
        file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Cruise cruise = getDataContext().getCruise();
        FishingOperation fishingOperation = getModel().getFishingOperation();
        Preconditions.checkNotNull(cruise);
        Preconditions.checkNotNull(fishingOperation);
        Preconditions.checkNotNull(file);

        if (log.isInfoEnabled()) {
            log.info("Will export fishingOperation " + cruise.getId() + "-" + fishingOperation.getStationNumber() +
                     " to file: " + file);
        }

        // export catches
        CatchesSumatraExportService service =
                getContext().getCatchesSumatraExportService();
        service.exportFishingOperationForSumatra(file,
                                                 cruise.getId(),
                                                 fishingOperation.getId());

    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        sendMessage(_("tutti.exportFishingOperationForSumatra.action.success", file));
    }
}
