/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.ui.swing.TuttiApplicationUpdaterCallBack;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.AbstractMainUITuttiAction;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.UpdateApplicationAction;
import fr.ifremer.tutti.ui.swing.content.UpdateDbAction;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.action.AbstractTuttiAction;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import jaxx.runtime.swing.AboutPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.updater.ApplicationInfo;
import org.nuiton.updater.ApplicationUpdater;

public class ShowAboutAction
extends AbstractMainUITuttiAction {
    private static final Log log = LogFactory.getLog(ShowAboutAction.class);
    protected AboutPanel about;
    protected boolean canUpdate;

    public ShowAboutAction(MainUIHandler handler) {
        super(handler, false);
    }

    @Override
    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            TuttiUIContext context = this.getContext();
            this.canUpdate = context.checkUpdateApplicationReachable();
        }
        return doAction;
    }

    @Override
    public void postSuccessAction() {
        super.postSuccessAction();
        this.about.showInDialog((Frame)this.getUI(), true);
        this.getContext().getSwingSession().add((Component)this.about);
    }

    @Override
    public void doAction() throws Exception {
        this.about = null;
        String iconPath = "/icons/allegro_about.png";
        String name = "tutti";
        String licensePath = "META-INF/" + name + "-LICENSE.txt";
        String thirdPartyPath = "META-INF/" + name + "-THIRD-PARTY.txt";
        this.about = new AboutPanel();
        this.about.setTitle(I18n._((String)"tutti.about.title", (Object[])new Object[0]));
        this.about.setAboutText(I18n._((String)"tutti.about.message", (Object[])new Object[0]));
        TuttiApplicationConfig config = this.getContext().getConfig();
        int currentYear = Calendar.getInstance().get(1);
        int inceptionYear = config.getInceptionYear();
        String years = currentYear != inceptionYear ? inceptionYear + "-" + currentYear : inceptionYear + "";
        this.about.setBottomText(I18n._((String)"tutti.about.bottomText", (Object[])new Object[]{config.getOrganizationName(), years, config.getVersion()}));
        this.about.setIconPath(iconPath);
        this.about.setLicenseFile(licensePath);
        this.about.setThirdpartyFile(thirdPartyPath);
        this.about.buildTopPanel();
        JScrollPane translatePane = new JScrollPane();
        JEditorPane translateArea = new JEditorPane();
        translateArea.setContentType("text/html");
        translateArea.setEditable(false);
        if (translateArea.getFont() != null) {
            translateArea.setFont(translateArea.getFont().deriveFont(11.0f));
        }
        translateArea.setBorder(null);
        File csvFile = new File(config.getI18nDirectory(), "tutti-i18n.csv");
        String translateText = I18n._((String)"tutti.about.translate.content", (Object[])new Object[]{csvFile.toURI().toURL()});
        translateArea.setText(translateText);
        translatePane.getViewport().add(translateArea);
        translateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (log.isInfoEnabled()) {
                        log.info((Object)("edit url: " + url));
                    }
                    TuttiUIUtil.openLink(url);
                }
            }
        });
        this.about.getTabs().add(I18n._((String)"tutti.about.translate.title", (Object[])new Object[0]), translatePane);
        if (this.canUpdate) {
            this.addUpdateTab(config);
        }
        this.about.init();
    }

    protected void addUpdate(Map<String, ApplicationInfo> source, Map<String, ApplicationInfo> target, String type) {
        ApplicationInfo info = source.get(type.toLowerCase());
        target.put(type, info);
    }

    protected void addUpdateTab(TuttiApplicationConfig config) {
        File current = config.getTuttiBasedir();
        String urlApplication = config.getUpdateApplicationUrl();
        String urlDb = config.getUpdateDbUrl();
        ApplicationUpdater up = new ApplicationUpdater();
        Map applicationVersions = up.getVersions(urlApplication, current);
        Map dbVersions = up.getVersions(urlDb, config.getDataDirectory());
        TreeMap versions = Maps.newTreeMap();
        this.addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.JRE.name());
        this.addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.TUTTI.name());
        this.addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.I18N.name());
        this.addUpdate(applicationVersions, versions, TuttiApplicationUpdaterCallBack.UpdateType.HELP.name());
        this.addUpdate(dbVersions, versions, "db");
        JScrollPane updatePane = new JScrollPane();
        JEditorPane updateArea = new JEditorPane();
        updateArea.setContentType("text/html");
        updateArea.setEditable(false);
        if (updateArea.getFont() != null) {
            updateArea.setFont(updateArea.getFont().deriveFont(11.0f));
        }
        updateArea.setBorder(null);
        ArrayList params = Lists.newArrayList();
        for (Map.Entry entry : versions.entrySet()) {
            String appName = (String)entry.getKey();
            ApplicationInfo info = (ApplicationInfo)entry.getValue();
            String oldVersion = info.oldVersion;
            String newVersion = info.newVersion;
            String i18nKey = "tutti.update." + appName.toLowerCase();
            String appLabel = I18n._((String)i18nKey, (Object[])new Object[0]);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Module %s, version courante %s, nouvelle version %s", appLabel, oldVersion, newVersion));
            }
            if (newVersion == null) {
                params.add(I18n._((String)"tutti.about.update.app.noup.detail", (Object[])new Object[]{appLabel, oldVersion}));
                continue;
            }
            params.add(I18n._((String)"tutti.about.update.app.up.detail", (Object[])new Object[]{appLabel, oldVersion, newVersion, appName}));
        }
        String updateText = I18n._((String)"tutti.about.update.content", (Object[])new Object[]{urlApplication, urlDb, Joiner.on((String)"\n").join((Iterable)params)});
        updateArea.setText(updateText);
        updatePane.getViewport().add(updateArea);
        updateArea.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (HyperlinkEvent.EventType.ACTIVATED == e.getEventType()) {
                    URL url = e.getURL();
                    if (url != null) {
                        TuttiUIUtil.openLink(url);
                    } else {
                        AbstractTuttiAction action;
                        String appType = e.getDescription();
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Open url: " + appType));
                        }
                        if ("db".equals(appType)) {
                            UpdateDbAction logicAction;
                            action = logicAction = TuttiActionHelper.createLogicAction(ShowAboutAction.this.getHandler(), UpdateDbAction.class);
                            if (!ShowAboutAction.this.getContext().isDbExist()) {
                                action.setActionDescription(I18n._((String)"tutti.dbManager.action.installDb.tip", (Object[])new Object[0]));
                            }
                        } else {
                            TuttiApplicationUpdaterCallBack.UpdateType updateType = TuttiApplicationUpdaterCallBack.UpdateType.valueOf(appType.toUpperCase());
                            UpdateApplicationAction logicAction = TuttiActionHelper.createLogicAction(ShowAboutAction.this.getHandler(), UpdateApplicationAction.class);
                            logicAction.setTypes(updateType);
                            logicAction.setActionDescription(I18n._((String)"tutti.main.action.updateSpecificApplication.tip", (Object[])new Object[]{updateType.getLabel()}));
                            action = logicAction;
                        }
                        TuttiActionHelper.runAction(ShowAboutAction.this.about.getClose());
                        TuttiActionHelper.runAction(action);
                    }
                }
            }
        });
        this.about.getTabs().add(I18n._((String)"tutti.about.update.title", (Object[])new Object[0]), updatePane);
    }
}

