/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing;

import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.config.TuttiApplicationConfig;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.content.MainUIHandler;
import fr.ifremer.tutti.ui.swing.content.StartAction;
import fr.ifremer.tutti.ui.swing.content.UpdateApplicationAction;
import fr.ifremer.tutti.ui.swing.util.TuttiExceptionHandler;
import fr.ifremer.tutti.ui.swing.util.action.TuttiActionHelper;
import java.awt.Color;
import java.util.Arrays;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RunTutti {
    private static final Log log = LogFactory.getLog(RunTutti.class);
    public static final int DELETE_DB_EXIT_CODE = 89;
    public static final int UPATE_EXIT_CODE = 88;
    public static final int NORMAL_EXIT_CODE = 0;

    public static void main(String ... args) {
        TuttiUIContext context;
        TuttiApplicationConfig config;
        block8: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Starting Tutti with arguments: " + Arrays.toString(args)));
            }
            Thread.setDefaultUncaughtExceptionHandler(new TuttiExceptionHandler());
            config = new TuttiApplicationConfig("tutti.config", args);
            context = TuttiUIContext.newContext(config);
            context.init();
            try {
                SwingUtil.initNimbusLoookAndFeel();
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block8;
                log.warn((Object)"Failed to init nimbus look and feel");
            }
        }
        boolean reload = false;
        if (config.isFullLaunchMode()) {
            boolean canUpdate;
            if (log.isInfoEnabled()) {
                log.info((Object)"Full launch mode, try to update.");
            }
            if (canUpdate = context.checkUpdateApplicationReachable()) {
                UpdateApplicationAction logicAction = TuttiActionHelper.createLogicAction(new MainUIHandler(context), UpdateApplicationAction.class);
                TuttiActionHelper.runActionAndWait(logicAction);
                reload = logicAction.isReload();
            }
        }
        if (!reload) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Will start Tutti...");
            }
            RunTutti.startTutti(context, true);
        }
    }

    public static void startTutti(TuttiUIContext context, boolean openContext) {
        if (openContext) {
            context.open();
        }
        UIManager.put("Table.alternateRowColor", context.getConfig().getColorAlternateRow());
        UIManager.put("Table[Disabled+Selected].textBackground", context.getConfig().getColorSelectedRow());
        UIManager.put("Table[Enabled+Selected].textBackground", context.getConfig().getColorSelectedRow());
        UIManager.put("Table.focusCellHighlightBorder", new BorderUIResource.LineBorderUIResource(Color.BLACK));
        final MainUI mainUI = new MainUI(context);
        context.addMessageNotifier(mainUI.getHandler());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                mainUI.setVisible(true);
            }
        });
        StartAction uiAction = TuttiActionHelper.createLogicAction(mainUI.getHandler(), StartAction.class);
        TuttiActionHelper.runAction(uiAction);
    }

    public static void closeTutti(MainUIHandler handler, Integer exitCode) {
        TuttiUIContext context = handler.getContext();
        handler.onCloseUI();
        context.getSwingSession().save();
        context.close();
        if (exitCode != null) {
            System.exit(exitCode);
        }
    }
}

